/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph;

import frc.emul.api.IDevice;
import frc.emul.api.IDeviceEvent;
import frc.emul.api.IDeviceEventManager;
import frc.emul.api.IDevicesListener;
import frc.emul.api.IDevicesManager;
import frc.emul.api.ILogger;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.api.ui.IDisplay;
import frc.emul.api.ui.IDisplayListener;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemPeripheral;
import frc.emul.config.data.DevOptions;
import frc.emul.mc6809.MC6809;
import frc.emul.periph.Analog;
import frc.emul.periph.DeviceEvent;
import frc.emul.periph.IPeripheral;
import frc.emul.periph.googles.Goggles;
import frc.emul.periph.joystick.JInputJoystick;
import frc.emul.periph.joystick.Joystick;
import frc.emul.periph.keyboard.PS2Keyboard;
import frc.emul.periph.lightpen.Lightpen;
import frc.emul.periph.misc.NullDevice;
import frc.emul.periph.vecvoice.VecVoice;
import frc.emul.psg.IVectrexAudio;
import frc.emul.util.AttributesMap;
import frc.emul.vectrex.PersistentSection;
import frc.emul.via6522.I6522Core;
import frc.emul.via6522.I6522ExternalLines;
import frc.emul.via6522.I6522TimerListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class Peripherals
implements IDevicesManager,
IDeviceEventManager,
IDisplayListener,
I6522TimerListener,
IPersistentObject {
    private static final boolean DEBUG = false;
    public static final String ID_NULL = "NULL";
    public static final String ID_JOYSTICK = "JOYSTICK";
    public static final String ID_CONTROLLER = "CONTROLLER";
    public static final String ID_KEYBOARD = "KEYBOARD";
    public static final String ID_VECVOICE = "VECVOICE";
    public static final String ID_LIGHTPEN = "LIGHTPEN";
    public static final String ID_GOGGLES = "3D-GOGGLES";
    private final Analog analog;
    private final List<IPeripheral.FrameHandler> frameHandlers;
    private IPeripheral.WriteHandler writeHandler;
    private IPeripheral.TickHandler tickHandler;
    private boolean emulateFIRQ = DevOptions.alwaysEmulateFIRQ;
    private boolean emulateCA1;
    private final IDevice[] ports = new IDevice[]{NullDevice.SHARED, NullDevice.SHARED};
    private final List<IDevicesListener> devListeners = new ArrayList<IDevicesListener>();
    private final I6522ExternalLines lines;
    private final Configuration conf;
    private final IVectrexAudio audio;
    private final MC6809 cpu;
    private int timer2Count;
    private int psgReg;
    private IDisplay display;

    public Peripherals(Configuration configuration, ILogger iLogger, I6522ExternalLines i6522ExternalLines, I6522Core i6522Core, IVectrexAudio iVectrexAudio, MC6809 mC6809) {
        this.frameHandlers = new ArrayList<IPeripheral.FrameHandler>();
        this.conf = configuration;
        this.lines = i6522ExternalLines;
        this.audio = iVectrexAudio;
        this.cpu = mC6809;
        this.analog = new Analog(configuration, iLogger, i6522ExternalLines);
        i6522Core.addTimerListener(this);
    }

    public synchronized void setDisplay(IDisplay iDisplay) {
        if (this.display != null) {
            throw new IllegalStateException("The display has already been set");
        }
        this.analog.setDisplay(iDisplay);
        this.display = iDisplay;
        this.display.addDisplayListener(this);
    }

    public void initialise() {
        this.conf.reconcilePeripherals();
        int n = 0;
        while (n <= 1) {
            CfgItemPeripheral cfgItemPeripheral = this.conf.portsDevices[n];
            IDevice iDevice = this.createDevice(n, cfgItemPeripheral.deviceID, cfgItemPeripheral.attrs);
            this.setPort(n, iDevice);
            ++n;
        }
        this.analog.initialise();
    }

    public void shutdown() {
        int n = 0;
        while (n <= 1) {
            this.setPort(n, NullDevice.SHARED);
            ++n;
        }
    }

    public void reset() {
        this.analog.reset();
        this.psgReg = 0;
    }

    public boolean tick(int n) {
        if (this.tickHandler != null) {
            this.tickHandler.handleTick(n);
        }
        this.audio.tick(n);
        return this.display.tick(n);
    }

    public void step() {
        this.analog.step(this.lines.read_PB());
    }

    public void stepped() {
        int n;
        int n2 = this.lines.read_PB();
        int n3 = this.lines.read_PA();
        byte by = (byte)n3;
        switch (n2 & 0x18) {
            case 0: {
                break;
            }
            case 8: {
                int n4 = 14 == this.psgReg ? this.ports[0].getButtonsState() | this.ports[1].getButtonsState() << 4 : this.audio.getPSG().readRegister(this.psgReg);
                this.lines.write_PA(n4);
                break;
            }
            case 16: {
                if (this.writeHandler != null) {
                    this.writeHandler.handleWrite(this.psgReg, by);
                }
                this.audio.getPSG().writeRegister(this.psgReg, by);
                break;
            }
            case 24: {
                this.psgReg = by & 0xF;
            }
        }
        switch (n2 & 7) {
            case 0: {
                this.analog.rY = by;
            }
            case 1: {
                n = this.getJoyX1();
                break;
            }
            case 2: {
                this.analog.rREF = by;
            }
            case 3: {
                n = this.getJoyY1();
                break;
            }
            case 4: {
                this.analog.rZ = by;
            }
            case 5: {
                n = this.getJoyX2();
                break;
            }
            case 6: {
                this.audio.outputDAC(by);
            }
            case 7: {
                n = this.getJoyY2();
                break;
            }
            default: {
                return;
            }
        }
        this.analog.rX = by;
        if (this.emulateFIRQ) {
            this.cpu.getSimulator().setLineFIRQ((this.ports[0].getButtonsState() & 8) == 0);
        }
        if (this.emulateCA1) {
            this.lines.write_CA1((this.ports[1].getButtonsState() & 8) != 0);
        }
        this.lines.write_PB(n >= by ? 32 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameCompleted() {
        if (!this.frameHandlers.isEmpty()) {
            List<IPeripheral.FrameHandler> list = this.frameHandlers;
            synchronized (list) {
                int n = this.frameHandlers.size();
                while (n-- > 0) {
                    this.frameHandlers.get(n).handleNewFrame();
                }
            }
        }
        this.analog.frameCompleted();
        this.audio.frameUpdate();
    }

    public void pauseStatusUpdate(boolean bl) {
        this.audio.setPaused(bl);
    }

    public void timerStarting(int n, int n2) {
        if (2 == n) {
            if (n2 >= 10000) {
                this.display.frameCompleted(this.timer2Count);
            }
            if (this.timer2Count != n2) {
                this.timer2Count = n2;
            }
        }
    }

    public void timerTimeout(int n) {
    }

    public IPersistentSection getSection() {
        return null;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.openSection(PersistentSection.PERIPH);
        iPersistenceWriter.write8(this.psgReg);
        iPersistenceWriter.closeSection();
        iPersistenceWriter.write(this.analog);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.openSection(PersistentSection.PERIPH);
        this.psgReg = iPersistenceReader.readU8();
        iPersistenceReader.closeSection();
        iPersistenceReader.read(this.analog);
    }

    public final void addDevicesListener(IDevicesListener iDevicesListener) {
        this.devListeners.add(iDevicesListener);
    }

    public final void removeDevicesListener(IDevicesListener iDevicesListener) {
        this.devListeners.remove(iDevicesListener);
    }

    public final IDevice getPort(int n) {
        return this.ports[n];
    }

    public final void applyConfiguration(Configuration configuration) {
        this.ports[0].applyConfiguration(configuration, 0);
        this.ports[1].applyConfiguration(configuration, 1);
    }

    private void synchronizeConfigurationPeriph(int n, Configuration configuration) {
        CfgItemPeripheral cfgItemPeripheral = configuration.portsDevices[n];
        if (!this.comparePort(n, cfgItemPeripheral.deviceID, cfgItemPeripheral.attrs)) {
            configuration.setDirty(true);
            cfgItemPeripheral.deviceID = this.ports[n].getID();
            cfgItemPeripheral.attrs = this.ports[n].getAttributes();
        }
    }

    public boolean comparePort(int n, String string, AttributesMap attributesMap) {
        return this.ports[n].getID().equals(string) && AttributesMap.compare(attributesMap, this.ports[n].getAttributes());
    }

    public final void setPort(int n, String string, AttributesMap attributesMap) {
        if (!this.comparePort(n, string, attributesMap)) {
            this.setPort(n, this.createDevice(n, string, attributesMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPort(int n, IDevice iDevice) {
        Component component = this.display.getEventProducer();
        IDevice iDevice2 = this.ports[n];
        IDevice iDevice3 = iDevice != null ? iDevice : NullDevice.SHARED;
        String string = Integer.toString(n + 1);
        if (!ID_NULL.equals(iDevice2.getID())) {
            System.out.println("Removing " + iDevice2.toString() + " from port " + string);
        }
        List<IPeripheral.FrameHandler> list = this.frameHandlers;
        synchronized (list) {
            this.frameHandlers.remove(iDevice2);
        }
        iDevice2.unplug(component, n);
        this.fireEvent(new DeviceEvent(this, n, iDevice2, IDeviceEvent.Cause.ACTION_UNPLUG));
        if (!ID_NULL.equals(iDevice3.getID())) {
            System.out.println("Pluging " + iDevice3.toString() + " in port " + string);
        }
        iDevice3.plug(component, n);
        this.fireEvent(new DeviceEvent(this, n, iDevice3, IDeviceEvent.Cause.ACTION_PLUG));
        this.ports[n] = iDevice3;
        this.synchronizeConfigurationPeriph(n, this.conf);
        this.portDeviceChanged(n, iDevice3);
    }

    public void fireEvent(IDevice iDevice, IDeviceEvent.Cause cause, String string) {
        int n;
        if (iDevice == this.getPort(0)) {
            n = 0;
        } else if (iDevice == this.getPort(1)) {
            n = 1;
        } else {
            String string2 = "### Spurious Error Event for device \"" + iDevice + "\" : " + (Object)((Object)cause) + " (" + string + ")";
            throw new IllegalArgumentException(string2);
        }
        this.fireEvent(n, cause, string);
    }

    public void fireEvent(int n, IDeviceEvent.Cause cause, String string) {
        this.fireEvent(new DeviceEvent(this, n, this.ports[n], cause, string));
    }

    public void fireEvent(IDeviceEvent iDeviceEvent) {
        if (iDeviceEvent.getCause().isError()) {
            this.fireErrorEvent(iDeviceEvent);
        } else {
            this.fireActionEvent(iDeviceEvent);
        }
    }

    private void fireActionEvent(IDeviceEvent iDeviceEvent) {
        for (IDevicesListener iDevicesListener : this.devListeners) {
            iDevicesListener.deviceAction(iDeviceEvent);
        }
    }

    private void fireErrorEvent(IDeviceEvent iDeviceEvent) {
        for (IDevicesListener iDevicesListener : this.devListeners) {
            iDevicesListener.deviceError(iDeviceEvent);
        }
    }

    public static final boolean isValidPeripheralID(int n, String string) {
        if (ID_NULL.equals(string)) {
            return true;
        }
        if (ID_JOYSTICK.equals(string)) {
            return true;
        }
        if (ID_CONTROLLER.equals(string)) {
            return true;
        }
        if (ID_LIGHTPEN.equals(string)) {
            return true;
        }
        if (n != 0) {
            if (ID_KEYBOARD.equals(string)) {
                return true;
            }
            if (ID_VECVOICE.equals(string)) {
                return true;
            }
            if (ID_GOGGLES.equals(string)) {
                return true;
            }
        }
        return false;
    }

    public static final String getValidPeripheralID(int n, String string) {
        return Peripherals.isValidPeripheralID(n, string) ? string : Peripherals.getDefaultPeripheralID(n);
    }

    public static final String getDefaultPeripheralID(int n) {
        return ID_JOYSTICK;
    }

    public static final boolean areExclusivePeripherals(String string, String string2) {
        return ID_LIGHTPEN.equals(string) && ID_LIGHTPEN.equals(string2);
    }

    private IDevice createDevice(int n, String string, AttributesMap attributesMap) {
        IDevice iDevice = null;
        if (ID_NULL.equals(string)) {
            iDevice = NullDevice.SHARED;
        } else if (ID_JOYSTICK.equals(string)) {
            iDevice = new Joystick();
        } else if (ID_KEYBOARD.equals(string)) {
            iDevice = new PS2Keyboard();
        } else if (ID_VECVOICE.equals(string)) {
            iDevice = new VecVoice(this.audio);
        } else if (ID_LIGHTPEN.equals(string)) {
            iDevice = new Lightpen();
        } else if (ID_GOGGLES.equals(string)) {
            iDevice = new Goggles();
        } else if (ID_CONTROLLER.equals(string)) {
            iDevice = JInputJoystick.createDevice(n, this, attributesMap);
        } else {
            System.out.println("*** WARNING : Unknown peripheral ID \"" + string + "\"");
        }
        if (iDevice == null) {
            iDevice = this.createDevice(n, Peripherals.getDefaultPeripheralID(n), null);
        }
        if (iDevice instanceof IPeripheral) {
            ((IPeripheral)iDevice).setManager(this);
        }
        iDevice.applyConfiguration(this.conf, n);
        return iDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void portDeviceChanged(int n, IDevice iDevice) {
        Object object;
        if (1 == n) {
            this.writeHandler = iDevice instanceof IPeripheral.WriteHandler ? (IPeripheral.WriteHandler)((Object)iDevice) : null;
            IPeripheral.TickHandler tickHandler = this.tickHandler = iDevice instanceof IPeripheral.TickHandler ? (IPeripheral.TickHandler)((Object)iDevice) : null;
        }
        if (iDevice instanceof IPeripheral.FrameHandler) {
            object = this.frameHandlers;
            synchronized (object) {
                this.frameHandlers.add((IPeripheral.FrameHandler)((Object)iDevice));
            }
        }
        object = null;
        Goggles goggles = null;
        int n2 = 0;
        while (n2 < this.ports.length) {
            IDevice iDevice2 = this.ports[n2];
            if (iDevice2 instanceof Lightpen) {
                object = (Lightpen)iDevice2;
            }
            if (iDevice2 instanceof Goggles) {
                goggles = (Goggles)iDevice2;
            }
            ++n2;
        }
        this.setLightpen((Lightpen)object);
        this.setGoggles(goggles);
        this.emulateFIRQ = DevOptions.alwaysEmulateFIRQ || this.ports[0] instanceof Lightpen;
        this.emulateCA1 = this.ports[1] instanceof Lightpen || this.ports[1] instanceof Goggles;
    }

    private void setLightpen(Lightpen lightpen) {
        this.analog.setLightpen(lightpen);
        this.display.setLightpen(lightpen);
    }

    private void setGoggles(Goggles goggles) {
    }

    private final int getJoyX1() {
        return this.ports[0].getAnalogX();
    }

    private final int getJoyY1() {
        return this.ports[0].getAnalogY();
    }

    private final int getJoyX2() {
        return this.ports[1].getAnalogX();
    }

    private final int getJoyY2() {
        return this.ports[1].getAnalogY();
    }
}

