/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.joystick;

import frc.emul.api.IDevice;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemJoystick;
import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.config.data.CfgItemSensitivity;
import frc.emul.periph.misc.AbstractDevice;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class Joystick
extends AbstractDevice
implements IDevice,
MouseInputListener,
KeyListener {
    public static final String NAME = "Joystick";
    private static final boolean ANALOG_SUPPORT = true;
    private static final long DOUBLE_CLICK_MAX_DELAY = 500L;
    private Component source;
    private int joyID;
    private int buttons = 15;
    private int axisX = 0;
    private int axisY = 0;
    private int vk_BTN1 = 81;
    private int vk_BTN2 = 83;
    private int vk_BTN3 = 87;
    private int vk_BTN4 = 88;
    private int vk_UP = 38;
    private int vk_DOWN = 40;
    private int vk_LEFT = 37;
    private int vk_RIGHT = 39;
    private CfgItemSensitivity sensitivity;
    private boolean recentering;
    private Robot analogRobot;
    private Point analogCenter;
    private Point analogRef;
    private float axisXf;
    private float axisYf;
    private long firstClick;

    public String getID() {
        return "JOYSTICK";
    }

    public String getName() {
        return NAME;
    }

    public void applyConfiguration(Configuration configuration, int n) {
        CfgItemKeymapping cfgItemKeymapping = configuration.keyMapping;
        this.setKeyMapping(n == 0 ? cfgItemKeymapping.joy1 : cfgItemKeymapping.joy2);
    }

    public void plug(Component component, int n) {
        this.joyID = n;
        this.source = component;
        if (component != null) {
            component.addKeyListener(this);
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }
    }

    public void unplug(Component component, int n) {
        if (component != null) {
            component.removeKeyListener(this);
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
        }
    }

    public final boolean consumes(InputEvent inputEvent) {
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            int n = keyEvent.getKeyCode();
            return (n == this.vk_LEFT || n == this.vk_RIGHT || n == this.vk_DOWN || n == this.vk_UP || n == this.vk_BTN1 || n == this.vk_BTN2 || n == this.vk_BTN3 || n == this.vk_BTN4) && this.available(keyEvent);
        }
        return false;
    }

    public final int getButtonsState() {
        return this.buttons;
    }

    public final int getAnalogX() {
        return this.axisX;
    }

    public final int getAnalogY() {
        return this.axisY;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (!this.available(mouseEvent)) {
            return;
        }
        int n = this.joyID == 0 ? 16 : 4;
        int n2 = mouseEvent.getModifiers();
        if (this.analogRobot != null) {
            if ((n2 & 0x1C) != 0) {
                this.recenterAxis();
            }
            if ((n2 & 0x14) != 0) {
                this.analogRobot = null;
                UIUtils.popHiddenCursor(this.source);
                System.out.println("Unmapped analog joystick #" + (this.joyID + 1));
            }
            return;
        }
        if ((n2 & n) != 0) {
            long l = System.currentTimeMillis();
            long l2 = l - this.firstClick;
            if (l2 >= 500L) {
                this.firstClick = l;
                return;
            }
            this.firstClick = 0L;
            this.recenterAxis();
            try {
                this.analogRobot = new Robot();
            }
            catch (AWTException aWTException) {
                JOptionPane.showMessageDialog(this.source, "Cannot gain control of low-level mouse input!\nThe analog mode is not available...", "ParaJVE - Analog Input", 2);
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(this.source);
            Dimension dimension = window.getSize();
            this.analogCenter = window.getLocation();
            this.analogCenter.x += dimension.width / 2;
            this.analogCenter.y += dimension.height / 2;
            UIUtils.pushHiddenCursor(this.source);
            this.recenterMouse();
            System.out.println("Mouse mapped on analog stick #" + (this.joyID + 1));
        }
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        if (this.analogRobot != null) {
            if (this.recentering) {
                this.recentering = false;
                this.analogRef = mouseEvent.getPoint();
            } else {
                float f = (float)(mouseEvent.getX() - this.analogRef.x) * this.sensitivity.axisX;
                float f2 = (float)(this.analogRef.y - mouseEvent.getY()) * this.sensitivity.axisY;
                this.axisXf = Math.max(-128.0f, Math.min(127.0f, this.axisXf + f));
                this.axisX = (int)this.axisXf;
                this.axisYf = Math.max(-128.0f, Math.min(127.0f, this.axisYf + f2));
                this.axisY = (int)this.axisYf;
                this.recenterMouse();
            }
        }
    }

    private final void recenterMouse() {
        this.recentering = true;
        this.analogRobot.mouseMove(this.analogCenter.x, this.analogCenter.y);
    }

    private final void recenterAxis() {
        this.axisYf = 0.0f;
        this.axisXf = 0.0f;
        this.axisY = 0;
        this.axisX = 0;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.available(keyEvent)) {
            int n = keyEvent.getKeyCode();
            if (n == this.vk_LEFT) {
                this.axisX = -128;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_RIGHT) {
                this.axisX = 127;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_DOWN) {
                this.axisY = -128;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_UP) {
                this.axisY = 127;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN1) {
                this.buttons &= 0xFFFFFFFE;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN2) {
                this.buttons &= 0xFFFFFFFD;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN3) {
                this.buttons &= 0xFFFFFFFB;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN4) {
                this.buttons &= 0xFFFFFFF7;
                keyEvent.consume();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.available(keyEvent)) {
            int n = keyEvent.getKeyCode();
            if (n == this.vk_LEFT) {
                if (this.axisX < 0) {
                    this.axisX = 0;
                }
                keyEvent.consume();
                return;
            }
            if (n == this.vk_RIGHT) {
                if (this.axisX > 0) {
                    this.axisX = 0;
                }
                keyEvent.consume();
                return;
            }
            if (n == this.vk_DOWN) {
                if (this.axisY < 0) {
                    this.axisY = 0;
                }
                keyEvent.consume();
                return;
            }
            if (n == this.vk_UP) {
                if (this.axisY > 0) {
                    this.axisY = 0;
                }
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN1) {
                this.buttons |= 1;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN2) {
                this.buttons |= 2;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN3) {
                this.buttons |= 4;
                keyEvent.consume();
                return;
            }
            if (n == this.vk_BTN4) {
                this.buttons |= 8;
                keyEvent.consume();
                return;
            }
        }
    }

    public final boolean isButtonPressed(int n) {
        return (this.buttons >> n & 1) == 0;
    }

    public final int getDigitalX() {
        return this.axisX == 0 ? 0 : (this.axisX < 0 ? -1 : 1);
    }

    public final int getDigitalY() {
        return this.axisY == 0 ? 0 : (this.axisY < 0 ? -1 : 1);
    }

    public void setKeyMapping(CfgItemJoystick cfgItemJoystick) {
        this.sensitivity = cfgItemJoystick.mouseSensitivity;
        this.vk_BTN1 = cfgItemJoystick.keyBtn1.getCode();
        this.vk_BTN2 = cfgItemJoystick.keyBtn2.getCode();
        this.vk_BTN3 = cfgItemJoystick.keyBtn3.getCode();
        this.vk_BTN4 = cfgItemJoystick.keyBtn4.getCode();
        this.vk_UP = cfgItemJoystick.keyUp.getCode();
        this.vk_DOWN = cfgItemJoystick.keyDown.getCode();
        this.vk_LEFT = cfgItemJoystick.keyLeft.getCode();
        this.vk_RIGHT = cfgItemJoystick.keyRight.getCode();
    }

    private final boolean available(KeyEvent keyEvent) {
        return this.joyID == 1 || !this.getManager().getPort(1).consumes(keyEvent);
    }

    private final boolean available(MouseEvent mouseEvent) {
        return !this.getManager().getPort(1 - this.joyID).consumes(mouseEvent);
    }
}

