/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.lightpen;

import frc.emul.config.data.DevOptions;
import frc.emul.periph.lightpen.ILightpenStateProvider;
import frc.emul.periph.misc.AbstractDevice;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Lightpen
extends AbstractDevice
implements ILightpenStateProvider,
ComponentListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final boolean DEBUG_USE_STILL_TIMER = DevOptions.useLightpenStillnessTimer;
    private static final boolean DEBUG_ADJUST_HITBOX = DevOptions.adjustLightpenHitzone;
    public static final String NAME = "LightPen";
    private static final float HITBOX_STEP = 5.0E-4f;
    private static final float HITBOX_MAX = 0.075f;
    private static final float HITBOX_MIN = 0.0025f;
    private static final float HITBOX_ACCURATE = 0.0045f;
    private static final float HITBOX_DEFAULT = 0.0075f;
    private static final float HITBOX_STILL = 0.0075f;
    private Timer stillMouseTimer;
    private float cX;
    private float cY;
    public float unitX;
    public float unitY;
    private float areaW;
    private float areaH;
    private float lastX;
    private float lastY;
    private Float normalBaseRadius;
    private int activeMask;
    private boolean active;
    private boolean visible;
    private boolean hit;
    private boolean inActiveZone;
    private float baseHitRadius;
    private float hitRadius2;
    private Component source;

    public String getID() {
        return "LIGHTPEN";
    }

    public String getName() {
        return NAME;
    }

    public void plug(Component component, int n) {
        if (component != null) {
            this.source = component;
            component.addComponentListener(this);
            component.addMouseMotionListener(this);
            component.addMouseListener(this);
            if (DEBUG_ADJUST_HITBOX) {
                component.addMouseWheelListener(this);
            }
            this.initScaling(0.0075f);
            this.activate();
        }
    }

    public void unplug(Component component, int n) {
        if (component != null) {
            this.deactivate();
            if (DEBUG_ADJUST_HITBOX) {
                component.removeMouseWheelListener(this);
            }
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            component.removeComponentListener(this);
        }
    }

    public int getButtonsState() {
        return this.active && this.hit ? 7 : 15;
    }

    public final boolean consumes(InputEvent inputEvent) {
        return inputEvent instanceof MouseEvent;
    }

    public boolean isLightpenAccurateMode() {
        return this.normalBaseRadius != null;
    }

    public boolean isLightpenVisible() {
        return this.visible;
    }

    public boolean isLightpenActive() {
        return this.active;
    }

    public float getLightpenPosX() {
        return this.unitX;
    }

    public float getLightpenPosY() {
        return this.unitY;
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.initScaling(this.baseHitRadius);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (DEBUG_ADJUST_HITBOX) {
            int n = mouseWheelEvent.getWheelRotation();
            this.initScaling(this.baseHitRadius - (float)n * 5.0E-4f);
            System.out.println("Lightpen hitbox set to " + this.baseHitRadius);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.activeMask |= 1;
            this.active = true;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.setLightpenAccurateMode(true);
            this.activeMask |= 2;
            this.active = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.activeMask &= 0xFFFFFFFE;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.setLightpenAccurateMode(false);
            this.activeMask &= 0xFFFFFFFD;
        }
        this.active = this.activeMask != 0;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.resetState();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        if (DEBUG_USE_STILL_TIMER) {
            this.stillMouseTimer.restart();
        }
        float f = mouseEvent == null ? this.lastX : (float)mouseEvent.getX() - this.cX;
        float f2 = mouseEvent == null ? this.lastY : (float)mouseEvent.getY() - this.cY;
        float f3 = 2.25f * (f - this.lastX) / (float)this.source.getWidth();
        float f4 = 2.25f * (f2 - this.lastY) / (float)this.source.getHeight();
        float f5 = f3 * f3 + f4 * f4;
        float f6 = 1.0f + 75.0f * (float)Math.sqrt(f5);
        float f7 = this.baseHitRadius * f6;
        this.hitRadius2 = f7 * f7;
        this.visible = this.checkActiveArea(f, f2);
        this.lastX = f;
        this.lastY = f2;
        this.unitX = 2.0f * f / this.areaW;
        this.unitY = -2.0f * f2 / this.areaH;
    }

    final void mouseStill() {
        this.hitRadius2 = 5.625E-5f;
    }

    public void checkHit(float f, float f2) {
        float f3 = f - this.unitX;
        float f4 = (f2 - this.unitY) / 0.8f;
        this.hit = f3 * f3 + f4 * f4 < this.hitRadius2;
    }

    public float getCurrentHitboxRadius() {
        return (float)Math.sqrt(this.hitRadius2);
    }

    private final void activate() {
        this.resetState();
        UIUtils.pushHiddenCursor(this.source);
        if (DEBUG_USE_STILL_TIMER) {
            this.createTimer();
        }
    }

    private final void deactivate() {
        if (DEBUG_USE_STILL_TIMER) {
            this.destroyTimer();
        }
        UIUtils.popHiddenCursor(this.source);
        this.resetState();
    }

    private final synchronized void createTimer() {
        ActionListener actionListener = new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                Lightpen.this.mouseStill();
            }
        };
        this.stillMouseTimer = new Timer(75, actionListener);
        this.stillMouseTimer.setRepeats(false);
        System.out.println("(Lightpen stillness timer created)");
    }

    private final synchronized void destroyTimer() {
        if (this.stillMouseTimer != null) {
            this.stillMouseTimer.stop();
            this.stillMouseTimer = null;
        }
    }

    private final void resetState() {
        this.hit = false;
        this.visible = false;
    }

    private final synchronized void setLightpenAccurateMode(boolean bl) {
        if (this.isLightpenAccurateMode() != bl) {
            if (bl) {
                if (DEBUG_ADJUST_HITBOX) {
                    System.out.println("Switching to Accurate mode");
                }
                this.normalBaseRadius = new Float(this.baseHitRadius);
                this.initScaling(0.0045f);
            } else {
                if (DEBUG_ADJUST_HITBOX) {
                    System.out.println("Switching back to Default mode");
                }
                this.initScaling(this.normalBaseRadius.floatValue());
                this.normalBaseRadius = null;
            }
        }
    }

    private void initScaling(float f) {
        float f2 = this.source.getWidth();
        float f3 = Math.max(this.source.getHeight(), 1);
        this.cX = (f2 - 1.0f) / 2.0f;
        this.cY = (f3 - 1.0f) / 2.0f;
        if (f2 / f3 >= 0.8f) {
            this.areaH = f3;
            this.areaW = f3 * 0.8f;
        } else {
            this.areaW = f2;
            this.areaH = f2 / 0.8f;
        }
        this.baseHitRadius = Math.min(0.075f, Math.max(0.0025f, f));
        this.mouseMoved(null);
    }

    private final boolean checkActiveArea(float f, float f2) {
        boolean bl;
        boolean bl2 = bl = Math.abs(f) <= (this.areaW - 1.0f) / 2.0f && Math.abs(f2) <= (this.areaH - 1.0f) / 2.0f;
        if (bl != this.inActiveZone) {
            this.inActiveZone = bl;
            if (bl) {
                this.source.setCursor(UIUtils.CURSOR_HIDDEN);
            } else {
                this.source.setCursor(UIUtils.getCrossCursor());
            }
        }
        return bl;
    }
}

