/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg;

import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.psg.IAudioSettings;
import frc.emul.vectrex.PersistentSection;

final class DacOutputLine
implements IPersistentObject {
    static final boolean TRACE = false;
    static final boolean OLD_METHOD = false;
    private static final int UPDATES_COUNTDOWN = 6;
    private int[] buffer;
    private int volumeFactor;
    private int cyclesPerSample;
    private int activityCountdown;
    private boolean active;
    private int dacOutput;
    private int countdown;
    private int writeIdx;
    private int elapsedCycles;
    private int discarded = -1;

    DacOutputLine() {
    }

    final void updateSettings(IAudioSettings iAudioSettings, int n) {
        this.cyclesPerSample = 1600000 / iAudioSettings.getSampleRate();
        this.volumeFactor = (int)(128.0f * iAudioSettings.getVolumeLevel());
        this.activityCountdown = 6 * n;
        this.deactivate();
        if (this.buffer == null || this.buffer.length != n) {
            this.buffer = new int[n];
        }
    }

    final void deactivate() {
        this.active = false;
        this.writeIdx = 0;
        this.elapsedCycles = 0;
    }

    final void outputDAC(int n) {
        if (n == 0) {
            this.dacOutput = 0;
        } else {
            this.countdown = this.activityCountdown;
            this.dacOutput = n * this.volumeFactor;
            this.active = true;
        }
    }

    final void tick(int n) {
        if (this.active) {
            this.elapsedCycles += n;
            if (this.elapsedCycles < this.cyclesPerSample) {
                return;
            }
            this.elapsedCycles -= this.cyclesPerSample;
            --this.countdown;
            if (this.writeIdx < this.buffer.length) {
                this.buffer[this.writeIdx++] = this.dacOutput;
            }
        }
    }

    final void merge(int[] nArray, int n, int n2) {
        if (this.active) {
            if (this.writeIdx == 0 || this.countdown < 0) {
                this.deactivate();
            } else if (n2 >= this.writeIdx) {
                int n3 = n2 - this.writeIdx;
                int n4 = this.writeIdx;
                while (n4-- > 0) {
                    int n5 = n3 + n4;
                    int n6 = this.buffer[n + n4];
                    int n7 = nArray[n5];
                    nArray[n5] = (n6 + n7) / 2;
                }
                this.writeIdx = 0;
            } else {
                int n8 = n2;
                while (n8-- > 0) {
                    int n9 = this.buffer[n + n8];
                    int n10 = nArray[n8];
                    nArray[n8] = (n9 + n10) / 2;
                }
                this.writeIdx -= n2;
                System.arraycopy(this.buffer, n2, this.buffer, 0, this.writeIdx);
            }
        }
    }

    final void override(int[] nArray, int n, int n2) {
        if (this.active) {
            if (this.writeIdx == 0 || this.countdown < 0) {
                this.deactivate();
            } else if (n2 >= this.writeIdx) {
                System.arraycopy(this.buffer, n, nArray, n2 - this.writeIdx, this.writeIdx);
                this.writeIdx = 0;
            } else {
                System.arraycopy(this.buffer, n, nArray, 0, n2);
                this.writeIdx -= n2;
                System.arraycopy(this.buffer, n2, this.buffer, 0, this.writeIdx);
            }
        }
    }

    public IPersistentSection getSection() {
        return PersistentSection.AUDIO_DAC;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.deactivate();
    }
}

