/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev;

public class PsgRecord {
    private int reg;
    private int data;
    private long time;

    public PsgRecord(int n, int n2) {
        this.reg = n;
        this.data = n2;
        this.time = System.nanoTime();
    }

    public PsgRecord(String string) {
        this.deserialize(string);
    }

    public void deserialize(String string) {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        int n3 = string.indexOf(32, n2 + 1);
        this.reg = Integer.parseInt(string.substring(0, n), 16);
        this.data = Integer.parseInt(string.substring(n + 1, n2), 16);
        this.time = Long.parseLong(string.substring(n2 + 1, n3));
    }

    public String serialize() {
        return this.serialize(0L);
    }

    public String serialize(long l) {
        String string = Integer.toHexString(this.data & 0xFF);
        return String.valueOf(Integer.toHexString(this.reg)) + " " + ((0xFF & this.data) < 16 ? "0" + string : string) + " " + Long.toString(this.time - l);
    }

    public boolean isSameRecord(PsgRecord psgRecord) {
        return this.reg == psgRecord.reg && this.data == psgRecord.data;
    }

    public long getTime() {
        return this.time;
    }

    public int getData() {
        return this.data;
    }

    public int getReg() {
        return this.reg;
    }
}

