/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev;

import frc.emul.psg.dev.PsgRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsgRecording {
    private List<PsgRecord> records = new ArrayList<PsgRecord>(1000);
    private boolean recording;
    public static final PsgRecording INSTANCE = new PsgRecording();

    private PsgRecording() {
    }

    public int getSize() {
        return this.records == null ? 0 : this.records.size();
    }

    public List<PsgRecord> getRecords() {
        return this.records;
    }

    public void clear() {
        this.records = new ArrayList<PsgRecord>(1000);
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean bl) {
        this.recording = bl;
    }

    public void addRecord(int n, int n2) {
        if (this.recording) {
            this.records.add(new PsgRecord(n, n2));
        }
    }

    public void loadRecords(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.records.clear();
        while ((string = bufferedReader.readLine()) != null) {
            this.records.add(new PsgRecord(string));
        }
        inputStream.close();
    }

    public void loadRecords(String string) {
        try {
            System.out.println("Loading sound history from [" + string + "]");
            this.loadRecords(new FileInputStream(string));
        }
        catch (Exception exception) {
            System.err.println("Error while loading sound history");
            exception.printStackTrace();
        }
    }

    public void saveRecords(OutputStream outputStream) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        if (!this.records.isEmpty()) {
            long l = this.records.get(0).getTime();
            int n = 0;
            while (n < this.records.size()) {
                PsgRecord psgRecord = this.records.get(n);
                printStream.println(String.valueOf(psgRecord.serialize(l)) + "   \t// " + (psgRecord.getTime() - l) / 1000000L);
                ++n;
            }
        }
        printStream.close();
    }

    public void saveRecords(String string) {
        if (this.records.isEmpty()) {
            return;
        }
        try {
            System.out.println("Saving sound history to [" + string + "]");
            File file = new File(string);
            file.getParentFile().mkdirs();
            this.saveRecords(new FileOutputStream(file));
        }
        catch (Exception exception) {
            System.err.println("Error while saving sound history");
            exception.printStackTrace();
        }
    }

    public void strip(long l) {
        if (this.records.isEmpty()) {
            return;
        }
        ArrayList<PsgRecord> arrayList = new ArrayList<PsgRecord>(this.records.size() / 4);
        PsgRecord psgRecord = this.records.get(0);
        arrayList.add(psgRecord);
        int n = 1;
        while (n < this.records.size()) {
            PsgRecord psgRecord2 = psgRecord;
            psgRecord = this.records.get(n);
            if (!psgRecord.isSameRecord(psgRecord2) || psgRecord2.getTime() + l < psgRecord.getTime()) {
                arrayList.add(psgRecord);
            }
            ++n;
        }
        this.records = arrayList;
    }
}

