/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev;

import frc.emul.psg.IAudioSettings;
import frc.emul.psg.IPsgCore;
import frc.emul.psg.dev.ISamplesProcessor;
import frc.emul.util.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class SamplesRecordingProcessor
implements ISamplesProcessor {
    private File targetFile;
    private boolean mute;
    private int writtenBytes;
    private OutputStream output;

    public boolean isRecording() {
        return this.output != null;
    }

    public synchronized void startRecording(IAudioSettings iAudioSettings, IPsgCore iPsgCore, String string) {
        try {
            this.startup(iAudioSettings, iPsgCore, string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O error while starting the sound recording.", iOException);
        }
    }

    public synchronized void stopRecording() {
        try {
            this.shutdown();
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O error while ending the sound recording.", iOException);
        }
    }

    public void feedSample(int n, int n2, int n3, int n4) {
        if (!this.mute) {
            try {
                this.output.write((byte)n);
                this.output.write((byte)(n >> 8));
                this.writtenBytes += 2;
            }
            catch (IOException iOException) {
                throw new RuntimeException("I/O error while recording the sound.", iOException);
            }
        }
    }

    public void startFeeding(int n) {
    }

    public void endFeeding(int n) {
    }

    public void setMute(boolean bl) {
        this.mute = bl;
    }

    public boolean isMute() {
        return this.mute;
    }

    private void emitWORD(int n) throws IOException {
        this.output.write((byte)n);
        this.output.write((byte)(n >> 8));
    }

    private void emitLONG(int n) throws IOException {
        this.emitWORD(n);
        this.emitWORD(n >> 16);
    }

    private void startup(IAudioSettings iAudioSettings, IPsgCore iPsgCore, String string) throws IOException {
        if (this.isRecording()) {
            this.stopRecording();
        }
        this.targetFile = Utils.getFile(string);
        this.writtenBytes = 0;
        this.output = new BufferedOutputStream(new FileOutputStream(this.targetFile));
        byte[] byArray = new byte[12];
        byArray[0] = 82;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 70;
        byArray[4] = -96;
        byArray[5] = 4;
        byArray[8] = 87;
        byArray[9] = 65;
        byArray[10] = 86;
        byArray[11] = 69;
        this.output.write(byArray);
        this.output.write(new byte[]{102, 109, 116, 32});
        this.emitLONG(16);
        this.emitWORD(1);
        this.emitWORD(1);
        this.emitLONG(iAudioSettings.getSampleRate());
        this.emitLONG(iAudioSettings.getSampleRate() * 2);
        this.emitWORD(2);
        this.emitWORD(16);
        this.output.write(new byte[]{100, 97, 116, 97});
        this.emitLONG(-1414673666);
        iPsgCore.setSamplesProcessor(this);
    }

    private void shutdown() throws IOException {
        this.output.close();
        this.output = null;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.targetFile, "rw");
        randomAccessFile.skipBytes(38);
        randomAccessFile.writeByte(this.writtenBytes & 0xFF);
        randomAccessFile.writeByte(this.writtenBytes >> 8 & 0xFF);
        randomAccessFile.writeByte(this.writtenBytes >> 16 & 0xFF);
        randomAccessFile.writeByte(this.writtenBytes >> 24 & 0xFF);
        randomAccessFile.close();
    }
}

