/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev.ui;

import frc.emul.psg.IPsgCore;
import frc.emul.psg.dev.ISamplesProcessor;
import frc.emul.psg.dev.ui.IChannelsMonitor;
import frc.emul.psg.dev.ui.JoglChannelsMonitor;
import frc.emul.psg.dev.ui.SamplesProcessor;
import frc.emul.util.swing.JSpinnerFix;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SamplesMonitor {
    private static JFrame monitoring;
    private SamplesProcessor processor;
    private JFrame f;
    private IChannelsMonitor channelsMon;
    private boolean paintMaxSamples = true;
    private final Channel[] CHANNELS = new Channel[]{new Channel(IChannelsMonitor.Channel.CHANNEL_NONE, "-none-"), new Channel(IChannelsMonitor.Channel.CHANNEL_MIX, "Mixing Channel"), new Channel(IChannelsMonitor.Channel.CHANNEL_A, "Channel A"), new Channel(IChannelsMonitor.Channel.CHANNEL_B, "Channel B"), new Channel(IChannelsMonitor.Channel.CHANNEL_C, "Channel C")};

    public SamplesMonitor() {
        this.processor = new SamplesProcessor(){

            protected void processData() {
                super.processData();
                SamplesMonitor.this.update();
            }
        };
    }

    public void open(final IPsgCore iPsgCore) {
        if (this.f != null) {
            return;
        }
        this.channelsMon = new JoglChannelsMonitor(this.processor){

            protected boolean paintMaxSamples() {
                return SamplesMonitor.this.areMaxSamplesPainted();
            }
        };
        this.f = new JFrame("ParaJVE's Samples Monitor");
        this.f.setIconImage(UIUtils.getFrameIcon());
        monitoring = this.f;
        if (iPsgCore == null) {
            this.f.setDefaultCloseOperation(3);
        } else {
            this.f.setDefaultCloseOperation(0);
            this.f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    monitoring = null;
                    if (iPsgCore.getSamplesProcessor() == SamplesMonitor.this.getProcessor()) {
                        iPsgCore.setSamplesProcessor(null);
                    }
                    SamplesMonitor.this.f.setVisible(false);
                    SamplesMonitor.this.f.dispose();
                }
            });
        }
        Component component = this.channelsMon.getDisplayComponent();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add(component);
        this.f.getContentPane().add(jPanel);
        component.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.handle(mouseEvent);
            }

            private void handle(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed()) {
                    mouseEvent.consume();
                    SamplesMonitor.this.editSettings(false);
                }
            }
        });
        this.f.pack();
        this.f.setSize(400, 580);
        if (iPsgCore != null) {
            iPsgCore.setSamplesProcessor(this.getProcessor());
        }
        this.f.setVisible(true);
    }

    public void reset() {
        this.processor.reset();
    }

    public ISamplesProcessor getProcessor() {
        return this.processor;
    }

    public void setMaxSamplesPainted(boolean bl) {
        this.paintMaxSamples = bl;
    }

    public boolean areMaxSamplesPainted() {
        return this.paintMaxSamples;
    }

    protected void update() {
        if (this.channelsMon != null) {
            this.channelsMon.updateDisplay();
        }
    }

    public final void editSettings(boolean bl) {
        if (bl) {
            this.editSettings();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().sync();
                    Thread.yield();
                    SamplesMonitor.this.editSettings();
                }
            });
        }
    }

    private final void editSettings() {
        final JDialog jDialog = new JDialog(monitoring, "Monitor Settings", true);
        final JSlider jSlider = new JSlider(2, 10000, 2);
        final JSlider jSlider2 = new JSlider(1, 2500, 1);
        final JComboBox<Channel> jComboBox = new JComboBox<Channel>(this.CHANNELS);
        JButton jButton = new JButton("Close");
        JButton jButton2 = new JButton("Apply");
        final JSpinnerFix jSpinnerFix = new JSpinnerFix(new SpinnerNumberModel(jSlider.getValue(), jSlider.getMinimum(), jSlider.getMaximum(), 5));
        final JSpinnerFix jSpinnerFix2 = new JSpinnerFix(new SpinnerNumberModel(jSlider2.getValue(), jSlider2.getMinimum(), jSlider2.getMaximum(), 1));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel.add((Component)new JLabel("Maximized channel :"), "West");
        jPanel.add(jComboBox, "Center");
        IChannelsMonitor.Channel channel = this.channelsMon.getZoomedChannel();
        int n = this.CHANNELS.length;
        while (n-- > 0) {
            if (this.CHANNELS[n].equals((Object)channel)) break;
        }
        jComboBox.setSelectedIndex(n);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplesMonitor.this.channelsMon.setZoomedChannel(((Channel)jComboBox.getSelectedItem()).value);
            }
        });
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 0, 10), Borders.BEVEL_LOW_10));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix.setValue(new Integer(jSlider.getValue()));
            }
        });
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix2.setValue(new Integer(jSlider2.getValue()));
            }
        });
        jSpinnerFix.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSlider.setValue((Integer)jSpinnerFix.getValue());
            }
        });
        jSpinnerFix2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSlider2.setValue((Integer)jSpinnerFix2.getValue());
            }
        });
        jPanel2.add(new JLabel("History Size :"));
        jPanel2.add(jSlider);
        jPanel2.add(jSpinnerFix);
        jPanel2.add(new JLabel("Samples/Tick :"));
        jPanel2.add(jSlider2);
        jPanel2.add(jSpinnerFix2);
        UIUtils.makeCompactGrid(jPanel2, 2, 3, 0, 0, 6, 4);
        jSlider.setValue(this.processor.getHistorySize());
        jSlider2.setValue(this.processor.getThreshold());
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel3.add(jButton2);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplesMonitor.this.processor.setHistorySize(jSlider.getValue());
                SamplesMonitor.this.processor.setThreshold(jSlider2.getValue());
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        jDialog.getContentPane().add(jPanel4);
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    public static final void monitorPSG(IPsgCore iPsgCore) {
        if (monitoring == null) {
            SamplesMonitor samplesMonitor = new SamplesMonitor();
            samplesMonitor.open(iPsgCore);
        } else {
            monitoring.requestFocus();
        }
    }

    public static final boolean isMonitoring() {
        return monitoring != null;
    }

    class Channel {
        final IChannelsMonitor.Channel value;
        private final String label;

        Channel(IChannelsMonitor.Channel channel, String string) {
            this.value = channel;
            this.label = string;
        }

        public String toString() {
            return " " + this.label;
        }

        public boolean equals(Object object) {
            return this == object ? true : this.value.equals(object);
        }
    }
}

