/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.standalone;

import frc.emul.config.Configuration;
import frc.emul.util.swing.AALabel;
import frc.util.ExFileLock;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;

public class CrashTracker {
    private static final String HEADER = "*** ABEND recovery : ";
    private final ExFileLock crashLock = new ExFileLock(new File("data/temp/.lock"));

    public boolean hasLock() {
        return this.crashLock.ownsLock();
    }

    public void shutdown() {
        this.crashLock.unlock();
    }

    public boolean install(Component component, Configuration configuration) {
        if (!this.crashLock.lock()) {
            return true;
        }
        if (!this.crashLock.reusedOldLock()) {
            return true;
        }
        System.out.println("*** ABEND recovery : old lock reused, the last occurrence has likely abended!");
        if (!configuration.options.glowShader.active) {
            System.out.println("*** ABEND recovery : safe mode not available (safest execution context possible already).");
            return true;
        }
        int n = 1;
        String string = "ParaJVE - Recovery Mode!";
        String string2 = "<html><b><font color=E00000 size=3>ParaJVE detected that its last execution did not end normally...&nbsp;</font></b><hr><br>It might be due to an unexpected crash (in your 3D card driver for instance).&nbsp;<br><br><b>In order to prevent this from happening again, do you want to disable&nbsp;&nbsp;<br>the most advanced settings that could have led to this problem?&nbsp;</b><br><br><i>(You can enable these settings back later on, through the game menus)&nbsp;</i><br><br>";
        int n2 = JOptionPane.showConfirmDialog(component, new AALabel(string2), string, n, 0);
        switch (n2) {
            case 0: {
                System.out.println("*** ABEND recovery : switching to safe mode");
                configuration.options.glowShader.active = false;
                configuration.setDirty(true);
                return true;
            }
            case 1: {
                System.out.println("*** ABEND recovery : proceeding in standard mode");
                return true;
            }
            case 2: {
                System.out.println("*** ABEND recovery : user aborted execution");
                return false;
            }
        }
        throw new IllegalStateException();
    }
}

