/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.standalone;

import frc.emul.util.Utils;
import frc.util.Unzip;
import java.io.File;
import java.lang.reflect.Method;

public class Deployment {
    public static final boolean checkAndDeployAsNeeded() {
        block4: {
            System.out.println("Checking Libraries deployment");
            if (Deployment.isValidDeployement()) {
                return false;
            }
            try {
                System.out.println("> deployment required...");
                Deployment.deploy();
                if (!Deployment.isValidDeployement()) break block4;
                System.out.println("> deployment successfull, resuming execution");
                return false;
            }
            catch (Exception exception) {
                System.out.println("*** Libraries deployment ERROR :");
                exception.printStackTrace(System.out);
                System.out.println("*** Resuming execution...");
                return false;
            }
        }
        System.out.println("> deployment successfull, but a restart is needed.");
        return true;
    }

    public static final boolean isValidDeployement() {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.media.opengl.GLDrawableFactory");
            Method method = clazz.getMethod("getFactory", new Class[0]);
            method.invoke(null, new Object[0]);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static final boolean deploy() throws Exception {
        Boolean bl = Utils.is64bitsJVM();
        int n = bl == null ? 32 : (bl != false ? 64 : 32);
        return Deployment.deploy(n);
    }

    private static final boolean deploy(int n) throws Exception {
        File file = new File("libs/setup/libs_" + n + "bits.zip");
        if (!file.isFile()) {
            throw new RuntimeException("No package available for " + n + "-bits architecture");
        }
        return Deployment.deploy(n, file, new File("."));
    }

    private static final boolean deploy(int n, File file, File file2) throws Exception {
        System.out.println("> Deploying " + n + "-bits libraries under [" + Utils.getAbsolutePath(file2.getPath()) + "]");
        Unzip unzip = new Unzip(file, true);
        unzip.copyFile(file, new File("data/temp/patch-1.zip"));
        unzip.process(file2);
        return true;
    }
}

