/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.standalone;

import frc.emul.api.engine.IEngine;
import frc.emul.api.ui.IDisplay;
import frc.emul.config.ConfigLoader;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemAddrSpace;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.DevOptions;
import frc.emul.standalone.CrashTracker;
import frc.emul.standalone.Deployment;
import frc.emul.standalone.StandaloneEngine;
import frc.emul.util.Utils;
import frc.emul.util.swing.AALabel;
import frc.emul.vectrex.swing.UIWelcomePane;
import frc.emul.vectrex.ui.config.UIGameSelector;
import frc.emul.vectrex.ui.opengl.Display;
import frc.emul.version.Version;
import frc.input.JInputManager;
import frc.util.DeadlockChecker;
import frc.util.IStream;
import frc.util.IStreamFactory;
import java.io.File;
import java.io.InputStream;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class VectrexEmulator {
    private static String configFileName = "data/configuration.xml";
    private static String[] commandLine;
    private static boolean initialisedLAF;
    public static final String PARAM_DEBUG_SWITCH = "-debug";
    public static final String PARAM_NO_DEPLOYMENT = "-noDeployment";

    public static void main(String[] stringArray) throws Exception {
        if (!VectrexEmulator.run(stringArray)) {
            System.exit(0);
        }
    }

    public static final String getConfigFilename() {
        return configFileName;
    }

    public static final String[] getCommandLine() {
        return commandLine;
    }

    public static boolean run(String[] stringArray) throws Exception {
        Object object;
        configFileName = VectrexEmulator.extractConfigFileName(stringArray);
        commandLine = stringArray;
        String string = Utils.getStrParam(stringArray, "-game");
        if (Utils.containsParam(stringArray, PARAM_DEBUG_SWITCH)) {
            object = System.getProperty("java.specification.version", null);
            Boolean bl = Utils.is64bitsJVM();
            String string2 = bl == null ? "undefined" : (bl != false ? "64 bits" : "32 bits");
            System.out.println("# JRE version ...... " + (String)object);
            System.out.println("# JVM addressing ... " + string2 + "\n");
        }
        System.out.println("Loading configuration [" + Utils.getRelativePath(new File(configFileName)) + "]");
        object = new ConfigLoader().load(configFileName, stringArray);
        return VectrexEmulator.run(stringArray, (Configuration)object, string);
    }

    public static boolean run(String[] stringArray, Configuration configuration, String string) throws Exception {
        IEngine iEngine;
        if (DevOptions.monitorDeadlocks) {
            DeadlockChecker.activate("ParaJVE - Contention Monitor", 5000L);
        }
        Thread.currentThread().setPriority(1);
        Thread.currentThread().setName("ParaJVE - Launcher");
        VectrexEmulator.initLookAndFeel();
        if (!VectrexEmulator.validateKey()) {
            return false;
        }
        if (!Utils.containsParam(stringArray, PARAM_NO_DEPLOYMENT) && Deployment.checkAndDeployAsNeeded()) {
            String string2 = "<html>ParaJVE has successfully completed its initial setup, and is now ready to run.<br><br><b>Just restart the emulator to enter the Vectrex world...<br><br>";
            JOptionPane.showMessageDialog(null, string2, "ParaJVE - Setup Complete!", 1);
            return false;
        }
        if (configuration.options.firstRun) {
            System.out.println("Opening 'Welcome' dialog");
            UIWelcomePane.open(null, configuration);
            configuration.setDirty(true);
        }
        if ((iEngine = VectrexEmulator.createEngine(configuration, string)) != null) {
            System.out.println("Starting engine...");
            iEngine.runVM();
            return true;
        }
        configuration.setDirty(false);
        return false;
    }

    private static void initLookAndFeel() {
        if (!initialisedLAF) {
            initialisedLAF = true;
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {}
        }
    }

    public static final boolean validateKey() {
        if (!Version.isValidKey()) {
            String string = "ParaJVE " + Version.sFULL;
            String string2 = new File("ParaJVE.beta").isFile() ? "<html><b>The key file is not valid for this beta version.</b><br><br>Please contact the author to get a valid beta key." : "<html><b>No key found for this beta version!</b><br><br>If you have a key file, copy it in ParaJVE's root folder,<br>otherwise, contact the author to get a beta key.";
            System.out.println("No valid key found");
            JOptionPane.showMessageDialog(null, string2, string, 0);
            return false;
        }
        return true;
    }

    private static final String extractConfigFileName(String[] stringArray) {
        String string = Utils.getStrParam(stringArray, "-config");
        if (string != null) {
            File file = new File(string);
            if (file.isFile()) {
                return string;
            }
            String string2 = "<html>The specified configuration file does not exist :&nbsp;<br><b>" + Utils.getAbsolutePath(file) + "&nbsp;</b><br><br>Using the default configuration file instead...</html>";
            VectrexEmulator.initLookAndFeel();
            JOptionPane.showMessageDialog(null, new AALabel(string2), "ParaJVE - Parameters Error", 2);
        }
        return configFileName;
    }

    private static IEngine createEngine(final Configuration configuration, String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        CfgItemGame cfgItemGame;
        IStream iStream = null;
        CfgItemGame cfgItemGame2 = configuration.getSelectedGame();
        CfgItemGame cfgItemGame3 = cfgItemGame = "SELECTED".equals(string) ? cfgItemGame2 : configuration.getGame(string);
        if (cfgItemGame == null && string != null) {
            object3 = Utils.getFile(string);
            if (((File)object3).isFile()) {
                cfgItemGame = configuration.createUserPickedGame(Utils.getAbsolutePath((File)object3));
            } else {
                object2 = "<html>ParaJVE cannot find the specified game :" + (string.length() > 15 ? "<br>" : " ") + "<b>" + string + "</b></html>";
                JOptionPane.showMessageDialog(null, new AALabel((String)object2), "ParaJVE - Game not found!", 2);
            }
        }
        if (cfgItemGame == null) {
            System.out.println("Opening game selector");
            object3 = new UIGameSelector(){

                public void configChanged() {
                    configuration.setDirty(true);
                }
            };
            cfgItemGame = ((UIGameSelector)object3).chooseGame(null, configuration, true);
            configuration.options.display_fullscreen = ((UIGameSelector)object3).isFullscreen();
            if (cfgItemGame != null && cfgItemGame.cartridge.built) {
                iStream = IStreamFactory.create(((UIGameSelector)object3).getCartridgePath());
            }
        }
        if (cfgItemGame == null) {
            System.out.println("User aborted game selection, exiting");
            return null;
        }
        object3 = new CrashTracker();
        if (!((CrashTracker)object3).install(null, configuration)) {
            return null;
        }
        if (configuration.isDirty() || cfgItemGame != cfgItemGame2) {
            configuration.setSelectedGame(cfgItemGame);
            configuration.save();
        }
        JInputManager.ENABLED = !configuration.isControllersDisabled();
        System.out.println("Creating engine");
        object2 = new StandaloneEngine(configuration);
        System.out.println("Loading system [" + cfgItemGame.systemRom.path + "]");
        ((StandaloneEngine)object2).loadSystemROM(Utils.getResourceStream(cfgItemGame.systemRom.path));
        if (iStream == null) {
            iStream = cfgItemGame.getCartridgeStream();
        }
        if (iStream != null) {
            System.out.println("Loading cartridge [" + iStream.getName() + "]");
            object = null;
            try {
                object = iStream.open();
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to load resource from [" + iStream.getPath() + "]", exception);
            }
            ((StandaloneEngine)object2).loadCartridgeROM((InputStream)object);
        }
        if (cfgItemGame.hasCartridgeRam()) {
            object = cfgItemGame.cartridge.cartridgeRAM;
            System.out.println("Mapping cartridge RAM [$" + Utils.HEX4(((CfgItemAddrSpace)object).address) + "-$" + Utils.HEX4(((CfgItemAddrSpace)object).getLastAddress()) + "]");
            ((StandaloneEngine)object2).defineCartridgeRAM(((CfgItemAddrSpace)object).address, ((CfgItemAddrSpace)object).size);
        }
        System.out.println("Opening emulation UI");
        object = new Display(null, (CrashTracker)object3, configuration, true);
        ((StandaloneEngine)object2).getCore().setDisplay((IDisplay)object);
        return object2;
    }
}

