/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.tools.data;

import frc.emul.Constants;
import frc.emul.tools.data.TexInputStream;
import frc.emul.util.Utils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class TexLoader {
    private static final boolean DEBUG = false;
    private static final boolean USE_PACK_AS_FALLBACK = true;
    static final int FORMAT = 70;
    public static final int FLG_ENCODED = 1;
    public static final int FLG_SPLIT = 2;

    private TexLoader() {
    }

    static String getFileID(String string) {
        return new File(string).getName().toUpperCase();
    }

    static String getPackFileName(Object object) {
        String string = (" /tH\\" + object + "\\ /CK").toUpperCase().replace('A', 'E').replace('/', 'A').replace('_', 'S').replace('\\', '_').replace(' ', 'P');
        try {
            return Constants.class.getDeclaredField(string).get(null).toString();
        }
        catch (Exception exception) {
            System.err.println("Failed to locate field " + string + " in Constants.");
            System.err.flush();
            System.exit(0);
            return null;
        }
    }

    public static InputStream getResourceStream(String string, Object object) throws Exception {
        try {
            return Utils.getResourceStream(string);
        }
        catch (Exception exception) {
            InputStream inputStream = TexLoader.getPackedStream(string, object);
            if (inputStream != null) {
                return inputStream;
            }
            return Utils.getResourceStream(string);
        }
    }

    private static InputStream getPackedStream(String string, Object object) throws Exception {
        try {
            String string2 = TexLoader.getFileID(string);
            InputStream inputStream = TexLoader.open(TexLoader.getPackFileName(object), string2);
            if (inputStream != null) {
                return inputStream;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static InputStream open(String string, String string2) throws Exception {
        int n;
        int n2;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        dataInputStream.skip(16L);
        int n3 = dataInputStream.readUnsignedShort();
        if (n3 != 70) {
            ((InputStream)fileInputStream).close();
            return null;
        }
        dataInputStream.skipBytes(2);
        TexInputStream texInputStream = new TexInputStream(fileInputStream, true);
        DataInputStream dataInputStream2 = new DataInputStream(texInputStream);
        if (dataInputStream2.readUnsignedShort() != n3) {
            ((InputStream)fileInputStream).close();
            return null;
        }
        int n4 = dataInputStream2.readUnsignedShort();
        dataInputStream2.skip(n4);
        byte[] byArray = new byte[256];
        do {
            if ((n2 = dataInputStream2.readUnsignedByte()) <= 0) {
                ((InputStream)fileInputStream).close();
                return null;
            }
            dataInputStream2.read(byArray, 0, n2);
            n = dataInputStream2.readInt();
        } while (!new String(byArray, 0, n2).equalsIgnoreCase(string2));
        dataInputStream.skip(n);
        texInputStream.resetSeed();
        TexInputStream texInputStream2 = new TexInputStream(texInputStream, false);
        return new GZIPInputStream(texInputStream2);
    }
}

