/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.IBankMemory;
import frc.emul.api.MemoryType;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.util.RawMemory;
import frc.emul.vectrex.PersistentSection;
import frc.emul.vectrex.VectrexMemory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class BankMemory
extends RawMemory
implements IBankMemory {
    private final boolean GENERATED_BANKS = false;
    private final int GENERATED_COUNT = 500;
    private byte[][] banks;
    private int[] sizes;
    private int selectedIdx;
    private int banksLoaded;

    public BankMemory(MemoryType memoryType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3) {
        super(memoryType, n, n2, bl, bl2, bl3, bl4);
        this.banks = new byte[n3][];
        this.sizes = new int[n3];
        while (n3-- > 1) {
            this.banks[n3] = new byte[n2];
            this.sizes[n3] = -1;
        }
        this.banks[0] = this.buff;
        this.sizes[0] = -1;
    }

    public final void fill(byte by) {
        int n = this.banks.length;
        while (n-- > 0) {
            Arrays.fill(this.banks[n], by);
        }
    }

    protected final boolean loadRaw(InputStream inputStream) throws IOException {
        this.banksLoaded = 0;
        int n = 0;
        while (n < this.banks.length) {
            int n2 = inputStream.read(this.banks[n]);
            if (n2 <= 0) break;
            ++this.banksLoaded;
            this.sizes[n] = n2;
            if (n2 < this.banks[n].length) break;
            ++n;
        }
        if (this.banksLoaded == this.getBanksCount() && inputStream.available() > 0) {
            System.err.println("WARNING: The cartridge binary ROM size exceeds the " + this.getBanksCount() + "x" + this.getSize() / 1024 + "KB limit" + " (the remaining bytes will get discarded)");
        }
        return this.banksLoaded > 0;
    }

    public int getLoadedSize() {
        int n = -1;
        int[] nArray = this.sizes;
        int n2 = this.sizes.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            n = Math.max(n4, n);
            ++n3;
        }
        return n;
    }

    public final boolean dump(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n < this.banksLoaded) {
            byte[] byArray = this.banks[n];
            int n2 = this.sizes[n];
            outputStream.write(byArray, 0, n2);
            ++n;
        }
        return true;
    }

    public final boolean feed(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException("Operation not allowed on bankable memory");
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write8(this.banksLoaded);
        iPersistenceWriter.write8(this.selectedIdx);
        int n = 0;
        while (n < this.banksLoaded) {
            int n2 = this.sizes[n];
            iPersistenceWriter.openSection(PersistentSection.MEM_BANK);
            iPersistenceWriter.write16(n2);
            iPersistenceWriter.write16(this.banks[n].length);
            if (n2 > 0) {
                iPersistenceWriter.write(this.banks[n], 0, n2);
            }
            iPersistenceWriter.closeSection();
            ++n;
        }
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.banksLoaded = iPersistenceReader.readS8();
        this.banks = new byte[this.banksLoaded][];
        this.sizes = new int[this.banksLoaded];
        int n = iPersistenceReader.readS8();
        int n2 = 0;
        while (n2 < this.banksLoaded) {
            iPersistenceReader.openSection(PersistentSection.MEM_BANK);
            int n3 = iPersistenceReader.readU16();
            this.banks[n2] = new byte[iPersistenceReader.readU16()];
            this.sizes[n2] = n3;
            if (n3 > 0) {
                iPersistenceReader.read(this.banks[n2], 0, n3);
            }
            iPersistenceReader.closeSection();
            ++n2;
        }
        this.setSelectedBank(n);
    }

    public void setWritable(boolean bl) {
        super.setWritable(bl);
    }

    public final int getBanksCount() {
        return this.banks.length;
    }

    public final int getLoadedBankSize(int n) {
        return n < this.getLoadedBanksCount() ? this.sizes[n] : -1;
    }

    public final int getLoadedBanksCount() {
        return this.banksLoaded;
    }

    public final int getSelectedBank() {
        return this.selectedIdx;
    }

    public final void setSelectedBank(int n) {
        try {
            this.buff = this.banks[n];
            this.selectedIdx = n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid memory bank ID #" + n);
        }
    }

    public boolean isValidCartridgeHeader(int n) {
        byte[] byArray;
        try {
            byArray = this.banks[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid memory bank ID #" + n);
        }
        return VectrexMemory.isValidCartridgeHeader(byArray);
    }

    public final boolean load(InputStream[] inputStreamArray) throws IOException {
        if (inputStreamArray.length > this.getBanksCount()) {
            throw new IllegalArgumentException("Number of banks too high");
        }
        int n = this.banks.length;
        while (n-- > 0) {
            this.sizes[n] = inputStreamArray[n].read(this.banks[n]);
        }
        this.banksLoaded = inputStreamArray.length;
        return true;
    }
}

