/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.config.data.CfgItemGame;
import frc.emul.util.BinaryPersistenceHeader;
import frc.emul.util.BinaryPersistenceReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.filechooser.FileFilter;

public final class BinaryPersistenceFileFilter
extends FileFilter {
    private final String expectedGameID;
    private final int expectedGameCRC;

    public static FileFilter createShallowFilter() {
        return new BinaryPersistenceFileFilter(0, null);
    }

    public static FileFilter createDeepFilter(CfgItemGame cfgItemGame) {
        return new BinaryPersistenceFileFilter((int)cfgItemGame.info.getBinaryCRC32(), cfgItemGame.getID());
    }

    private BinaryPersistenceFileFilter(int n, String string) {
        this.expectedGameCRC = n;
        this.expectedGameID = string;
    }

    public String getDescription() {
        return String.valueOf(this.expectedGameID != null ? "ParaJVE compatible save files (*" : "ParaJVE save files (*") + ".jvesav" + ")";
    }

    /*
     * Loose catch block
     */
    public boolean accept(File file) {
        boolean bl;
        InputStream inputStream;
        block14: {
            if (!file.isFile()) {
                return true;
            }
            if (!file.getName().toLowerCase().endsWith(".jvesav")) {
                return false;
            }
            if (this.expectedGameID == null) {
                return true;
            }
            inputStream = null;
            inputStream = new BufferedInputStream(new FileInputStream(file), 256);
            BinaryPersistenceHeader binaryPersistenceHeader = new BinaryPersistenceHeader();
            BinaryPersistenceReader binaryPersistenceReader = new BinaryPersistenceReader(binaryPersistenceHeader, inputStream);
            bl = binaryPersistenceHeader.checkHeader(this.expectedGameCRC, this.expectedGameID, binaryPersistenceReader);
            if (inputStream == null) break block14;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl;
        catch (Exception exception) {
            block15: {
                try {
                    if (inputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception3) {}
            }
            return false;
        }
    }
}

