/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.persistence.IGenericSection;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.config.data.CfgItemGame;
import frc.emul.util.BinaryPersistenceHeader;
import frc.emul.util.BinaryPersistenceWriter;
import frc.emul.util.Utils;
import frc.emul.vectrex.PersistenceManager;
import frc.emul.vectrex.PersistentSection;
import frc.util.IntStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryPersistenceReader
implements IPersistenceReader {
    private static final String ERRMSG_GENERIC = "Error while reading from the save file.";
    private static final String ERRMSG_INVALID = "The save file does not contain valid data.";
    private final BinaryPersistenceHeader header;
    private List<IPersistentSection> sections;
    private IntStack offsets;
    private InputStream in;
    private int readBytesCount;

    public static BinaryPersistenceReader open(File file) throws PersistenceException {
        return BinaryPersistenceReader.open(null, file);
    }

    public static BinaryPersistenceReader open(CfgItemGame cfgItemGame, File file) throws PersistenceException {
        if (!file.isFile()) {
            throw new PersistenceException("File-System", "The specified save file does not exist.");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            throw new PersistenceException("File-System", "Could not read the specified save file.", exception);
        }
        BinaryPersistenceHeader binaryPersistenceHeader = new BinaryPersistenceHeader();
        BinaryPersistenceReader binaryPersistenceReader = new BinaryPersistenceReader(binaryPersistenceHeader, fileInputStream);
        try {
            binaryPersistenceHeader.loadHeader(cfgItemGame, binaryPersistenceReader);
            binaryPersistenceReader.debug("Header loaded (format $" + Utils.HEX4(binaryPersistenceHeader.getSaveFormat()) + ", debug=" + binaryPersistenceHeader.isDebugEnabled() + ")");
            if (binaryPersistenceHeader.isCompressed()) {
                binaryPersistenceReader.uncompressInputStream();
            }
        }
        catch (PersistenceException persistenceException) {
            try {
                binaryPersistenceReader.close();
            }
            catch (Exception exception) {}
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {}
            throw persistenceException;
        }
        return binaryPersistenceReader;
    }

    BinaryPersistenceReader(BinaryPersistenceHeader binaryPersistenceHeader, InputStream inputStream) {
        this.header = binaryPersistenceHeader;
        this.in = inputStream;
    }

    private PersistenceException createGenericException(Exception exception) {
        return new PersistenceException(this.readBytesCount, this.getCurrentSectionPath(), ERRMSG_GENERIC, exception);
    }

    private PersistenceException createInvalidException() {
        return new PersistenceException(this.readBytesCount, this.getCurrentSectionPath(), ERRMSG_INVALID);
    }

    private String getSectionID(IPersistentSection iPersistentSection) {
        return BinaryPersistenceWriter.getSectionID(iPersistentSection);
    }

    private String getCurrentSectionPath() {
        return BinaryPersistenceWriter.getCurrentSectionPath(this.getSections());
    }

    private List<IPersistentSection> getSections() {
        if (this.sections == null) {
            this.sections = new ArrayList<IPersistentSection>();
            this.offsets = new IntStack();
        }
        return this.sections;
    }

    private void uncompressInputStream() throws PersistenceException {
        if (!(this.in instanceof GZIPInputStream)) {
            try {
                this.debug("Switching to compressed input stream");
                this.in = new GZIPInputStream(this.in);
            }
            catch (Exception exception) {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (Exception exception2) {}
                }
                throw new PersistenceException(this.readBytesCount, "File-Header", "Failed to create a compressed input stream for the save file.", exception);
            }
        }
    }

    private int nextByte() throws PersistenceException {
        try {
            int n = this.in.read();
            if (n < 0) {
                throw new PersistenceException(this.readBytesCount, this.getCurrentSectionPath(), "Unexpected End of File");
            }
            ++this.readBytesCount;
            return n;
        }
        catch (IOException iOException) {
            throw this.createGenericException(iOException);
        }
    }

    private int readSectionLength() throws PersistenceException {
        int n = this.readU16();
        if (n >= 65280) {
            n = (n & 0xFF) << 16 | this.readU16();
        }
        return n;
    }

    private void debug(String string) {
        if (PersistenceManager.DEBUG_READ) {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append(" [DBG] ");
            int n = this.getSections().size();
            while (n-- > 0) {
                stringBuilder.append("|  ");
            }
            stringBuilder.append(string).append(" (").append(this.getCurrentSectionPath().toUpperCase()).append(" at $").append(Integer.toHexString(this.readBytesCount).toUpperCase()).append(")");
            System.out.println(stringBuilder);
        }
    }

    public BinaryPersistenceHeader getHeader() {
        return this.header;
    }

    @Override
    public void close() throws PersistenceException {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException(this.readBytesCount, "File-System", "Could not close the save input file.", iOException);
        }
    }

    @Override
    public int getSaveVersion() {
        return this.getHeader().getSaveVersion();
    }

    @Override
    public Date getSaveDate() {
        return new Date(this.getHeader().getSaveDate());
    }

    @Override
    public void closeSection() throws PersistenceException {
        IPersistentSection iPersistentSection = null;
        try {
            List<IPersistentSection> list = this.getSections();
            if (PersistenceManager.DEBUG_READ) {
                this.debug("Closing section " + this.getSectionID(list.get(list.size() - 1)));
            }
            iPersistentSection = list.remove(list.size() - 1);
            int n = this.offsets.pop();
            int n2 = n - this.readBytesCount;
            if (n2 != 0) {
                if (PersistenceManager.DEBUG_READ) {
                    this.debug("*** Skipping " + n2 + " bytes to close section " + this.getSectionID(iPersistentSection));
                }
                if (n2 < 0) {
                    PersistenceException persistenceException = this.createInvalidException();
                    persistenceException.setDetails("Read " + -n2 + " bytes past section " + this.getSectionID(iPersistentSection));
                    throw persistenceException;
                }
                this.skip(n2);
            }
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = this.createGenericException(exception);
            persistenceException.setDetails("closing section " + this.getSectionID(iPersistentSection));
            throw persistenceException;
        }
    }

    @Override
    public int openSection(IPersistentSection iPersistentSection) throws PersistenceException {
        try {
            this.getSections().add(iPersistentSection);
            int n = this.readU16();
            if (iPersistentSection instanceof GenericSection) {
                ((GenericSection)iPersistentSection).setID(n);
            } else if (n != iPersistentSection.getID()) {
                PersistenceException persistenceException = this.createInvalidException();
                persistenceException.setOffset(this.readBytesCount - 2);
                persistenceException.setDetails("section mismatch: expected ID " + this.getSectionID(iPersistentSection) + ", got $" + Utils.HEX4(n));
                throw persistenceException;
            }
            int n2 = this.readSectionLength();
            this.offsets.push(this.readBytesCount + n2);
            if (PersistenceManager.DEBUG_READ) {
                this.debug("Opened section " + this.getSectionID(iPersistentSection) + " with length=$" + Integer.toHexString(n2));
            }
            return n2;
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = this.createGenericException(exception);
            persistenceException.setDetails("opening section " + this.getSectionID(iPersistentSection));
            throw persistenceException;
        }
    }

    @Override
    public IGenericSection openSection() throws PersistenceException {
        GenericSection genericSection = new GenericSection();
        int n = this.openSection(genericSection);
        genericSection.setSize(n);
        return genericSection;
    }

    @Override
    public int fetchSection(IPersistentSection ... iPersistentSectionArray) throws PersistenceException {
        int n = 0;
        IPersistentSection[] iPersistentSectionArray2 = iPersistentSectionArray;
        int n2 = iPersistentSectionArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IPersistentSection iPersistentSection = iPersistentSectionArray2[n3];
            n = this.fetchSection(iPersistentSection);
            ++n3;
        }
        return n;
    }

    @Override
    public int fetchSection(IPersistentSection iPersistentSection) throws PersistenceException {
        int n = -1;
        int n2 = 0;
        try {
            while (iPersistentSection.getID() != n) {
                this.skip(n2);
                n = this.readU16();
                n2 = this.readSectionLength();
            }
        }
        catch (Exception exception) {
            throw new PersistenceException(this.readBytesCount, "File-Seek", "Error while searching for section " + this.getSectionID(iPersistentSection), exception);
        }
        return n2;
    }

    @Override
    public void read(IPersistentObject iPersistentObject) throws PersistenceException {
        IPersistentSection iPersistentSection = iPersistentObject.getSection();
        if (iPersistentSection != null) {
            this.openSection(iPersistentSection);
        }
        try {
            iPersistentObject.load(this);
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = this.createGenericException(exception);
            persistenceException.setDetails("loading persistent object " + iPersistentObject);
            throw persistenceException;
        }
        if (iPersistentSection != null) {
            this.closeSection();
        }
    }

    @Override
    public byte[] read(int n) throws PersistenceException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return byArray;
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws PersistenceException {
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3 + n] = (byte)this.nextByte();
            ++n3;
        }
    }

    @Override
    public boolean readBool() throws PersistenceException {
        return this.nextByte() != 0;
    }

    @Override
    public float readFloat() throws PersistenceException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readU8() throws PersistenceException {
        return this.nextByte();
    }

    @Override
    public int readS8() throws PersistenceException {
        return (byte)this.nextByte();
    }

    @Override
    public int readU16() throws PersistenceException {
        return this.nextByte() << 8 | this.nextByte();
    }

    @Override
    public int readS16() throws PersistenceException {
        return (byte)this.nextByte() << 8 | this.nextByte();
    }

    @Override
    public int readInt() throws PersistenceException {
        return this.nextByte() << 24 | this.nextByte() << 16 | this.nextByte() << 8 | this.nextByte();
    }

    @Override
    public long readLong() throws PersistenceException {
        return (long)this.readInt() << 32 | 0xFFFFFFFFL & (long)this.readInt();
    }

    @Override
    public String readStr() throws PersistenceException {
        StringBuilder stringBuilder = new StringBuilder(32);
        int n;
        while ((n = this.nextByte()) != 0) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkID(String string) {
        try {
            byte[] byArray = string.getBytes();
            int n = 0;
            while (true) {
                if (n >= byArray.length) {
                    return true;
                }
                if (byArray[n] != (byte)this.nextByte()) {
                    return false;
                }
                ++n;
            }
        }
        catch (PersistenceException persistenceException) {
            return false;
        }
    }

    @Override
    public void skip(int n) throws PersistenceException {
        if (n > 0) {
            try {
                long l = this.in.skip(n);
                this.readBytesCount = (int)((long)this.readBytesCount + l);
                if ((long)n != l) {
                    PersistenceException persistenceException = this.createGenericException(null);
                    persistenceException.setDetails("skipped " + l + " bytes instead of " + n);
                    throw persistenceException;
                }
            }
            catch (IOException iOException) {
                PersistenceException persistenceException = this.createGenericException(iOException);
                persistenceException.setDetails("skipping " + n + " bytes");
                throw persistenceException;
            }
        }
    }

    public static class GenericSection
    implements IGenericSection {
        private String tag;
        private int size;
        private int id = PersistentSection.INVALID.getID();

        public void setTag(String string) {
            this.tag = string;
        }

        public void setSize(int n) {
            this.size = n;
        }

        public void setID(int n) {
            this.id = n;
        }

        public String getTag() {
            return this.tag;
        }

        public int getSize() {
            return this.size;
        }

        public int getID() {
            return this.id;
        }
    }
}

