/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.IMemory;
import frc.emul.api.MemoryType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MultipleMemory
implements IMemory {
    private final IMemory[] wBanks;
    private final IMemory rBank;
    private final int[] wOffsets;
    private final int rOffset;
    private final int base;
    private final int size;

    public MultipleMemory(int n, int n2, IMemory[] iMemoryArray) {
        this(n, n2, iMemoryArray, iMemoryArray[0]);
    }

    public MultipleMemory(int n, int n2, IMemory[] iMemoryArray, IMemory iMemory) {
        this.wBanks = iMemoryArray;
        this.rBank = iMemory;
        this.base = n;
        this.size = iMemory.getSize();
        this.wOffsets = new int[iMemoryArray.length];
        int n3 = iMemoryArray.length;
        while (n3-- > 0) {
            this.wOffsets[n3] = iMemoryArray[n3].getFirstAddress() - n;
            assert (n2 <= iMemoryArray[n3].getSize());
        }
        this.rOffset = iMemory.getFirstAddress() - n;
    }

    public MemoryType getType() {
        return MemoryType.OTHER;
    }

    public int readS8(int n) {
        return this.rBank.readS8(n + this.rOffset);
    }

    public int readU8(int n) {
        return this.rBank.readU8(n + this.rOffset);
    }

    public void write8(int n, int n2) {
        int n3 = this.wBanks.length;
        while (n3-- > 0) {
            this.wBanks[n3].write8(n + this.wOffsets[n3], n2);
        }
    }

    public int readS16(int n) {
        return this.rBank.readS16(n + this.rOffset);
    }

    public int readU16(int n) {
        return this.rBank.readU16(n + this.rOffset);
    }

    public void write16(int n, int n2) {
        int n3 = this.wBanks.length;
        while (n3-- > 0) {
            this.wBanks[n3].write16(n + this.wOffsets[n3], n2);
        }
    }

    public boolean canRead(int n, int n2) {
        return this.rBank.canRead(n + this.rOffset, n2);
    }

    public boolean canWrite(int n, int n2) {
        return this.wBanks[0].canWrite(n + this.wOffsets[0], n2);
    }

    public boolean canExecute(int n, int n2) {
        return this.rBank.canExecute(n + this.rOffset, n2);
    }

    public boolean isValidArea(int n, int n2) {
        return n - this.base + n2 <= this.size;
    }

    public int getSize() {
        return this.size;
    }

    public int getLoadedSize() {
        return this.getSize();
    }

    public int getFirstAddress() {
        return this.base;
    }

    public int getLastAddress() {
        return this.base + this.getSize() - 1;
    }

    public void fill(byte by) {
        int n = this.wBanks.length;
        while (n-- > 0) {
            this.wBanks[n].fill(by);
        }
    }

    public boolean dump(OutputStream outputStream) throws IOException {
        return this.rBank.dump(outputStream);
    }

    public boolean save(OutputStream outputStream, boolean bl) throws IOException {
        return this.rBank.save(outputStream, bl);
    }

    public boolean load(InputStream inputStream, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean feed(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }
}

