/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.IEditableMemory;
import frc.emul.api.IMemory;
import frc.emul.api.MemoryType;
import frc.emul.util.Utils;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class NullMemory
implements IMemory,
IEditableMemory {
    private final boolean canWrite;
    private final int base;
    private final int size;
    private final int sContent;
    private final int uContent;
    private boolean fatalW;
    private boolean fatalR;
    private boolean emuTag;
    private static final int TAG_ADDR = 47825;
    private static final int TAG_BYTE = 42;

    public NullMemory(int n, int n2, boolean bl, int n3) {
        this.fatalR = this.fatalW = false;
        this.emuTag = true;
        this.canWrite = bl;
        this.base = n;
        this.size = n2;
        this.uContent = n3 & 0xFF;
        this.sContent = Utils.extendByte(n3);
    }

    public void setFatalReadAccess(boolean bl) {
        this.fatalR = bl;
    }

    public boolean isFatalReadAccess() {
        return this.fatalR;
    }

    public void setFatalWriteAccess(boolean bl) {
        this.fatalW = bl;
    }

    public boolean isFatalWriteAccess() {
        return this.fatalW;
    }

    public void setInstalledEmulatorTag(boolean bl) {
        this.emuTag = bl;
    }

    public boolean idInstalledEmulatorTag(boolean bl) {
        return this.emuTag;
    }

    private final void error(boolean bl, int n) {
        String string = bl ? "read" : "write";
        throw new InvalidParameterException("Invalid " + string + " access to memory address $" + Utils.hex(4, n));
    }

    public MemoryType getType() {
        return MemoryType.NULL;
    }

    public int readS8(int n) {
        if (this.emuTag && n == 47825) {
            return 42;
        }
        if (this.fatalR) {
            this.error(true, n);
        }
        return this.sContent;
    }

    public int readU8(int n) {
        if (this.emuTag && n == 47825) {
            return 42;
        }
        if (this.fatalR) {
            this.error(true, n);
        }
        return this.uContent;
    }

    public void write8(int n, int n2) {
        if (this.fatalW) {
            this.error(false, n);
        }
    }

    public int readS16(int n) {
        if (this.fatalR) {
            this.error(true, n);
        }
        return this.sContent;
    }

    public int readU16(int n) {
        if (this.fatalR) {
            this.error(true, n);
        }
        return this.uContent;
    }

    public void write16(int n, int n2) {
        if (this.fatalW) {
            this.error(false, n);
        }
    }

    public void fill(byte by) {
        throw new UnsupportedOperationException();
    }

    public boolean dump(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public boolean save(OutputStream outputStream, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean load(InputStream inputStream, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean feed(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public int getLoadedSize() {
        return this.getSize();
    }

    public int getSize() {
        return this.size;
    }

    public int getFirstAddress() {
        return this.base;
    }

    public int getLastAddress() {
        return this.base + this.size - 1;
    }

    public boolean isValidArea(int n, int n2) {
        return n - this.base + n2 <= this.size;
    }

    public boolean canRead(int n, int n2) {
        return this.isValidArea(n, n2);
    }

    public boolean canWrite(int n, int n2) {
        return this.canWrite && this.isValidArea(n, n2);
    }

    public boolean canExecute(int n, int n2) {
        return false;
    }

    public void peek(byte[] byArray, int n, int n2, int n3) {
        Arrays.fill(byArray, n2, n2 + n3, (byte)this.uContent);
    }

    public void poke(byte[] byArray, int n, int n2, int n3) {
    }
}

