/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.IReadOnlyMemory;
import frc.emul.api.MemoryNotAvailableException;
import frc.emul.api.MemoryType;

public class PartialReadMemory
implements IReadOnlyMemory {
    private final boolean bigI;
    private final int memBase;
    private final int memSize;
    private int dataBase;
    private byte[] data;

    public PartialReadMemory(int n, int n2, boolean bl) {
        this.memBase = n;
        this.memSize = n2;
        this.bigI = bl;
    }

    public void setContent(byte[] byArray, int n) {
        this.dataBase = n;
        this.data = byArray;
    }

    public MemoryType getType() {
        return MemoryType.OTHER;
    }

    public int getSize() {
        return this.memSize;
    }

    public int getLoadedSize() {
        return this.getSize();
    }

    public int getFirstAddress() {
        return this.memBase;
    }

    public int getLastAddress() {
        return this.memBase + this.memSize - 1;
    }

    public boolean isValidArea(int n, int n2) {
        return (n -= this.dataBase) >= 0 && n + n2 <= this.data.length;
    }

    public boolean canRead(int n, int n2) {
        return this.isValidArea(n, n2);
    }

    public boolean canExecute(int n, int n2) {
        return false;
    }

    public int readS8(int n) {
        return this.get(this.debase(n));
    }

    public int readU8(int n) {
        return 0xFF & this.get(this.debase(n));
    }

    public int readS16(int n) {
        n = this.debase(n);
        if (this.bigI) {
            return this.get(n) << 8 | 0xFF & this.get(n + 1);
        }
        return this.get(n + 1) << 8 | 0xFF & this.get(n);
    }

    public int readU16(int n) {
        n = this.debase(n);
        if (this.bigI) {
            return (0xFF & this.get(n)) << 8 | 0xFF & this.get(n + 1);
        }
        return (0xFF & this.get(n + 1)) << 8 | 0xFF & this.get(n);
    }

    private final int debase(int n) {
        return (n & Integer.MAX_VALUE) - this.dataBase;
    }

    private final int get(int n) {
        try {
            return this.data[n];
        }
        catch (Exception exception) {
            throw new MemoryNotAvailableException();
        }
    }
}

