/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.IMemory;
import frc.emul.mc6809.MC6809;
import frc.emul.mc6809.Operand;
import frc.emul.mc6809.Regs;
import frc.emul.mc6809.dasm.IDasmRegs;
import frc.util.IStream;
import frc.util.Unsafe;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final char[] DIGITS;
    public static final char[] digits;
    public static final String CRLF;
    public static final Boolean JVM_64;
    public static final boolean JVM_1_5;
    public static final boolean JVM_1_6;
    public static final boolean LINUX;
    public static final boolean MAC_OS_X;
    public static final boolean WINDOWS;

    static {
        Integer n;
        int n2;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac")) {
            LINUX = false;
            MAC_OS_X = true;
            WINDOWS = false;
        } else if (string.contains("windows")) {
            LINUX = false;
            MAC_OS_X = false;
            WINDOWS = true;
        } else {
            LINUX = true;
            MAC_OS_X = false;
            WINDOWS = false;
        }
        String string2 = System.getProperty("java.specification.version", "1.5");
        if ("1.5".equals(string2)) {
            JVM_1_5 = true;
            JVM_1_6 = false;
        } else {
            JVM_1_5 = false;
            JVM_1_6 = true;
        }
        String string3 = System.getProperty("sun.arch.data.model", null);
        JVM_64 = string3 != null ? ("64".equals(string3) ? Boolean.TRUE : Boolean.FALSE) : ((n2 = System.getProperty("java.vm.name").indexOf("64")) >= 0 ? Boolean.TRUE : ((n = Unsafe.getJvmAddressSize()) != null ? (n == 64 ? Boolean.TRUE : Boolean.FALSE) : null));
        CRLF = System.getProperty("line.separator");
    }

    private Utils() {
    }

    public static final boolean isNegativeByte(int n) {
        return (n & 0x80) != 0;
    }

    public static final boolean isPositiveByte(int n) {
        return (n & 0x80) == 0;
    }

    public static final int clampByte(int n) {
        return 0xFF & n;
    }

    public static final int extendByte(int n) {
        return (byte)n;
    }

    public static final int extendWord(int n) {
        return (n & 0x8000) != 0 ? 0xFFFF0000 | n : n;
    }

    public static final void write16(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2] = (byte)(n >> 8);
            byArray[n2 + 1] = (byte)n;
        } else {
            byArray[n2] = (byte)n;
            byArray[n2 + 1] = (byte)(n >> 8);
        }
    }

    public static final void write16_BI(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static final void write16_LI(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
    }

    public static final int read16(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            return (0xFF & byArray[n2]) << 8 | 0xFF & byArray[n2 + 1];
        }
        return 0xFF & byArray[n2] | (0xFF & byArray[n2 + 1]) << 8;
    }

    public static final int read16_BI(byte[] byArray, int n) {
        return (0xFF & byArray[n]) << 8 | 0xFF & byArray[n + 1];
    }

    public static final int read16_LI(byte[] byArray, int n) {
        return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8;
    }

    public static final void write32(int n, byte[] byArray, int n2, boolean bl) {
        if (bl) {
            byArray[n2++] = (byte)(n >> 24);
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2] = (byte)n;
        } else {
            byArray[n2++] = (byte)n;
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2] = (byte)(n >> 24);
        }
    }

    public static final void write32_BI(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >> 24);
        byArray[n2++] = (byte)(n >> 16);
        byArray[n2++] = (byte)(n >> 8);
        byArray[n2] = (byte)n;
    }

    public static final void write32_LI(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >> 8);
        byArray[n2++] = (byte)(n >> 16);
        byArray[n2] = (byte)(n >> 24);
    }

    public static final int read32(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return byArray[n] << 24 | (0xFF & byArray[n + 1]) << 16 | (0xFF & byArray[n + 2]) << 8 | 0xFF & byArray[n + 3];
        }
        return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8 | (0xFF & byArray[n + 2]) << 16 | byArray[n + 3] << 24;
    }

    public static final int read32_BI(byte[] byArray, int n) {
        return byArray[n] << 24 | (0xFF & byArray[n + 1]) << 16 | (0xFF & byArray[n + 2]) << 8 | 0xFF & byArray[n + 3];
    }

    public static final int read32_LI(byte[] byArray, int n) {
        return 0xFF & byArray[n] | (0xFF & byArray[n + 1]) << 8 | (0xFF & byArray[n + 2]) << 16 | byArray[n + 3] << 24;
    }

    public static final String dump(IMemory iMemory, int n, int n2, boolean bl) {
        if (!bl) {
            return Utils.dump(iMemory, n, n2);
        }
        if (n2 <= 0) {
            return "";
        }
        int n3 = iMemory.readU8(n++);
        StringBuffer stringBuffer = Utils.HEX(2, n3, new StringBuffer(n2 * 4 + 4));
        StringBuffer stringBuffer2 = new StringBuffer(n2 + 4).append((char)n3);
        int n4 = 1;
        while (n4 < n2) {
            n3 = iMemory.readU8(n++);
            Utils.HEX(2, n3, stringBuffer.append(' '));
            stringBuffer2.append((char)n3);
            ++n4;
        }
        return stringBuffer.append("  {").append(stringBuffer2).append('}').toString();
    }

    public static final String dump(IMemory iMemory, int n, int n2) {
        if (n2 <= 0) {
            return "";
        }
        StringBuffer stringBuffer = Utils.HEX(2, iMemory.readU8(n++), new StringBuffer(n2 * 3));
        int n3 = 1;
        while (n3 < n2) {
            Utils.HEX(2, iMemory.readU8(n++), stringBuffer.append(' '));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static final String dump(byte[] byArray) {
        return Utils.dump(byArray, 0, byArray.length);
    }

    public static final String dump(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return "";
        }
        StringBuffer stringBuffer = Utils.HEX(2, 0xFF & byArray[n], new StringBuffer(n2 * 3));
        int n3 = 1;
        while (n3 < n2) {
            Utils.HEX(2, 0xFF & byArray[n + n3], stringBuffer.append(' '));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static final String hex2(int n) {
        return new String(new char[]{digits[n >> 4 & 0xF], digits[n & 0xF]});
    }

    public static final String HEX2(int n) {
        return new String(new char[]{DIGITS[n >> 4 & 0xF], DIGITS[n & 0xF]});
    }

    public static final StringBuilder HEX2(int n, StringBuilder stringBuilder) {
        return stringBuilder.append(DIGITS[n >> 4 & 0xF]).append(DIGITS[n & 0xF]);
    }

    public static final String hex4(int n) {
        return new String(new char[]{digits[n >> 12 & 0xF], digits[n >> 8 & 0xF], digits[n >> 4 & 0xF], digits[n & 0xF]});
    }

    public static final String HEX4(int n) {
        return new String(new char[]{DIGITS[n >> 12 & 0xF], DIGITS[n >> 8 & 0xF], DIGITS[n >> 4 & 0xF], DIGITS[n & 0xF]});
    }

    public static final StringBuffer HEX4(int n, StringBuffer stringBuffer) {
        return stringBuffer.append(DIGITS[n >> 12 & 0xF]).append(DIGITS[n >> 8 & 0xF]).append(DIGITS[n >> 4 & 0xF]).append(DIGITS[n & 0xF]);
    }

    public static final String hex(int n, int n2) {
        String string = Integer.toHexString(n2);
        int n3 = string.length();
        if (n3 < n) {
            string = String.valueOf("00000000".substring(8 - n + n3)) + string;
        }
        return string;
    }

    public static final String HEX(int n, int n2) {
        String string = Integer.toHexString(n2).toUpperCase();
        int n3 = string.length();
        if (n3 < n) {
            string = String.valueOf("00000000".substring(8 - n + n3)) + string;
        }
        return string;
    }

    public static final String HEX(long l) {
        String string = Long.toHexString(l).toUpperCase();
        int n = string.length();
        if (n < 16) {
            string = String.valueOf("0000000000000000".substring(n)) + string;
        }
        return string;
    }

    public static final StringBuffer hex(int n, int n2, StringBuffer stringBuffer) {
        String string = Integer.toHexString(n2);
        n -= string.length();
        while (n-- > 0) {
            stringBuffer.append('0');
        }
        return stringBuffer.append(string);
    }

    public static final StringBuffer HEX(int n, int n2, StringBuffer stringBuffer) {
        String string = Integer.toHexString(n2).toUpperCase();
        n -= string.length();
        while (n-- > 0) {
            stringBuffer.append('0');
        }
        return stringBuffer.append(string);
    }

    public static final String dec(int n, int n2) {
        String string = Integer.toString(n2);
        int n3 = string.length();
        if (n3 < n) {
            string = String.valueOf("0000000000000000".substring(16 - n + n3)) + string;
        }
        return string;
    }

    public static final String dec(int n, long l) {
        String string = Long.toString(l);
        int n2 = string.length();
        if (n2 < n) {
            string = String.valueOf("0000000000000000".substring(16 - n + n2)) + string;
        }
        return string;
    }

    public static final String bin(int n, int n2) {
        return Utils.bin(n, n2, new StringBuffer()).toString();
    }

    public static final StringBuffer bin(int n, int n2, StringBuffer stringBuffer) {
        int n3 = 1 << n - 1;
        while (n3 != 0) {
            stringBuffer.append((n2 & n3) == 0 ? (char)'0' : '1');
            n3 >>= 1;
        }
        return stringBuffer;
    }

    public static final StringBuffer appendPad(String string, int n, char c, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        int n2 = n - string.length();
        while (n2-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public static final StringBuffer pad(int n, char c, StringBuffer stringBuffer) {
        int n2 = n - stringBuffer.length();
        while (n2-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public static final StringBuffer fill(int n, char c, StringBuffer stringBuffer) {
        while (n-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public static boolean checkHeader(InputStream inputStream, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length];
        inputStream.read(byArray2);
        int n = byArray.length;
        while (n-- > 0) {
            if (byArray2[n] == byArray[n]) continue;
            return false;
        }
        return true;
    }

    public static String getStrParam(String[] stringArray, String string) {
        if (stringArray != null) {
            string = String.valueOf(string.toLowerCase()) + "=";
            int n = stringArray.length;
            while (n-- > 0) {
                if (!stringArray[n].toLowerCase().startsWith(string)) continue;
                return stringArray[n].substring(string.length());
            }
        }
        return null;
    }

    public static boolean containsParam(String[] stringArray, String string) {
        if (stringArray != null) {
            int n = stringArray.length;
            while (n-- > 0) {
                if (!string.equalsIgnoreCase(stringArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getBoolParam(String[] stringArray, String string, boolean bl) {
        String string2 = Utils.getStrParam(stringArray, string);
        return string2 == null ? bl : "true".equalsIgnoreCase(string2);
    }

    public static Boolean getSwitchParam(String[] stringArray, String string, boolean bl) {
        String string2;
        String string3 = Utils.getStrParam(stringArray, string);
        if (string3 == null) {
            return null;
        }
        String string4 = bl ? "ON" : "TRUE";
        String string5 = string2 = bl ? "OFF" : "FALSE";
        if (string4.equalsIgnoreCase(string3)) {
            return Boolean.TRUE;
        }
        if (string2.equalsIgnoreCase(string3)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("*** Invalid value \"" + string3 + "\" for parameter \"" + string.toUpperCase() + "\" (only \"" + string4 + "\" and \"" + string2 + "\" are allowed)");
    }

    public static Integer getOptionParam(String[] stringArray, String string, int ... nArray) {
        String string2 = Utils.getStrParam(stringArray, string);
        if (string2 == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string2);
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                if (n4 == n) {
                    return n4;
                }
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("*** Invalid value \"" + string2 + "\" for parameter \"" + string.toUpperCase() + "\" (allowed values: " + Utils.dumpArray(nArray) + ")");
    }

    public static final int parseInt(String string) throws NumberFormatException {
        int n = 10;
        if (string.startsWith("$")) {
            string = string.substring(1);
            n = 16;
        } else if (string.startsWith("%")) {
            string = string.substring(1);
            n = 2;
        }
        return Integer.parseInt(string, n);
    }

    public static final int parseInt(String string, int n) {
        if (string != null) {
            try {
                return Utils.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public static final Integer parseInteger(String string) {
        if (string != null) {
            try {
                return new Integer(Utils.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public static final String enforceNull(String string) {
        return string == null || string.length() > 0 ? string : null;
    }

    public static final String enforceEmpty(String string) {
        return string == null ? "" : string;
    }

    public static final String getKey(String string, String string2) {
        return string == null || string.length() == 0 ? (string2 == null || string2.length() == 0 ? null : string2) : (string2 == null || string2.length() == 0 ? string : String.valueOf(string) + "." + string2);
    }

    public static final String substitute(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            if ((objectArray.length & 1) != 0) {
                throw new IllegalArgumentException("The substitutions must have an even number of elements");
            }
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                String string2 = objectArray[n++].toString();
                String string3 = (object = objectArray[n++]) == null ? null : object.toString();
                int n2 = string.indexOf(string2);
                while (n2 >= 0) {
                    if (string3 != null) {
                        string = String.valueOf(string.substring(0, n2)) + string3 + string.substring(n2 + string2.length());
                        n2 += string3.length();
                    } else {
                        string = String.valueOf(string.substring(0, n2)) + string.substring(n2 + string2.length());
                    }
                    n2 = string.indexOf(string2, n2);
                }
            }
        }
        return string;
    }

    public static final String substitute(String string, Map<String, String> map) {
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2);
            int n = string2.length();
            int n2 = string.indexOf(string2);
            while (n2 >= 0) {
                if (string3 != null) {
                    string = String.valueOf(string.substring(0, n2)) + string3 + string.substring(n2 + n);
                    n2 += string3.length();
                } else {
                    string = String.valueOf(string.substring(0, n2)) + string.substring(n2 + n);
                }
                n2 = string.indexOf(string2, n2);
            }
        }
        return string;
    }

    public static final File getTempDir() {
        return Utils.getTempDir(null);
    }

    public static final File getTempDir(String string) {
        File file = new File(string == null ? "data/temp/" : "data/temp/" + string);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new RuntimeException("Failed to create the temporary directory [" + file.getPath() + "]");
        }
        return file;
    }

    public static void deleteFolder(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.isDirectory()) {
                    Utils.deleteFolder(file2);
                } else {
                    file2.delete();
                }
                ++n2;
            }
            file.delete();
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isResourceFile(String string) {
        boolean bl;
        InputStream inputStream;
        block11: {
            inputStream = null;
            inputStream = Utils.getResourceStream(string);
            boolean bl2 = bl = inputStream != null;
            if (inputStream == null) break block11;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
        catch (Exception exception) {
            block12: {
                try {
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }

    public static InputStream getResourceStream(String string) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        Exception exception = null;
        if (inputStream == null) {
            try {
                File file = Utils.getFile(string);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (inputStream == null) {
                throw new RuntimeException("Cannot open resource [" + string + "]", exception);
            }
        }
        return inputStream;
    }

    public static URL getResourceURL(String string) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            try {
                File file = Utils.getFile(string);
                if (file.exists()) {
                    uRL = file.toURI().toURL();
                }
            }
            catch (Exception exception) {}
        }
        return uRL;
    }

    public static synchronized byte[] loadResource(String string) throws IOException {
        InputStream inputStream = Utils.getResourceStream(string);
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    public static String getLocalURL(String string) {
        return String.valueOf((string = Utils.getAbsolutePath(new File(string)).replace('\\', '/')).charAt(0) == '/' ? "file://" : "file:///") + string;
    }

    public static File getFile(String string) {
        return string == null ? null : Utils.getFile(new File(string));
    }

    public static File getFile(File file) {
        String string;
        if (file != null && System.getProperty("os.name").toLowerCase().contains("linux") && ((string = file.getPath()).startsWith("~/") || string.startsWith("$HOME/"))) {
            file = new File(String.valueOf(System.getProperty("user.home")) + string.substring(string.indexOf(47)));
        }
        return file;
    }

    public static String getAbsolutePath(String string) {
        return Utils.getAbsolutePath(new File(string));
    }

    public static String getAbsolutePath(File file) {
        try {
            return file == null ? null : file.getCanonicalPath();
        }
        catch (Exception exception) {
            return file.getPath();
        }
    }

    public static String getRelativePath(String string) {
        return Utils.getRelativePath(new File(string));
    }

    public static String getRelativePath(File file) {
        String string;
        String string2;
        if (file == null) {
            return null;
        }
        File file2 = new File(".");
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file.getPath();
        }
        try {
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file2.getPath();
        }
        if (string2.equals(string)) {
            return ".";
        }
        if (string2.startsWith(String.valueOf(string) + File.separator)) {
            return string2.substring(string.length() + 1);
        }
        return string2;
    }

    public static synchronized File getUniqueFile(File file, String string, String string2) {
        File file2 = new File(file, String.valueOf(string) + string2);
        string = String.valueOf(string) + "_";
        int n = 1;
        while (file2.exists()) {
            file2 = new File(file, String.valueOf(string) + n + string2);
            ++n;
        }
        return file2;
    }

    public static String escapeFileNamePart(String string, String string2) {
        boolean bl = false;
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        int n2 = 0;
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        while (n3 < cArray.length) {
            char c = Character.toLowerCase(cArray[n3]);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                bl = true;
                cArray2[n2++] = c;
            } else if (bl) {
                bl = false;
                cArray2[n2++] = 95;
            }
            ++n3;
        }
        if (!bl) {
            --n2;
        }
        return n2 > 0 ? new String(cArray2, 0, n2) : string2;
    }

    public static synchronized void copy(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException("*** File Copy Failed : Source file does not exists : " + file.getPath());
        }
        byte[] byArray = new byte[8192];
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {}
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final String stripURL(String string) {
        if (string != null) {
            if (string.startsWith("http://")) {
                string = string.substring(7);
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static final StringBuffer encodeHTML(String string, boolean bl) {
        return Utils.encodeHTML(string, new StringBuffer((int)((float)string.length() * 1.1f)), bl);
    }

    public static final StringBuffer encodeHTML(String string, StringBuffer stringBuffer) {
        return Utils.encodeHTML(string, stringBuffer, false);
    }

    public static final StringBuffer encodeHTML(String string, StringBuffer stringBuffer, boolean bl) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        char c2 = bl ? (char)'\n' : '\uffff';
        while (c != '\uffff') {
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&#039;");
            } else if (c == '\\') {
                stringBuffer.append("&#092;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == c2) {
                stringBuffer.append("<br>");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer;
    }

    public static final StringBuffer getRegCCFlags(int n, StringBuffer stringBuffer) {
        return stringBuffer.append((n & 0x80) != 0 ? "E" : "-").append((n & 0x40) != 0 ? "F" : "-").append((n & 0x20) != 0 ? "H" : "-").append((n & 0x10) != 0 ? "I" : "-").append((n & 8) != 0 ? "N" : "-").append((n & 4) != 0 ? "Z" : "-").append((n & 2) != 0 ? "V" : "-").append((n & 1) != 0 ? "C" : "-");
    }

    public static final String getRegCCFlags(int n) {
        return Utils.getRegCCFlags(n, new StringBuffer(8)).toString();
    }

    public static final void dumpProc(MC6809 mC6809, boolean bl) {
        Regs regs = mC6809.getRegisters();
        if (!bl) {
            System.out.println("+------------+------------------------+------+----CC----+");
        }
        System.out.println("| A   B   DP |  X     Y     U     S   |  PC  | EFHINZVC | Cycles");
        System.out.println("| " + Utils.hex(2, regs.A()) + "  " + Utils.hex(2, regs.B()) + "  " + Utils.hex(2, regs.DP()) + " | " + Utils.hex(4, regs.X()) + "  " + Utils.hex(4, regs.Y()) + "  " + Utils.hex(4, regs.U()) + "  " + Utils.hex(4, regs.S()) + " | " + Utils.hex(4, regs.PC()) + " | " + Utils.bin(8, regs.CC()) + " | " + mC6809.getCycles());
        System.out.println("+------------+------------------------+------+----------+");
    }

    public static final String dumpRegs(MC6809 mC6809) {
        StringBuffer stringBuffer = new StringBuffer(80);
        Regs regs = mC6809.getRegisters();
        Utils.HEX(2, regs.A(), stringBuffer.append("A="));
        Utils.HEX(2, regs.B(), stringBuffer.append(" / B="));
        Utils.HEX(2, regs.DP(), stringBuffer.append(" / DP="));
        Utils.HEX(4, regs.X(), stringBuffer.append(" / X="));
        Utils.HEX(4, regs.Y(), stringBuffer.append(" / Y="));
        Utils.HEX(4, regs.U(), stringBuffer.append(" / U="));
        Utils.HEX(4, regs.S(), stringBuffer.append(" / S="));
        Utils.HEX(4, regs.PC(), stringBuffer.append(" / PC="));
        Utils.bin(8, regs.CC(), stringBuffer.append(" / CC="));
        Utils.getRegCCFlags(regs.CC(), stringBuffer.append(" (")).append(')');
        return stringBuffer.toString();
    }

    public static final String shortRegs(IDasmRegs iDasmRegs) {
        if (iDasmRegs instanceof Regs) {
            Regs regs = (Regs)iDasmRegs;
            StringBuffer stringBuffer = new StringBuffer(64);
            Utils.HEX(2, regs.CC(), stringBuffer.append("CC="));
            Utils.HEX(2, regs.A(), stringBuffer.append(" A="));
            Utils.HEX(2, regs.B(), stringBuffer.append(" B="));
            Utils.HEX(2, regs.DP(), stringBuffer.append(" DP="));
            Utils.HEX(4, regs.X(), stringBuffer.append(" X="));
            Utils.HEX(4, regs.Y(), stringBuffer.append(" Y="));
            Utils.HEX(4, regs.S(), stringBuffer.append(" S="));
            Utils.HEX(4, regs.U(), stringBuffer.append(" U="));
            Utils.HEX(2, 0, stringBuffer.append(" N="));
            Utils.HEX(4, regs.PC(), stringBuffer.append(" P="));
            return stringBuffer.toString();
        }
        return "CC=?? A=?? B=?? DP=?? X=???? Y=???? S=???? U=???? N=?? P=????";
    }

    public static final String stackContent(MC6809 mC6809, int n) {
        int n2 = mC6809.getRegisters().S();
        return Utils.dump(mC6809.getMemory(), n2, n);
    }

    public static final String dumpArray(int ... nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < nArray.length) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(nArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static final String dumpArray(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < fArray.length) {
            String string;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            if ((string = Float.toString(fArray[n])).endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            stringBuilder.append(string);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static final String dumpArray(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(object == null ? "null" : object.toString());
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static final byte[] toCString(String string) {
        int n = string.length();
        byte[] byArray = new byte[n + 1];
        while (--n >= 0) {
            byArray[n] = (byte)string.charAt(n);
        }
        return byArray;
    }

    public static final String fromCString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0 || byArray[0] == 0) {
            return "";
        }
        int n = 1;
        while (n < byArray.length) {
            if (byArray[n] == 0) {
                return new String(byArray, 0, n);
            }
            ++n;
        }
        return new String(byArray);
    }

    public static final void dumpStack(MC6809 mC6809, int n) {
        int n2 = mC6809.getRegisters().S();
        System.out.println("Stack (" + Utils.HEX(4, n2) + ") --> " + Utils.dump(mC6809.getMemory(), n2, n));
    }

    public static final void dumpPtr(MC6809 mC6809, Operand operand, int n) {
        int n2 = mC6809.getRegisters().getRegU(operand);
        System.out.println(String.valueOf(operand.toString()) + " [" + Utils.HEX(4, n2) + "] --> " + Utils.dump(mC6809.getMemory(), n2, n));
    }

    public static final void dumpPtr(MC6809 mC6809, int n, int n2) {
        System.out.println("[" + Utils.HEX(4, n) + "] --> " + Utils.dump(mC6809.getMemory(), n, n2));
    }

    public static final boolean isWindowsOS() {
        return WINDOWS;
    }

    public static final boolean isMacOSX() {
        return MAC_OS_X;
    }

    public static final boolean isLinuxOS() {
        return LINUX;
    }

    public static final boolean is15orLess() {
        return JVM_1_5;
    }

    public static final boolean is16orMore() {
        return JVM_1_6;
    }

    public static final Boolean is64bitsJVM() {
        return JVM_64;
    }

    public static Properties backup(Object object) throws Exception {
        Field[] fieldArray;
        Properties properties = new Properties();
        Field[] fieldArray2 = fieldArray = object.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            Field field = fieldArray2[n2];
            if (!Modifier.isTransient(field.getModifiers()) && (object2 = field.get(object)) != null) {
                properties.put(field.getName(), object2);
            }
            ++n2;
        }
        return properties;
    }

    public static void restore(Object object, Properties properties) throws Exception {
        Field[] fieldArray;
        Class<?> clazz = object.getClass();
        Field[] fieldArray2 = fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (!Modifier.isTransient(field.getModifiers())) {
                String string = properties.getProperty(field.getName());
                field.set(object, string);
            }
            ++n2;
        }
    }

    public static long readLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        while (n2-- > 0) {
            l = l << 8 | (long)(~byArray[n + n2]) & 0xFFL;
        }
        return l;
    }

    public static int readNext(InputStream inputStream) throws IOException {
        return ((inputStream.read() << 9) + inputStream.read() << 9) + inputStream.read() << 1;
    }

    public static long getCRC32(IStream iStream) {
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(iStream.read());
        }
        catch (Exception exception) {
            System.err.println("*** Error while computing CRC32 :");
            exception.printStackTrace(System.err);
            return -2L;
        }
        return cRC32.getValue();
    }

    public static long getCRC32(File file) {
        CRC32 cRC32 = new CRC32();
        InputStream inputStream = null;
        int n = (int)file.length();
        if (n == 0) {
            return -2L;
        }
        try {
            try {
                int n2 = Math.min(32768, n);
                byte[] byArray = new byte[n2];
                inputStream = new FileInputStream(file);
                while (n > 0) {
                    int n3 = inputStream.read(byArray, 0, n2);
                    if (n3 >= 0) {
                        cRC32.update(byArray, 0, n3);
                        n2 = Math.min(n -= n3, n2);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                return -3L;
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return cRC32.getValue();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSameContent(File file, File file2) {
        InputStream inputStream;
        FileInputStream fileInputStream;
        block26: {
            int n = (int)file.length();
            fileInputStream = null;
            inputStream = null;
            if (n <= 0) return false;
            if (file2.length() != (long)n) return false;
            int n2 = Math.min(32768, n);
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n2];
            fileInputStream = new FileInputStream(file);
            inputStream = new FileInputStream(file2);
            block21: while (n > 0) {
                int n3 = ((InputStream)fileInputStream).read(byArray, 0, n2);
                if (n3 >= 0 && n3 == inputStream.read(byArray2, 0, n2)) {
                    n -= n3;
                    do {
                        if (n3-- > 0) continue;
                        n2 = Math.min(n, n2);
                        continue block21;
                    } while (byArray[n3] == byArray2[n3]);
                }
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream == null) return false;
                try {
                    inputStream.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            if (fileInputStream == null) break block26;
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) return true;
        try {
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            block27: {
                try {
                    if (fileInputStream == null) break block27;
                }
                catch (Throwable throwable) {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException3) {}
                    throw throwable;
                }
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException4) {}
            }
            if (inputStream == null) return false;
            try {
                inputStream.close();
                return false;
            }
            catch (IOException iOException5) {}
            return false;
        }
    }

    public static void writeID(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
    }

    public static boolean readID(InputStream inputStream, String string, boolean bl) throws IOException {
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            int n2 = inputStream.read();
            if (n2 != Utils.clampByte(byArray[n])) {
                if (!bl && n2 < 0) {
                    throw new IOException("Unexpected end of file");
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void writeCString(OutputStream outputStream, String string) throws IOException {
        Utils.writeID(outputStream, string);
        outputStream.write(0);
    }

    public static String readCString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(32);
        while (true) {
            int n;
            if ((n = inputStream.read()) <= 0) {
                if (n == 0) {
                    return stringBuilder.toString();
                }
                throw new IOException("Unexpected end of file");
            }
            stringBuilder.append((char)n);
        }
    }
}

