/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util.swing;

import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileRequester {
    private final JFileChooser chooser = new JFileChooser();
    private Component defaultParent;
    private String candidateExtension;
    private FileFilter candidateFilter;

    public FileRequester() {
        this(null);
    }

    public FileRequester(Component component) {
        this.setDefaultParent(component);
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public void addFilter(FileFilter fileFilter) {
        this.chooser.addChoosableFileFilter(fileFilter);
    }

    public FileFilter addFileNameFilter(String string, String string2) {
        FileFilter fileFilter = this.createFileNameFilter(string, string2);
        this.addFilter(fileFilter);
        return fileFilter;
    }

    public FileFilter addFileExtensionFilter(String string, String string2) {
        FileFilter fileFilter = this.createFileExtensionFilter(string, string2);
        this.addFilter(fileFilter);
        return fileFilter;
    }

    public FileFilter addFileExtensionFilter(String string, String ... stringArray) {
        FileFilter fileFilter = this.createFileExtensionFilter(string, stringArray);
        this.addFilter(fileFilter);
        return fileFilter;
    }

    public void setDefaultParent(Component component) {
        this.defaultParent = component;
    }

    public void setInitialFolder(File file, boolean bl) {
        if (bl) {
            file.mkdirs();
        }
        this.chooser.setCurrentDirectory(FileRequester.getDeepestExistingFolder(file));
    }

    public void setInitialFile(File file, boolean bl) {
        if (file != null) {
            this.setInitialFolder(file.getParentFile(), bl);
        }
        this.chooser.setSelectedFile(file);
    }

    public void setInitialTarget(File file, boolean bl) {
        if (file.isDirectory()) {
            this.setInitialFolder(file, bl);
        } else {
            this.setInitialFile(file, bl);
        }
    }

    public File requestSaveAgain() {
        return this.requestSave(this.defaultParent, null, this.candidateExtension);
    }

    public File requestSave(String string) {
        return this.requestSave(this.defaultParent, string, null);
    }

    public File requestSave(String string, String string2) {
        return this.requestSave(this.defaultParent, string, string2);
    }

    public File requestSave(Component component, String string) {
        return this.requestSave(component, string, null);
    }

    public synchronized File requestSave(Component component, String string, String string2) {
        File file;
        block5: {
            int n;
            if (string != null) {
                this.chooser.setDialogTitle(string);
            }
            this.candidateExtension = string2;
            while (true) {
                String string3;
                n = this.chooser.showSaveDialog(component);
                this.chooser.setPreferredSize(this.chooser.getSize());
                file = this.chooser.getSelectedFile();
                if (n != 0 || file == null) {
                    return null;
                }
                file = this.adjustCandidateFileName(file);
                this.chooser.setSelectedFile(file);
                if (file.isDirectory()) {
                    string3 = "<html><b>The selected target is invalid because it is a folder :</b><br>" + file.getAbsolutePath() + "<br><br>Please select another file...";
                    n = JOptionPane.showConfirmDialog(component, string3, string, 2, 1);
                    if (n == 0) continue;
                    return null;
                }
                if (!file.isFile()) break block5;
                string3 = "<html><b>The selected file already exists :</b><br>" + file.getAbsolutePath() + "<br><br>OK to overwrite the existing file?";
                n = JOptionPane.showConfirmDialog(component, string3, string, 1);
                if (1 != n) break;
            }
            if (2 == n) {
                return null;
            }
        }
        return file;
    }

    public File requestOpenAgain() {
        return this.requestOpen(this.defaultParent, null, this.candidateFilter);
    }

    public File requestOpen(String string) {
        return this.requestOpen(this.defaultParent, string, null);
    }

    public File requestOpen(String string, FileFilter fileFilter) {
        return this.requestOpen(this.defaultParent, string, fileFilter);
    }

    public File requestOpen(Component component, String string) {
        return this.requestOpen(component, string, null);
    }

    public File requestOpen(Component component, String string, FileFilter fileFilter) {
        return this.requestOpenOrDelete(component, string, fileFilter, false);
    }

    public File requestDelete(String string) {
        return this.requestDelete(this.defaultParent, string, null);
    }

    public File requestDelete(String string, FileFilter fileFilter) {
        return this.requestDelete(this.defaultParent, string, fileFilter);
    }

    public File requestDelete(Component component, String string) {
        return this.requestDelete(component, string, null);
    }

    public File requestDelete(Component component, String string, FileFilter fileFilter) {
        return this.requestOpenOrDelete(component, string, fileFilter, true);
    }

    private synchronized File requestOpenOrDelete(Component component, String string, FileFilter fileFilter, boolean bl) {
        File file;
        block4: {
            if (string != null) {
                this.chooser.setDialogTitle(string);
            }
            this.candidateFilter = fileFilter;
            while (true) {
                String string2;
                int n = bl ? this.chooser.showDialog(component, "Delete") : this.chooser.showOpenDialog(component);
                this.chooser.setPreferredSize(this.chooser.getSize());
                file = this.chooser.getSelectedFile();
                if (n != 0 || file == null) {
                    return null;
                }
                if (!file.isFile()) {
                    string2 = "<html><b>The selected file does not exist :</b>&nbsp;<br>" + file.getAbsolutePath() + "&nbsp;<br><br>Please select another file...";
                    n = JOptionPane.showConfirmDialog(component, string2, string, 2, 1);
                    if (n == 0) continue;
                    return null;
                }
                if (fileFilter == null || fileFilter.accept(file)) break block4;
                string2 = this.getFilteredMessage(fileFilter, file);
                n = JOptionPane.showConfirmDialog(component, string2, string, 2, 1);
                if (n != 0) break;
            }
            return null;
        }
        return file;
    }

    protected File adjustCandidateFileName(File file) {
        String string;
        if (file != null && this.candidateExtension != null && (string = file.getName()).indexOf(46) < 0) {
            file = new File(file.getParentFile(), String.valueOf(string) + this.candidateExtension);
        }
        return file;
    }

    protected String getFilteredMessagePattern() {
        return "<html><b>The selected file is not a {0}.&nbsp;</b><br><br>Please select another file...";
    }

    protected String getFilteredMessage(FileFilter fileFilter, File file) {
        int n;
        String string = fileFilter.getDescription();
        if (string.endsWith(")") && (n = string.lastIndexOf(40)) > 0) {
            string = string.substring(0, n).trim();
        }
        if (string.endsWith("s")) {
            string = string.substring(0, string.length() - 1);
        }
        return MessageFormat.format(this.getFilteredMessagePattern(), string);
    }

    public static final File getDeepestExistingFolder(File file) {
        return file == null || file.isDirectory() ? file : FileRequester.getDeepestExistingFolder(file.getParentFile());
    }

    public final FileFilter createFileNameFilter(final String string, final String string2) {
        return new FileFilter(){

            public boolean accept(File file) {
                return !file.isFile() || file.getName().toLowerCase().equals(string2);
            }

            public String getDescription() {
                return string;
            }
        };
    }

    public final FileFilter createFileExtensionFilter(final String string, final String string2) {
        return new FileFilter(){

            public boolean accept(File file) {
                return !file.isFile() || file.getName().toLowerCase().endsWith(string2);
            }

            public String getDescription() {
                return string;
            }
        };
    }

    public final FileFilter createFileExtensionFilter(final String string, final String ... stringArray) {
        return new FileFilter(){

            public boolean accept(File file) {
                if (!file.isFile()) {
                    return true;
                }
                String string2 = file.getName().toLowerCase();
                int n = stringArray.length;
                while (n-- > 0) {
                    if (!string2.endsWith(stringArray[n])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return string;
            }
        };
    }
}

