/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex;

import frc.emul.api.Execution;
import frc.emul.api.IAddressBinder;
import frc.emul.api.IDevicesManager;
import frc.emul.api.ILogger;
import frc.emul.api.engine.IEngineBreakpoint;
import frc.emul.api.engine.IEngineBreakpointManager;
import frc.emul.api.persistence.IPersistenceAttachment;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.api.ui.IDisplay;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemGame;
import frc.emul.mc6809.MC6809;
import frc.emul.periph.Peripherals;
import frc.emul.psg.IVectrexAudio;
import frc.emul.psg.VectrexAudio;
import frc.emul.standalone.VectrexEmulator;
import frc.emul.util.FileAttachment;
import frc.emul.util.Utils;
import frc.emul.vectrex.BreakpointException;
import frc.emul.vectrex.PersistenceManager;
import frc.emul.vectrex.PersistentSection;
import frc.emul.vectrex.VectrexAddrBinder;
import frc.emul.vectrex.VectrexMemory;
import frc.emul.vectrex.debug.TraceRecorder;
import frc.emul.vectrex.debug.VectrexAddons;
import frc.emul.vectrex.debug.swing.UIBackTracer;
import frc.emul.vectrex.ui.opengl.Display;
import frc.emul.via6522.I6522ExternalListener;
import frc.emul.via6522.Via6522;
import frc.emul.via6522.Via6522Lines;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Vectrex
implements I6522ExternalListener {
    private static final boolean HANDLES_ILLEGAL_INSTRUCTIONS = true;
    private boolean HACK_VIA = true;
    public static final int CPU_FREQUENCY = 1600000;
    public static Vectrex INSTANCE;
    private IDisplay tempDisplayRemoveThisUgglyParam;
    private IEngineBreakpointManager bkptMgr;
    private IAddressBinder binder;
    private ILogger logger;
    private Via6522Lines lines;
    private VectrexMemory mem;
    private MC6809 cpu;
    private Via6522 via;
    private VectrexAudio audio;
    private Peripherals periph;
    private VectrexAddons addons;
    private PersistenceManager persist;
    private boolean init;
    private TraceRecorder tracer;
    private volatile boolean executeAllowed;
    private int remainingSteps;

    public Vectrex(Configuration configuration) {
        INSTANCE = this;
        this.binder = new VectrexAddrBinder();
        this.cpu = new MC6809(1.6f, true);
        this.mem = this.createMemory();
        this.lines = new Via6522Lines();
        this.logger = this.cpu.getLogger();
        this.via = new Via6522(this.logger, this.lines);
        this.audio = new VectrexAudio(configuration, this.logger, this.lines);
        this.periph = new Peripherals(configuration, this.logger, this.lines, this.via, this.audio, this.cpu);
        this.persist = new PersistenceManager(configuration);
        this.mem.setVIA6522(this.via);
        this.cpu.setMemory(this.mem, this.binder);
        this.lines.add6522Listener(this);
        this.addons = new VectrexAddons(this);
    }

    public void setDisplay(IDisplay iDisplay) {
        this.periph.setDisplay(iDisplay);
        if (this.addons != null) {
            this.addons.setDisplay(iDisplay);
        }
        this.tempDisplayRemoveThisUgglyParam = iDisplay;
    }

    protected VectrexMemory createMemory() {
        return new VectrexMemory();
    }

    public void internalPortWritten(int n, int n2, int n3) {
        if (this.mem.isCartridgeBankable() && 1 == n) {
            this.mem.handleChanged6522PortB(n2, this.cpu.getCycles());
        }
    }

    public void internalLineWritten(int n, boolean bl) {
        if (bl && n == 4) {
            this.cpu.getSimulator().setLineIRQ(true);
        }
    }

    public final VectrexMemory getMemory() {
        return this.mem;
    }

    public final MC6809 getCPU() {
        return this.cpu;
    }

    public final IAddressBinder getAddrBinder() {
        return this.binder;
    }

    public final Via6522 getVIA() {
        return this.via;
    }

    public final IVectrexAudio getAudio() {
        return this.audio;
    }

    public final IDevicesManager getPeripherals() {
        return this.periph;
    }

    public final boolean loadSystemROM(InputStream inputStream) throws IOException {
        return this.getMemory().loadROM(inputStream);
    }

    public final boolean loadCartridgeROM(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            return this.getMemory().loadCartridge(inputStream);
        }
        this.getMemory().removeCartridge();
        return true;
    }

    public final void defineCartridgeRAM(int n, int n2) {
        if (n2 > 0) {
            this.getMemory().installCartridgeRAM(n, n2);
        } else {
            this.getMemory().removeCartridgeRAM();
        }
    }

    public final void initialise() {
        if (!this.init) {
            ((Display)this.tempDisplayRemoveThisUgglyParam).getUI().initialiseListeners(this);
            this.init = true;
            this.executeAllowed = true;
            this.audio.initialise();
            this.cpu.initialise();
            this.via.initialise();
            this.periph.initialise();
            this.cpu.reset();
        }
    }

    public final void reset() {
        this.audio.reset();
        this.cpu.reset();
        this.mem.resetBankSwitching();
        this.via.reset();
        this.periph.reset();
    }

    public final void switchGame(CfgItemGame cfgItemGame) {
    }

    public final void terminate() {
        this.executeAllowed = false;
        this.audio.shutdown();
    }

    public final void suspend() {
        this.executeAllowed = false;
    }

    public final boolean resume() throws BreakpointException {
        this.executeAllowed = true;
        this.remainingSteps = 0;
        return this.exec();
    }

    public final boolean step(int n) throws BreakpointException {
        this.executeAllowed = true;
        this.remainingSteps = n;
        return this.exec();
    }

    public Exception getLastError() {
        return this.cpu.getLastError();
    }

    public final boolean exec() throws BreakpointException {
        try {
            return this.execImpl();
        }
        catch (BreakpointException breakpointException) {
            throw breakpointException;
        }
        catch (Throwable throwable) {
            if (this.tracer != null) {
                this.trace(Execution.FATAL_ERR);
            }
            throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException("Core Emulation Error", throwable);
        }
    }

    public final boolean execImpl() throws BreakpointException {
        while (this.executeAllowed) {
            int n;
            long l = this.cpu.getCycles();
            Execution execution = this.cpu.step();
            if (!this.HACK_VIA) {
                this.via.stepped();
            }
            if (execution == Execution.ILLEGAL) {
                if (this.handleIllegalInstruction()) continue;
                return false;
            }
            if (this.tracer != null) {
                this.trace(execution);
            }
            int n2 = n = (int)(this.cpu.getCycles() - l);
            while (--n2 >= 0) {
                this.via.step();
                if (!this.HACK_VIA) {
                    this.periph.stepped();
                }
                this.periph.step();
            }
            if (this.HACK_VIA) {
                this.via.stepped();
                this.periph.stepped();
            }
            if (!this.periph.tick(n)) {
                return true;
            }
            if (execution == Execution.FATAL_ERR) {
                return false;
            }
            if (this.bkptMgr != null && !this.bkptMgr.isEmpty()) {
                this.handleBreakpoints();
            }
            if (this.remainingSteps > 0 && --this.remainingSteps == 0) break;
        }
        return true;
    }

    public PersistenceManager getPersistenceManager() {
        return this.persist;
    }

    void storePersistentState(IPersistenceWriter iPersistenceWriter, boolean bl) throws PersistenceException {
        iPersistenceWriter.write(this.cpu);
        iPersistenceWriter.write(this.via);
        iPersistenceWriter.write(this.lines);
        iPersistenceWriter.write(this.audio);
        iPersistenceWriter.write(this.periph);
        this.mem.store(iPersistenceWriter, false, bl);
    }

    void loadPersistentState(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.read(this.cpu);
        iPersistenceReader.read(this.via);
        iPersistenceReader.read(this.lines);
        iPersistenceReader.read(this.audio);
        iPersistenceReader.read(this.periph);
        this.mem.load(iPersistenceReader);
    }

    public File dumpState(String string, boolean bl, boolean bl2, boolean bl3) throws PersistenceException {
        PersistenceManager persistenceManager = this.getPersistenceManager();
        File file = persistenceManager.getDumpFile(string);
        ArrayList<IPersistenceAttachment> arrayList = null;
        if (bl2 || bl3) {
            arrayList = new ArrayList<IPersistenceAttachment>(2);
            if (bl3) {
                arrayList.add(new FileAttachment((IPersistentSection)PersistentSection.ATT_CONF_FILE, VectrexEmulator.getConfigFilename()));
            }
            if (bl2) {
                arrayList.add(new FileAttachment((IPersistentSection)PersistentSection.ATT_LOG_FILE, "data/temp/ParaJVE.log"));
            }
        }
        persistenceManager.store(file, PersistenceManager.SaveType.DUMP, bl, arrayList);
        return file;
    }

    public boolean isRecordingTrace() {
        return this.tracer != null;
    }

    public void setRecordingTrace(boolean bl) {
        if (this.isRecordingTrace() != bl) {
            this.tracer = bl ? new TraceRecorder() : null;
        }
    }

    private void trace(Execution execution) {
        try {
            if (execution == Execution.FATAL_ERR || execution == Execution.ILLEGAL) {
                boolean bl = execution == Execution.FATAL_ERR || execution == Execution.ILLEGAL;
                UIBackTracer uIBackTracer = new UIBackTracer();
                uIBackTracer.loadTraces(this.tracer);
                uIBackTracer.openFrame(bl);
            } else {
                this.tracer.addTrace(this.cpu);
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setBreakpointManager(IEngineBreakpointManager iEngineBreakpointManager) {
        this.bkptMgr = iEngineBreakpointManager;
    }

    protected IEngineBreakpointManager getBreakpointManager() {
        return this.bkptMgr;
    }

    private void handleBreakpoints() throws BreakpointException {
        IEngineBreakpoint iEngineBreakpoint = this.bkptMgr.checkForHit();
        if (iEngineBreakpoint != null) {
            throw new BreakpointException(iEngineBreakpoint, this.cpu.getLastPC());
        }
    }

    private boolean handleIllegalInstruction() {
        boolean bl;
        boolean bl2 = bl = this.addons == null ? false : this.addons.handleIllegalInstruction();
        if (bl) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer("*** ILLEGAL instruction at ");
        int n = this.cpu.getCurrentPC();
        Utils.hex(4, n, stringBuffer).append(" : [");
        int n2 = 0;
        while (n2 < 8) {
            Utils.hex(2, this.mem.readU8(n + n2), stringBuffer.append(' '));
            ++n2;
        }
        System.out.println(stringBuffer.append(" ]").toString());
        if (this.tracer != null) {
            this.trace(Execution.ILLEGAL);
        }
        return false;
    }
}

