/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex;

import frc.emul.api.IMemory;
import frc.emul.api.MemoryType;
import frc.emul.util.Utils;
import frc.emul.via6522.Via6522;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Via6522Mapping
implements IMemory {
    private final int base;
    private final int size;
    private Via6522 via;

    public Via6522Mapping(int n, int n2) {
        this.base = n;
        this.size = n2;
    }

    public void setVIA6522(Via6522 via6522) {
        this.via = via6522;
    }

    private final byte[] getBank() {
        byte[] byArray = new byte[16];
        int n = 16;
        while (n-- > 0) {
            byArray[n] = (byte)this.get(n);
        }
        return byArray;
    }

    private int get(int n) {
        try {
            switch (n - this.base & 0xF) {
                case 0: {
                    return this.via.getViaPortB();
                }
                case 1: {
                    return this.via.getViaPortA();
                }
                case 2: {
                    return this.via.getViaDDRB();
                }
                case 3: {
                    return this.via.getViaDDRA();
                }
                case 4: {
                    return this.via.getViaT1CL();
                }
                case 5: {
                    return this.via.getViaT1CH();
                }
                case 6: {
                    return this.via.getViaT1LL();
                }
                case 7: {
                    return this.via.getViaT1LH();
                }
                case 8: {
                    return this.via.getViaT2CL();
                }
                case 9: {
                    return this.via.getViaT2CH();
                }
                case 10: {
                    return this.via.getViaSR();
                }
                case 11: {
                    return this.via.getViaACR();
                }
                case 12: {
                    return this.via.getViaPCR();
                }
                case 13: {
                    return this.via.getViaIFR();
                }
                case 14: {
                    return this.via.getViaIER();
                }
                case 15: {
                    return this.via.getViaAnoHS();
                }
            }
            throw new RuntimeException("Dead Code");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while reading VIA address $" + Utils.hex(4, n), exception);
        }
    }

    private void set(int n, int n2) {
        n2 &= 0xFF;
        try {
            this.via.setVia(n - this.base & 0xF, n2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while writing $" + Utils.hex(2, n2) + " at VIA address $" + Utils.hex(4, n), exception);
        }
    }

    public MemoryType getType() {
        return MemoryType.VIA6522;
    }

    public int readS8(int n) {
        return (byte)this.get(n);
    }

    public int readU8(int n) {
        return this.get(n);
    }

    public void write8(int n, int n2) {
        this.set(n, n2);
    }

    public int readS16(int n) {
        return this.readS8(n) << 8 | this.get(n + 1);
    }

    public int readU16(int n) {
        return this.get(n) << 8 | this.get(n + 1);
    }

    public void write16(int n, int n2) {
        this.set(n, n2 >> 8);
        this.set(n + 1, n2);
    }

    public int getSize() {
        return this.size;
    }

    public int getLoadedSize() {
        return 16;
    }

    public int getFirstAddress() {
        return this.base;
    }

    public int getLastAddress() {
        return this.base + this.size - 1;
    }

    public void fill(byte by) {
        throw new UnsupportedOperationException();
    }

    public boolean isValidArea(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean canRead(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean canWrite(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean canExecute(int n, int n2) {
        return false;
    }

    public boolean dump(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBank();
        int n = this.size / 16;
        while (n-- > 0) {
            outputStream.write(byArray);
        }
        return true;
    }

    public boolean save(OutputStream outputStream, boolean bl) throws IOException {
        outputStream.write(this.getBank());
        return true;
    }

    public boolean load(InputStream inputStream, boolean bl) throws IOException {
        int n = 16;
        while (n-- > 0) {
            this.set(n, inputStream.read());
        }
        return true;
    }

    public boolean feed(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }
}

