/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug.swing;

import frc.emul.util.Utils;
import frc.emul.vectrex.debug.UITraceEntries;
import frc.emul.vectrex.debug.UITraceEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class BackTraceTableRenderer
extends DefaultTableCellRenderer {
    private UITraceEntries entries;
    private Object val;
    private int row;
    private int col;
    private static final Color COLOR_CHANGED = new Color(255, 255, 64);
    private static final Color COLOR_BANK = new Color(224, 224, 224);
    private static final Color COLOR_CODE = new Color(248, 248, 248);
    private static final Color COLOR_REGS = new Color(232, 255, 232);
    private static final Color COLOR_REG_PC = new Color(224, 240, 208);
    private static final Color COLOR_REG_PC_ROM = new Color(248, 232, 232);
    private static final Color COLOR_STACK = new Color(232, 232, 255);

    public BackTraceTableRenderer(UITraceEntries uITraceEntries) {
        this.entries = uITraceEntries;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = Color.WHITE;
        int n3 = jTable.convertColumnIndexToModel(n2);
        this.row = n;
        this.col = n3;
        this.val = object;
        switch (n3) {
            case 1: 
            case 2: 
            case 3: {
                super.setHorizontalAlignment(10);
                color = COLOR_CODE;
                object = " " + object;
                break;
            }
            case 0: {
                super.setHorizontalAlignment(0);
                if (this.entries.getUIEntry(n).hasBankContentChanged()) {
                    color = COLOR_CHANGED;
                    break;
                }
                color = COLOR_BANK;
                break;
            }
            case 13: {
                super.setHorizontalAlignment(10);
                UITraceEntry uITraceEntry = this.entries.getUIEntry(n);
                color = uITraceEntry.hasStackContentChanged() ? COLOR_CHANGED : COLOR_STACK;
                object = " " + object;
                break;
            }
            default: {
                super.setHorizontalAlignment(0);
                UITraceEntry uITraceEntry = this.entries.getUIEntry(n);
                if (uITraceEntry.getRegisterChanges()[n3 - 4]) {
                    color = COLOR_CHANGED;
                    break;
                }
                if (n3 == 4) {
                    if (uITraceEntry.getEntry().getRegs().PC() < 57344) {
                        color = COLOR_REG_PC;
                        break;
                    }
                    color = COLOR_REG_PC_ROM;
                    break;
                }
                color = COLOR_REGS;
            }
        }
        this.setBackground(color);
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public final String getToolTipText() {
        String string = (String)this.val;
        if (this.col == 10) {
            UITraceEntry uITraceEntry = this.entries.getUIEntry(this.row);
            string = "$<b>" + Utils.HEX(2, uITraceEntry.getEntry().getRegs().CC()) + "</b>  [" + string + "]";
        } else if (this.col == 2) {
            UITraceEntry uITraceEntry = this.entries.getUIEntry(this.row);
            StringBuffer stringBuffer = new StringBuffer(70);
            String string2 = uITraceEntry.getCodeComments();
            Utils.HEX(4, uITraceEntry.getEntry().getRegs().PC(), stringBuffer.append("<font color=\"#704040\">$"));
            stringBuffer.append(":</font>&nbsp;&nbsp;<b>");
            Utils.encodeHTML(string, stringBuffer);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append("</b>&nbsp;&nbsp;<font color=\"GREEN\">;&nbsp;");
                Utils.encodeHTML(string2, stringBuffer);
                stringBuffer.append("</font>");
            }
            string = stringBuffer.toString();
        }
        return "<html><code>&nbsp;" + string + "&nbsp;</code><!--" + this.row + ":" + this.col + "--></html>";
    }

    public void paintComponent(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintComponent(graphics);
    }
}

