/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing.menu;

import frc.emul.api.IDevice;
import frc.emul.api.IDeviceEvent;
import frc.emul.api.IDevicesListener;
import frc.emul.api.IDevicesManager;
import frc.emul.periph.Peripherals;
import frc.emul.util.AttributesMap;
import frc.emul.util.Utils;
import frc.emul.util.swing.AARadioButtonMenuItem;
import frc.emul.vectrex.Vectrex;
import frc.emul.vectrex.swing.menu.AbstractGamePortEntry;
import frc.emul.vectrex.swing.menu.IGamePortEntry;
import frc.emul.vectrex.swing.menu.UIMenu;
import frc.input.JInputController;
import frc.input.JInputManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class UIGamePortMenu
implements IDevicesListener {
    private static final String[] DEVICE_IDS = new String[]{"CONTROLLER", "JOYSTICK", "LIGHTPEN", "VECVOICE", "KEYBOARD", "NULL"};
    private static final String[] DEVICE_NAMES = new String[]{"Controller", "Joystick", "LightPen", "VecVoice", "Keyboard", "Empty"};
    private final UIMenu owner;
    private final int portID;
    private final List<IGamePortEntry> entries = new ArrayList<IGamePortEntry>();
    private JMenu gamePortMenu;
    private JMenuItem miConfMenu;
    private JSeparator miConfSep;

    UIGamePortMenu(UIMenu uIMenu, int n) {
        this.portID = n;
        this.owner = uIMenu;
    }

    JMenu getMenu() {
        if (this.gamePortMenu == null) {
            this.gamePortMenu = new JMenu("Game Port #" + (this.portID + 1));
            this.populateMainMenu(this.gamePortMenu);
        }
        return this.gamePortMenu;
    }

    void initialiseContent(Vectrex vectrex) {
        IDevicesManager iDevicesManager = vectrex.getPeripherals();
        iDevicesManager.removeDevicesListener(this);
        iDevicesManager.addDevicesListener(this);
    }

    public void deviceAction(IDeviceEvent iDeviceEvent) {
        IGamePortEntry iGamePortEntry;
        String string;
        if (iDeviceEvent.getPortID() == this.portID) {
            if (iDeviceEvent.getCause().equals((Object)IDeviceEvent.Cause.ACTION_PLUG)) {
                this.initialiseSelection(iDeviceEvent.getDevice());
            }
        } else if (iDeviceEvent.getCause().isAction() && Peripherals.areExclusivePeripherals(string = iDeviceEvent.getDevice().getID(), string) && (iGamePortEntry = this.getEntry(iDeviceEvent.getDevice())) != null) {
            switch (iDeviceEvent.getCause()) {
                case ACTION_PLUG: {
                    iGamePortEntry.setEnabled(false);
                    break;
                }
                case ACTION_UNPLUG: {
                    iGamePortEntry.setEnabled(true);
                }
            }
        }
    }

    public void deviceError(IDeviceEvent iDeviceEvent) {
        int n;
        String string;
        String string2;
        if (iDeviceEvent.getPortID() != this.portID) {
            return;
        }
        switch (iDeviceEvent.getCause()) {
            case ERROR_CONTROLLER_NOT_CONNECTED: {
                string2 = "ParaJVE - Controller not connected!";
                string = "<html><b>" + iDeviceEvent.getMessage() + "</b><br>The default mapping will be used instead...";
                n = 1;
                break;
            }
            case ERROR_CONTROLLER_POLL_FAILURE: {
                System.out.println("*** DEVICE ERROR " + iDeviceEvent);
                string2 = "ParaJVE - Controller Error";
                string = "<html><b>" + iDeviceEvent.getMessage() + "</b><br>This device mapping will remain inactive until you restart ParaJVE...";
                n = 0;
                break;
            }
            default: {
                throw new IllegalStateException(iDeviceEvent.getCause().toString());
            }
        }
        JOptionPane.showMessageDialog(this.owner.getEmulUI().getWindow(), string, string2, n);
    }

    private IGamePortEntry getEntry(IDevice iDevice) {
        if (iDevice != null) {
            int n = this.entries.size();
            while (n-- > 0) {
                if (!this.entries.get(n).matches(iDevice)) continue;
                return this.entries.get(n);
            }
        }
        return null;
    }

    private void initialiseSelection(IDevice iDevice) {
        IGamePortEntry iGamePortEntry = this.getEntry(iDevice);
        if (iGamePortEntry != null) {
            iGamePortEntry.select();
        } else {
            System.out.println("*** Warning : no controller menu item found for [" + iDevice + "]");
        }
    }

    private final void bindConfigureMenuItem(Action action) {
        boolean bl = action != null;
        this.miConfMenu.setAction(action);
        this.miConfMenu.setVisible(bl);
        this.miConfSep.setVisible(bl);
    }

    private final void populateMainMenu(JMenu jMenu) {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.miConfMenu = new JMenuItem();
        this.miConfSep = new JPopupMenu.Separator();
        jMenu.add(this.miConfMenu);
        jMenu.add(this.miConfSep);
        int n = 0;
        while (n < DEVICE_NAMES.length) {
            final String string = DEVICE_IDS[n];
            if ((string == null && this.portID != 0 || Peripherals.isValidPeripheralID(this.portID, string)) && string != null) {
                JMenuItem jMenuItem;
                if ("CONTROLLER".equals(string)) {
                    jMenuItem = new JMenu(DEVICE_NAMES[n]);
                    this.populateControllersMenu((JMenu)jMenuItem, buttonGroup);
                } else {
                    jMenuItem = Utils.is15orLess() ? new JCheckBoxMenuItem(DEVICE_NAMES[n]) : new AARadioButtonMenuItem(DEVICE_NAMES[n]);
                    buttonGroup.add(jMenuItem);
                    this.entries.add(new GamePortEntry(string, jMenuItem, null));
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            UIGamePortMenu.this.owner.getEmulUI().getPeripherals().setPort(UIGamePortMenu.this.portID, string, null);
                        }
                    });
                }
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        this.bindConfigureMenuItem(null);
    }

    private final void populateControllersMenu(JMenu jMenu, ButtonGroup buttonGroup) {
        List<JInputController> list = JInputManager.getDefaultManager().getControllers();
        if (list.isEmpty()) {
            JMenuItem jMenuItem = new JMenuItem("No controller available...");
            jMenuItem.setEnabled(false);
            jMenuItem.setBorder(new EmptyBorder(8, 0, 7, 0));
            jMenu.add(jMenuItem);
        } else {
            int n = 0;
            while (n < list.size()) {
                final JInputController jInputController = list.get(n);
                JMenuItem jMenuItem = Utils.is15orLess() ? new JCheckBoxMenuItem(jInputController.getName()) : new AARadioButtonMenuItem(jInputController.getName());
                AbstractAction abstractAction = new AbstractAction("Setup Controller..."){

                    public void actionPerformed(ActionEvent actionEvent) {
                        UIGamePortMenu.this.owner.getEmulUI().editControllerSettings(jInputController);
                    }
                };
                GamePortEntry gamePortEntry = new GamePortEntry(jInputController.getID(), jMenuItem, (Action)abstractAction){

                    public boolean matches(IDevice iDevice) {
                        AttributesMap attributesMap = iDevice.getAttributes();
                        return attributesMap != null && "CONTROLLER".equals(iDevice.getID()) && jInputController.getID().equals(attributesMap.get("controller"));
                    }
                };
                jMenu.add(jMenuItem);
                buttonGroup.add(jMenuItem);
                this.entries.add(gamePortEntry);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        IDevicesManager iDevicesManager = UIGamePortMenu.this.owner.getEmulUI().getPeripherals();
                        AttributesMap attributesMap = new AttributesMap();
                        attributesMap.put("controller", jInputController.getID());
                        if (iDevicesManager.comparePort(UIGamePortMenu.this.portID, "CONTROLLER", attributesMap)) {
                            return;
                        }
                        if (UIGamePortMenu.this.owner.getEmulUI().editControllerSettings(jInputController) == null) {
                            UIGamePortMenu.this.initialiseSelection(iDevicesManager.getPort(UIGamePortMenu.this.portID));
                            return;
                        }
                        iDevicesManager.setPort(UIGamePortMenu.this.portID, "CONTROLLER", attributesMap);
                    }
                });
                ++n;
            }
        }
    }

    private class GamePortEntry
    extends AbstractGamePortEntry {
        private GamePortEntry(String string, JMenuItem jMenuItem, Action action) {
            super(string, jMenuItem, action);
        }

        protected void hookConfigurationAction(Action action) {
            UIGamePortMenu.this.bindConfigureMenuItem(action);
        }

        /* synthetic */ GamePortEntry(String string, JMenuItem jMenuItem, Action action, GamePortEntry gamePortEntry, GamePortEntry gamePortEntry2) {
            this(string, jMenuItem, action);
        }
    }
}

