/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class Browser {
    private static String[] exec;
    private static boolean init;

    public static void displayURL(final String string, boolean bl) {
        if (bl) {
            new Thread(){

                public void run() {
                    Browser.displaySafeURL(string);
                }
            }.start();
        } else {
            Browser.displaySafeURL(string);
        }
    }

    public static void displaySafeURL(String string) {
        try {
            Browser.displayURL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void displayURL(String string) throws IOException {
        if (!init) {
            init = true;
            exec = Browser.defaultCommands();
        }
        if (exec == null || exec.length == 0) {
            Class<?> clazz;
            Object object;
            if (!System.getProperty("os.name").startsWith("Mac")) throw new IOException("Browser execute command not defined");
            boolean bl = false;
            try {
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    object = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                    clazz = Class.forName("com.apple.cocoa.application.NSWorkspace", true, (ClassLoader)object);
                } else {
                    clazz = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                object = clazz.getMethod("sharedWorkspace", new Class[0]);
                Object object2 = ((Method)object).invoke(null, new Object[0]);
                Method method = clazz.getMethod("openURL", Class.forName("java.net.URL"));
                bl = (Boolean)method.invoke(object2, new URL(string));
            }
            catch (Exception exception) {}
            if (bl) return;
            try {
                clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                object = clazz.getMethod("openURL", Class.forName("java.lang.String"));
                ((Method)object).invoke(null, string);
                return;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                throw new IOException("Browser launch failed");
            }
        }
        Object[] objectArray = new String[]{Browser.encodeURL(string)};
        String string2 = null;
        boolean bl = false;
        try {
            int n = 0;
            while (n < exec.length && !bl) {
                try {
                    Object object;
                    string2 = MessageFormat.format(exec[n], objectArray);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                    boolean bl2 = false;
                    if (stringArray[0].equals("rundll32") && stringArray[1].equals("url.dll,FileProtocolHandler")) {
                        object = stringArray[2];
                        if (((String)object).startsWith("file:/")) {
                            if (((String)object).charAt(6) != '/') {
                                object = "file://" + ((String)object).substring(6);
                            }
                            if (((String)object).charAt(7) != '/') {
                                object = "file:///" + ((String)object).substring(7);
                            }
                            bl2 = true;
                        } else if (((String)object).toLowerCase().endsWith("html") || ((String)object).toLowerCase().endsWith("htm")) {
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        object = File.createTempFile("OpenInBrowser", ".url");
                        object = ((File)object).getCanonicalFile();
                        ((File)object).deleteOnExit();
                        PrintWriter printWriter = new PrintWriter(new FileWriter((File)object));
                        printWriter.println("[InternetShortcut]");
                        printWriter.println("URL=" + stringArray[2]);
                        printWriter.close();
                        stringArray[2] = ((File)object).getCanonicalPath();
                    }
                    object = Runtime.getRuntime().exec(stringArray);
                    int n2 = 0;
                    while (n2 < 2) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++n2;
                    }
                    if (((Process)object).exitValue() == 0) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Warning: " + iOException.getMessage());
                }
                ++n;
            }
            if (bl) return;
            throw new IOException("Browser launch failed");
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
    }

    public static URL getEncodedURL(String string) throws MalformedURLException {
        return new URL(Browser.encodeURL(string));
    }

    public static String encodeURL(String string) throws MalformedURLException {
        new URL(string);
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == ':' || c == '&' || c == '@' || c == '/' || c == '?' || c == '%' || c == '+' || c == '=' || c == '#' || c == '-' || c == '\\') {
                stringBuffer.append(c);
            } else if ((c = (char)(c & 0xFF)) < '\u0010') {
                stringBuffer.append("%0").append(Integer.toHexString(c));
            } else {
                stringBuffer.append('%').append(Integer.toHexString(c));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String[] defaultCommands() {
        String string = System.getProperty("os.name").toLowerCase();
        String[] stringArray = null;
        if (string.indexOf("windows") >= 0) {
            stringArray = new String[]{"rundll32 url.dll,FileProtocolHandler {0}"};
        } else if (string.startsWith("mac")) {
            Vector<String> vector = new Vector<String>();
            try {
                Process process = Runtime.getRuntime().exec("which open");
                if (process.waitFor() == 0) {
                    vector.add("open {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            if (vector.size() != 0) {
                stringArray = vector.toArray(new String[vector.size()]);
            }
        } else if (string.startsWith("sunos")) {
            stringArray = new String[]{"/usr/dt/bin/sdtwebclient {0}"};
        } else {
            Process process;
            Vector<String> vector = new Vector<String>();
            try {
                process = Runtime.getRuntime().exec("which firebird");
                if (process.waitFor() == 0) {
                    vector.add("firebird -remote openURL({0})");
                    vector.add("firebird {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which mozilla");
                if (process.waitFor() == 0) {
                    vector.add("mozilla -remote openURL({0})");
                    vector.add("mozilla {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which opera");
                if (process.waitFor() == 0) {
                    vector.add("opera -remote openURL({0})");
                    vector.add("opera {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which galeon");
                if (process.waitFor() == 0) {
                    vector.add("galeon {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which konqueror");
                if (process.waitFor() == 0) {
                    vector.add("konqueror {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which netscape");
                if (process.waitFor() == 0) {
                    vector.add("netscape -remote openURL({0})");
                    vector.add("netscape {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which xterm");
                if (process.waitFor() == 0 && (process = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    vector.add("xterm -e lynx {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            if (vector.size() != 0) {
                stringArray = vector.toArray(new String[vector.size()]);
            }
        }
        return stringArray;
    }
}

