/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui;

import frc.emul.config.data.CfgItemTiming;
import java.security.InvalidParameterException;

public class Timing {
    private int method = 0;
    private boolean useNano;
    private int fps;
    private long nsDelay;
    public static final int DEFAULT_FPS = 50;
    public static final int FIXED_FPS = 0;
    public static final int FIXED_DELAY = 1;
    public static final int NO_TIMING = 2;

    public Timing() {
        this.setFPS(50, true);
    }

    public Timing(CfgItemTiming cfgItemTiming) {
        this();
        this.load(cfgItemTiming);
    }

    public void store(CfgItemTiming cfgItemTiming) {
        cfgItemTiming.method = this.method;
        cfgItemTiming.useNano = this.useNano;
        cfgItemTiming.fps = this.fps;
        cfgItemTiming.nsDelay = this.nsDelay;
    }

    public void load(CfgItemTiming cfgItemTiming) {
        switch (cfgItemTiming.method) {
            case 0: {
                this.setFPS(cfgItemTiming.fps, cfgItemTiming.useNano);
                break;
            }
            case 1: {
                this.setNanosDelay(cfgItemTiming.nsDelay);
                break;
            }
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        this.method = cfgItemTiming.method;
    }

    public void setMethod(int n) {
        this.method = n;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown timing method : " + n);
            }
        }
    }

    public int getMethod() {
        return this.method;
    }

    public void setFPS(int n, boolean bl) {
        this.useNano = true;
        this.fps = Math.max(1, n);
        this.nsDelay = 1000000000L / (long)this.fps;
        this.useNano = bl;
    }

    public int getFPS() {
        return this.fps;
    }

    public void setNanosDelay(long l) {
        this.nsDelay = l;
    }

    public void setMillisDelay(long l) {
        this.nsDelay = 1000000L * l;
    }

    public long getNanosDelay(float f) {
        return (long)(f * (float)this.nsDelay);
    }

    public long getMillisDelay(float f) {
        return (long)(f * (float)this.nsDelay / 1000000.0f);
    }

    public boolean isNanoResolution() {
        return this.useNano;
    }
}

