/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.api.ui.IDisplayContext;
import frc.emul.config.data.CfgItemChassis;
import frc.emul.vectrex.swing.UI;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class UIChassisSettings {
    private static final boolean SHOW_FULL_VIEWPORT_OPTION = false;
    private static final float SCALE = 10000.0f;
    private static JDialog dialog;
    private PropertyChangeListener propsListeners;
    private boolean changed;
    private JSlider chassisZoom;
    private UI emulUI;

    public void configChanged() {
    }

    public final void openSettingsEditor(Window window, final UI uI) {
        if (dialog != null) {
            dialog.requestFocus();
            return;
        }
        JDialog jDialog = UIUtils.createDialog(window, "ParaJVE - Chassis Settings", false);
        IDisplayContext iDisplayContext = uI.getDisplayContext();
        final CfgItemChassis cfgItemChassis = iDisplayContext.getChassisSettings().clone();
        final boolean bl = iDisplayContext.isFullViewport();
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        JButton jButton = new JButton("OK");
        final JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jButton2);
        this.emulUI = uI;
        this.changed = false;
        ChangeListener changeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent changeEvent) {
                UIChassisSettings.this.changed = true;
                uI.updateRendering();
            }
        };
        JComponent jComponent = this.buildControlsPane(changeListener);
        JPanel jPanel2 = (JPanel)jDialog.getContentPane();
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.add((Component)jComponent, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(Borders.EMPTY_10);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIChassisSettings.this.changed) {
                    UIChassisSettings.this.configChanged();
                }
                UIChassisSettings.this.dismiss();
            }
        });
        UIUtils.registerEscapeButton(jButton2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIChassisSettings.this.changed) {
                    UIChassisSettings.this.restoreSettings(cfgItemChassis, bl);
                }
                UIChassisSettings.this.dismiss();
            }
        });
        this.propsListeners = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("CHASSIS_ZOOM".equals(propertyChangeEvent.getPropertyName())) {
                    UIChassisSettings.this.chassisZoomChanged();
                }
            }
        };
        iDisplayContext.addPropertyChangeListener(this.propsListeners);
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jButton2.doClick(0);
            }
        });
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(true);
        dialog = jDialog;
        jDialog.setVisible(true);
    }

    private final JComponent buildControlsPane(final ChangeListener changeListener) {
        final CfgItemChassis cfgItemChassis = this.emulUI.getDisplayContext().getChassisSettings();
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 10));
        final JCheckBox jCheckBox = this.createCheckBox("Chassis Frame", cfgItemChassis.enableFrame);
        final JCheckBox jCheckBox2 = this.createCheckBox("Chassis Screen", cfgItemChassis.enableScreen);
        final JCheckBox jCheckBox3 = this.createCheckBox("Overlay Holders", cfgItemChassis.enableHolders);
        final JCheckBox jCheckBox4 = this.createCheckBox("Game Cartridge", cfgItemChassis.enableCartridge);
        final JCheckBox jCheckBox5 = this.createCheckBox("Plug for port #1", cfgItemChassis.enablePort1);
        final JCheckBox jCheckBox6 = this.createCheckBox("Plug for port #2", cfgItemChassis.enablePort2);
        final JCheckBox jCheckBox7 = this.createCheckBox("Ports bay Panel", cfgItemChassis.enablePanel);
        jPanel.add(jCheckBox2);
        jPanel2.add(jCheckBox3);
        jPanel.add(jCheckBox);
        jPanel2.add(Box.createGlue());
        jPanel.add(jCheckBox4);
        jPanel2.add(jCheckBox5);
        jPanel.add(jCheckBox7);
        jPanel2.add(jCheckBox6);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 2, 20, 0));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(" Drawn Parts "), new EmptyBorder(5, 10, 10, 10)));
        final ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = cfgItemChassis.enableFrame;
                if (bl) {
                    cfgItemChassis.enablePanel = jCheckBox7.isSelected();
                    cfgItemChassis.enablePort1 = jCheckBox5.isSelected();
                    cfgItemChassis.enablePort2 = jCheckBox6.isSelected();
                    cfgItemChassis.enableCartridge = jCheckBox4.isSelected();
                } else {
                    cfgItemChassis.enablePanel = false;
                    cfgItemChassis.enablePort1 = false;
                    cfgItemChassis.enablePort2 = false;
                    cfgItemChassis.enableCartridge = false;
                }
                jCheckBox5.setEnabled(bl && !jCheckBox7.isSelected());
                jCheckBox6.setEnabled(bl && !jCheckBox7.isSelected());
                jCheckBox7.setEnabled(bl && !jCheckBox5.isSelected() && !jCheckBox6.isSelected());
                jCheckBox4.setEnabled(bl);
                changeListener.stateChanged(null);
            }
        };
        actionListener.actionPerformed(null);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cfgItemChassis.enableFrame = jCheckBox.isSelected();
                actionListener.actionPerformed(actionEvent);
            }
        });
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cfgItemChassis.enableScreen = jCheckBox2.isSelected();
                actionListener.actionPerformed(actionEvent);
            }
        });
        jCheckBox5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cfgItemChassis.enablePort1 = jCheckBox5.isSelected();
                actionListener.actionPerformed(actionEvent);
            }
        });
        jCheckBox6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cfgItemChassis.enablePort2 = jCheckBox6.isSelected();
                actionListener.actionPerformed(actionEvent);
            }
        });
        jCheckBox7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cfgItemChassis.enablePanel = jCheckBox7.isSelected();
                actionListener.actionPerformed(actionEvent);
            }
        });
        jCheckBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cfgItemChassis.enableCartridge = jCheckBox4.isSelected();
                changeListener.stateChanged(null);
            }
        });
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cfgItemChassis.enableHolders = jCheckBox3.isSelected();
                changeListener.stateChanged(null);
            }
        });
        final JSlider jSlider = new JSlider(6000, 21000);
        JLabel jLabel = new JLabel(new ImageIcon(UIUtils.loadImage("frc/emul/vectrex/images/icon_up.png")));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(jSlider.getMinimum(), new JLabel("Min"));
        ((Dictionary)hashtable).put(16907, jLabel);
        ((Dictionary)hashtable).put(10000, jLabel);
        ((Dictionary)hashtable).put(jSlider.getMaximum(), new JLabel("Max"));
        jSlider.setPaintTicks(false);
        jSlider.setPaintLabels(true);
        jSlider.setOpaque(false);
        jSlider.setLabelTable(hashtable);
        this.chassisZoom = jSlider;
        this.chassisZoomChanged();
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                int n2 = jSlider.getValue();
                if (n2 != (n = (int)(10000.0f * UIChassisSettings.this.emulUI.getChassisZoomFactor()))) {
                    UIChassisSettings.this.emulUI.setChassisZoomFactor((float)n2 / 10000.0f, true);
                    changeListener.stateChanged(null);
                }
            }
        });
        JButton jButton = new JButton(" Chassis Level ");
        JButton jButton2 = new JButton(" Screen Level ");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIChassisSettings.this.emulUI.setChassisZoomFactor(1.0f, true);
                changeListener.stateChanged(null);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIChassisSettings.this.emulUI.setChassisZoomFactor(1.6907f, true);
                changeListener.stateChanged(null);
            }
        });
        JPanel jPanel4 = new JPanel(new GridLayout(1, 0, 10, 0));
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        JPanel jPanel5 = new JPanel(new BorderLayout(10, 10));
        jPanel5.add((Component)jSlider, "North");
        jPanel5.add((Component)jPanel4, "Center");
        jPanel5.setBorder(new CompoundBorder(new TitledBorder(" Zoom Level "), new EmptyBorder(5, 10, 10, 10)));
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 15));
        final JCheckBox jCheckBox8 = this.createCheckBox("Full Viewport Drawing", this.emulUI.isFullViewport());
        jCheckBox8.setHorizontalAlignment(0);
        jCheckBox8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIChassisSettings.this.emulUI.isFullViewport() != jCheckBox8.isSelected()) {
                    UIChassisSettings.this.emulUI.toggleFullViewport();
                }
            }
        });
        JEditorPane jEditorPane = new JEditorPane("text/html", "<b>Drawing to the full viewport</b> will extend the display to<br>the whole window ; but it could also perform much slower,<br>depending on the extended size and display options.");
        jEditorPane.setFont(jCheckBox8.getFont());
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setEditable(false);
        jEditorPane.setBorder(null);
        jEditorPane.setOpaque(false);
        jPanel6.add((Component)jEditorPane, "North");
        jPanel6.add((Component)jCheckBox8, "Center");
        jPanel6.setBorder(new CompoundBorder(new TitledBorder(" Viewport "), new EmptyBorder(5, 10, 10, 10)));
        JPanel jPanel7 = new JPanel(new BorderLayout(10, 10));
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel5, "Center");
        return jPanel7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dismiss() {
        if (this.propsListeners != null) {
            this.emulUI.getDisplayContext().removePropertyChangeListener(this.propsListeners);
        }
        Class<UIChassisSettings> clazz = UIChassisSettings.class;
        synchronized (UIChassisSettings.class) {
            if (dialog != null) {
                dialog.dispose();
                dialog = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void restoreSettings(CfgItemChassis cfgItemChassis, boolean bl) {
        this.emulUI.lockUpdates();
        try {
            this.emulUI.getDisplayContext().updateChassisSettings(cfgItemChassis);
            if (this.emulUI.isFullViewport() != bl) {
                this.emulUI.toggleFullViewport();
            }
        }
        finally {
            this.emulUI.unlockUpdates();
            this.emulUI.updateRendering();
        }
    }

    private void chassisZoomChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UIChassisSettings.this.chassisZoomChanged();
                }
            });
        } else {
            int n;
            int n2 = (int)(10000.0f * this.emulUI.getChassisZoomFactor());
            if (n2 == (n = Math.max(this.chassisZoom.getMinimum(), Math.min(this.chassisZoom.getMaximum(), n2)))) {
                this.chassisZoom.setValue(n2);
            }
        }
    }

    private JCheckBox createCheckBox(String string, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.setBorder(null);
        jCheckBox.setFocusPainted(false);
        return jCheckBox;
    }
}

