/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.config.data.CfgItemOptions;
import frc.emul.util.swing.JSpinnerFix;
import frc.emul.vectrex.swing.UI;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIDisplaySettings {
    private static JDialog dialog;
    private boolean changed;
    private UI emulUI;

    public void configChanged() {
    }

    public final void openSettingsEditor(Window window, UI uI) {
        if (dialog != null) {
            dialog.requestFocus();
            return;
        }
        final JDialog jDialog = UIUtils.createDialog(window, "ParaJVE - Vectors Settings", false);
        final CfgItemOptions cfgItemOptions = uI.getConfig().options.clone();
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        JButton jButton = new JButton("OK");
        final JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jButton2);
        this.emulUI = uI;
        this.changed = false;
        ChangeListener changeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent changeEvent) {
                UIDisplaySettings.this.changed = true;
            }
        };
        JComponent jComponent = this.buildControlsPane(changeListener);
        JPanel jPanel2 = (JPanel)jDialog.getContentPane();
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.add((Component)jComponent, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(Borders.EMPTY_10);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIDisplaySettings.this.changed) {
                    UIDisplaySettings.this.configChanged();
                }
                dialog = null;
                jDialog.dispose();
            }
        });
        UIUtils.registerEscapeButton(jButton2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIDisplaySettings.this.changed) {
                    UIDisplaySettings.this.restoreSettings(cfgItemOptions);
                }
                dialog = null;
                jDialog.dispose();
            }
        });
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jButton2.doClick(0);
            }
        });
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(true);
        dialog = jDialog;
        jDialog.setVisible(true);
    }

    private final JComponent buildControlsPane(ChangeListener changeListener) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JComponent[] jComponentArray = new JComponent[]{this.createWobblingSection(changeListener), this.createThicknessSection(changeListener), this.createBrightnessSection(changeListener)};
        int n = 0;
        while (n < jComponentArray.length) {
            JComponent jComponent = jComponentArray[n];
            jComponent.setBorder(Borders.EMPTY_10);
            jTabbedPane.addTab(" " + jComponent.getName() + " ", jComponent);
            ++n;
        }
        return jTabbedPane;
    }

    private JComponent createThicknessSection(final ChangeListener changeListener) {
        final UI uI = this.emulUI;
        final JSlider jSlider = new JSlider(10, 600, (int)(100.0f * uI.getPointsSize()));
        final JSpinnerFix jSpinnerFix = new JSpinnerFix(new SpinnerNumberModel((double)jSlider.getValue() / 100.0, (double)jSlider.getMinimum() / 100.0, (double)jSlider.getMaximum() / 100.0, 0.1));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix.setValue((double)new Integer(jSlider.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinnerFix.getValue();
                jSlider.setValue((int)(d * 100.0));
                if (d != (double)uI.getPointsSize()) {
                    uI.setPointsSize((float)d);
                    changeListener.stateChanged(null);
                }
            }
        });
        final JSlider jSlider2 = new JSlider(10, 350, (int)(100.0f * uI.getLinesThickness()));
        final JSpinnerFix jSpinnerFix2 = new JSpinnerFix(new SpinnerNumberModel((double)jSlider2.getValue() / 100.0, (double)jSlider2.getMinimum() / 100.0, (double)jSlider2.getMaximum() / 100.0, 0.1));
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinnerFix2.setValue((double)new Integer(jSlider2.getValue()).intValue() / 100.0);
            }
        });
        jSpinnerFix2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                float f = ((Double)jSpinnerFix2.getValue()).floatValue();
                jSlider2.setValue((int)(f * 100.0f));
                if (f != uI.getLinesThickness()) {
                    uI.setLinesThickness(f);
                    changeListener.stateChanged(null);
                }
            }
        });
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.add(new JLabel("<html><b>Lines"));
        jPanel.add(jSlider2);
        jPanel.add(jSpinnerFix2);
        jPanel.add(new JLabel("<html><b>Points"));
        jPanel.add(jSlider);
        jPanel.add(jSpinnerFix);
        UIUtils.makeCompactGrid(jPanel, 3, 0, 0, 6, 4);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CfgItemOptions cfgItemOptions = new CfgItemOptions();
                jSpinnerFix2.setValue(cfgItemOptions.display_size_lines);
                jSpinnerFix.setValue(cfgItemOptions.display_size_points);
            }
        };
        return this.makeTitledPanel(jPanel, "Thickness", actionListener);
    }

    private JComponent createWobblingSection(final ChangeListener changeListener) {
        final UI uI = this.emulUI;
        final JCheckBox jCheckBox = new JCheckBox("Enable", uI.isWobblingEnabled());
        jCheckBox.setBorder(null);
        jCheckBox.setFocusPainted(false);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(0, new JLabel(" min"));
        ((Dictionary)hashtable).put(1000, new JLabel("max "));
        int n = Math.min(1000, Math.max(0, (int)(1000.0f * uI.getWobblingFactor())));
        final JSlider jSlider = new JSlider(0, 0, 1000, n);
        jSlider.setMajorTickSpacing(500);
        jSlider.setMinorTickSpacing(100);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setOpaque(false);
        jSlider.setLabelTable(hashtable);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                uI.setWobblingFactor((float)jSlider.getValue() / 1000.0f);
                changeListener.stateChanged(null);
            }
        });
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                uI.toggleWobbling();
                changeListener.stateChanged(null);
            }
        });
        UIUtils.linkSlider(jCheckBox, jSlider, true);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)jCheckBox, "West");
        jPanel.add((Component)jSlider, "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CfgItemOptions cfgItemOptions = new CfgItemOptions();
                uI.setWobblingFactor(cfgItemOptions.display_wobbling_factor);
                if (jCheckBox.isSelected() != cfgItemOptions.display_wobbling) {
                    jCheckBox.doClick(0);
                }
                jSlider.setValue((int)(cfgItemOptions.display_wobbling_factor * 1000.0f));
            }
        };
        return this.makeTitledPanel(jPanel, "Wobbling", actionListener);
    }

    private JComponent createBrightnessSection(ChangeListener changeListener) {
        final UI uI = this.emulUI;
        final JCheckBox jCheckBox = new JCheckBox("Additive brightness", uI.isAdditiveBlendingEnabled());
        jCheckBox.setBorder(null);
        jCheckBox.setFocusPainted(false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                uI.toggleAdditiveBlending();
            }
        });
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(0, new JLabel("0"));
        ((Dictionary)hashtable).put(100, new JLabel("x1"));
        ((Dictionary)hashtable).put(200, new JLabel("x2"));
        ((Dictionary)hashtable).put(300, new JLabel("x3"));
        ((Dictionary)hashtable).put(400, new JLabel("x4 "));
        float f = Math.max(Float.MIN_VALUE, uI.getBrightnessFactor());
        int n = Math.min(400, Math.max(1, (int)(100.0f / f)));
        final JSlider jSlider = new JSlider(0, 0, 400, n);
        jSlider.setMajorTickSpacing(100);
        jSlider.setMinorTickSpacing(50);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setOpaque(false);
        jSlider.setLabelTable(hashtable);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jSlider.getValue();
                if (n == 0) {
                    n = 1;
                }
                if (n == 99 || n == 101) {
                    n = 100;
                }
                uI.setBrightnessFactor(100.0f / (float)n);
            }
        });
        Hashtable<Integer, JLabel> hashtable2 = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable2).put(0, new JLabel("0.0"));
        ((Dictionary)hashtable2).put(1000, new JLabel("1.0"));
        ((Dictionary)hashtable2).put(2000, new JLabel("2.0"));
        ((Dictionary)hashtable2).put(3000, new JLabel("3.0"));
        float f2 = Math.max(Float.MIN_VALUE, uI.getGammaCorrection());
        int n2 = Math.min(3000, Math.max(10, (int)(1000.0f * f2)));
        final JSlider jSlider2 = new JSlider(0, 0, 3000, n2);
        jSlider2.setMajorTickSpacing(1000);
        jSlider2.setMinorTickSpacing(500);
        jSlider2.setPaintTicks(true);
        jSlider2.setPaintLabels(true);
        jSlider2.setOpaque(false);
        jSlider2.setLabelTable(hashtable2);
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = Math.max(10, jSlider2.getValue());
                if (n >= 995 && n <= 1005) {
                    n = 1000;
                }
                uI.setGammaCorrection((float)n / 1000.0f);
            }
        });
        jSlider2.setBorder(new EmptyBorder(3, 0, 5, 0));
        jSlider.setBorder(jSlider2.getBorder());
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.add(new JLabel("<html><b><align=\"left\">Gamma<br>Correction"));
        jPanel.add(jSlider2);
        jPanel.add(new JLabel("<html><b><align=\"left\">Brightness<br>Multiplier"));
        jPanel.add(jSlider);
        UIUtils.makeCompactGrid(jPanel, 2, 0, 0, 0, 4);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)jCheckBox, "North");
        jPanel2.add((Component)jPanel, "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CfgItemOptions cfgItemOptions = new CfgItemOptions();
                jSlider.setValue((int)(100.0f / cfgItemOptions.display_brightness));
                jSlider2.setValue((int)(1000.0f * cfgItemOptions.display_gamma));
                if (jCheckBox.isSelected() != cfgItemOptions.display_additive_blend) {
                    jCheckBox.doClick(0);
                }
            }
        };
        return this.makeTitledPanel(jPanel2, "Brightness", actionListener);
    }

    private void restoreSettings(CfgItemOptions cfgItemOptions) {
        this.emulUI.lockUpdates();
        try {
            this.emulUI.setPointsSize(cfgItemOptions.display_size_points);
            this.emulUI.setLinesThickness(cfgItemOptions.display_size_lines);
            this.emulUI.setWobblingFactor(cfgItemOptions.display_wobbling_factor);
            if (this.emulUI.isWobblingEnabled() != cfgItemOptions.display_wobbling) {
                this.emulUI.toggleWobbling();
            }
            this.emulUI.setBrightnessFactor(cfgItemOptions.display_brightness);
            this.emulUI.setGammaCorrection(cfgItemOptions.display_gamma);
            if (this.emulUI.isAdditiveBlendingEnabled() != cfgItemOptions.display_additive_blend) {
                this.emulUI.toggleAdditiveBlending();
            }
        }
        finally {
            this.emulUI.unlockUpdates();
            this.emulUI.updateRendering();
        }
    }

    private final JComponent makeTitledPanel(JComponent jComponent, String string, final ActionListener actionListener) {
        JComponent jComponent2;
        final UI uI = this.emulUI;
        jComponent.setBorder(new CompoundBorder(new TitledBorder(" Vectors " + string + " "), Borders.EMPTY_10));
        if (actionListener != null) {
            jComponent2 = new JButton("Reset to default settings");
            ((AbstractButton)jComponent2).setHorizontalAlignment(4);
            ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UIDisplaySettings.this.changed = true;
                    uI.lockUpdates();
                    try {
                        actionListener.actionPerformed(actionEvent);
                    }
                    finally {
                        uI.unlockUpdates();
                        uI.updateRendering();
                    }
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout(8, 8));
            jPanel.add((Component)jComponent, "North");
            jPanel.add((Component)jComponent2, "East");
            jComponent = jPanel;
        }
        jComponent2 = UIDisplaySettings.makeCompactComponent(jComponent);
        jComponent2.setName(string);
        return jComponent2;
    }

    private static final JComponent makeCompactComponent(JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.add((Component)jComponent, "North");
        return jPanel;
    }
}

