/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.util.Utils;
import frc.emul.util.swing.AALabel;
import frc.emul.vectrex.ui.Borders;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.CompoundBorder;

public class UIUtils {
    public static final Cursor CURSOR_HIDDEN = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(""), new Point(0, 0), "HIDDEN_CURSOR");
    private static Cursor CURSOR_CROSS3;
    private static Cursor CURSOR_DOT;
    private static int hideCount;

    private UIUtils() {
    }

    public static final Image getFrameIcon() {
        URL uRL = Utils.getResourceURL("frc/emul/vectrex/images/iconSpike.png");
        return new ImageIcon(uRL).getImage();
    }

    public static final ImageIcon getGrayedIcon(ImageIcon imageIcon) {
        return new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
    }

    /*
     * Loose catch block
     */
    public static final Image loadImage(String string) {
        InputStream inputStream = null;
        inputStream = Utils.getResourceStream(string);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return bufferedImage;
        catch (Exception exception) {
            try {
                System.err.println("Cannot read image \"" + string + "\" :");
                exception.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception3) {}
            return null;
        }
    }

    public static final void evenSizes(Component ... componentArray) {
        Component component;
        Dimension dimension = new Dimension(0, 0);
        Component[] componentArray2 = componentArray;
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            component = componentArray2[n2];
            Dimension dimension2 = component.getPreferredSize();
            dimension.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
            ++n2;
        }
        componentArray2 = componentArray;
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            component = componentArray2[n2];
            component.setPreferredSize(dimension);
            ++n2;
        }
    }

    public static final void forceSquareSize(JComponent jComponent, int n) {
        UIUtils.forceSize(jComponent, n, n);
    }

    public static final void forceSize(JComponent jComponent, int n, int n2) {
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        UIUtils.forceSize(jComponent, dimension);
    }

    public static final void forceSize(Component component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMinimumSize(dimension);
        component.setMaximumSize(dimension);
        component.setSize(dimension);
    }

    public static final void setContainerBorder(Container container) {
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(Borders.BEVEL_RAISED_10);
        }
    }

    public static final JLabel buildCommentsLabel(String string) {
        AALabel aALabel = new AALabel(string);
        aALabel.setBorder(Borders.ETCHED_10);
        return aALabel;
    }

    public static final JComponent buildCommentsLabel(String string, String string2, boolean bl, boolean bl2) {
        return UIUtils.buildTitledPane(string, new AALabel(string2), bl, bl2);
    }

    public static final JComponent buildTitledPane(String string, JComponent jComponent, boolean bl, boolean bl2) {
        JLabel jLabel = UIUtils.buildTitleHeader(string, bl);
        jComponent.setBorder(Borders.EMPTY_10);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jComponent, "Center");
        jPanel.setBorder(bl2 ? Borders.SOFT_LOW : new CompoundBorder(Borders.ETCHED, Borders.EMPTY_1));
        return jPanel;
    }

    public static final JLabel buildTitleHeader(String string, boolean bl) {
        if (string.charAt(0) != '<' || !string.toLowerCase().startsWith("<html>")) {
            string = " " + string + " ";
        }
        int n = bl ? 0 : 10;
        AALabel aALabel = new AALabel(string, n);
        aALabel.setOpaque(true);
        aALabel.setFont(aALabel.getFont().deriveFont(3));
        aALabel.setBackground(Color.DARK_GRAY);
        aALabel.setForeground(Color.WHITE);
        aALabel.setBorder(BorderFactory.createRaisedBevelBorder());
        return aALabel;
    }

    public static final JDialog createDialog(Window window, String string, boolean bl) {
        return window instanceof JDialog ? new JDialog((JDialog)window, string, bl) : new JDialog((JFrame)window, string, bl);
    }

    public static final void center(Window window, Window window2, int n, int n2) {
        Dimension dimension = window.getSize();
        dimension.height += n2;
        dimension.width += n;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (window2 == null) {
            window.setBounds(dimension2.width - dimension.width >> 1, (dimension2.height - dimension.height) / 3, dimension.width, dimension.height);
        } else {
            Dimension dimension3 = window2.getSize();
            Point point = window2.getLocation();
            int n3 = point.x + (dimension3.width - dimension.width >> 1);
            int n4 = point.y + (dimension3.height - dimension.height) / 3;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 + dimension.width >= dimension2.width) {
                n3 = dimension2.width - dimension.width;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 + dimension.height >= dimension2.height) {
                n4 = dimension2.height - dimension.height;
            }
            window.setBounds(n3, n4, dimension.width, dimension.height);
        }
    }

    public static final void unmapAction(JComponent jComponent, KeyStroke keyStroke) {
        UIUtils.mapAction(jComponent, keyStroke, null);
    }

    public static final void unmapAction(JComponent jComponent, int n, KeyStroke keyStroke) {
        UIUtils.mapAction(jComponent, n, keyStroke, null);
    }

    public static final void mapAction(JComponent jComponent, KeyStroke keyStroke, Action action) {
        UIUtils.mapAction(jComponent, 1, keyStroke, action);
    }

    public static final void mapAction(JComponent jComponent, int n, KeyStroke keyStroke, Action action) {
        InputMap inputMap = jComponent.getInputMap(n);
        Object object = inputMap.get(keyStroke);
        if (object == null) {
            if (action == null) {
                return;
            }
            object = keyStroke.toString();
            inputMap.put(keyStroke, object);
        }
        jComponent.getActionMap().put(object, action);
    }

    public static final void snapBounds(Window window, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (rectangle == null) {
            rectangle = new Rectangle(-1, -1, -1, -1);
        }
        bl4 |= -1 == rectangle.x && -1 == rectangle.y;
        Rectangle rectangle2 = UIUtils.getOwnerScreenBounds(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        if (rectangle2 == null) {
            rectangle2 = UIUtils.getDefaultScreenBounds();
            bl4 = true;
        }
        int n = Math.max(50, Math.min(rectangle.width, rectangle2.width));
        int n2 = Math.max(30, Math.min(rectangle.height, rectangle2.height));
        int n3 = Math.max(rectangle.x, rectangle2.x);
        int n4 = Math.max(rectangle.y, rectangle2.y);
        if (bl4) {
            float f;
            if (!window.isDisplayable()) {
                window.pack();
            }
            Insets insets = window.getInsets();
            int n5 = insets.top + insets.bottom;
            int n6 = insets.left + insets.right;
            if (bl2) {
                JMenuBar jMenuBar = new JMenuBar();
                jMenuBar.add(new JMenu("Menu Place Holder"));
                n5 += jMenuBar.getPreferredSize().height;
            }
            if ((n = n6 + (int)((float)((n2 = bl3 ? rectangle2.height : (int)((float)rectangle2.height * 0.98f)) - n5) * (f = bl ? 1.25f : 0.8f))) > rectangle2.width) {
                n = rectangle2.width;
                n2 = n5 + (int)((float)(n - n6) / f);
            }
            n4 = rectangle2.y + (rectangle2.height - n2) / 3;
            n3 = rectangle2.x + (rectangle2.width - n) / 2;
        } else {
            if (n4 + n2 >= rectangle2.y + rectangle2.height) {
                n4 = rectangle2.y + rectangle2.height - n2;
            }
            if (n3 + n >= rectangle2.x + rectangle2.width) {
                n3 = rectangle2.x + rectangle2.width - n;
            }
        }
        window.setBounds(n3, n4, n, n2);
    }

    public static final Rectangle getDefaultScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        return UIUtils.getAvailableScreenBounds(graphicsConfiguration);
    }

    public static final Rectangle getOwnerScreenBounds(int n, int n2, int n3, int n4) {
        Point point = new Point(n + n3 >> 1, n2 + n4 >> 1);
        Rectangle rectangle = UIUtils.getOwnerScreenBounds(point);
        if (rectangle != null) {
            return rectangle;
        }
        point.setLocation(n, n2);
        rectangle = UIUtils.getOwnerScreenBounds(point);
        if (rectangle != null) {
            return rectangle;
        }
        point.setLocation(n3, n4);
        rectangle = UIUtils.getOwnerScreenBounds(point);
        if (rectangle != null) {
            return rectangle;
        }
        point.setLocation(n3, n2);
        rectangle = UIUtils.getOwnerScreenBounds(point);
        if (rectangle != null) {
            return rectangle;
        }
        point.setLocation(n, n4);
        rectangle = UIUtils.getOwnerScreenBounds(point);
        return rectangle;
    }

    public static final Rectangle getOwnerScreenBounds(Point point) {
        if (point != null) {
            try {
                GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                int n = 0;
                while (n < graphicsDeviceArray.length) {
                    GraphicsConfiguration graphicsConfiguration;
                    Rectangle rectangle;
                    GraphicsDevice graphicsDevice = graphicsDeviceArray[n];
                    if (graphicsDevice.getType() == 0 && (rectangle = (graphicsConfiguration = graphicsDevice.getDefaultConfiguration()).getBounds()).contains(point)) {
                        return UIUtils.getAvailableScreenBounds(graphicsConfiguration);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static final Rectangle getAvailableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
        return rectangle;
    }

    public static final void linkedEnabledState(JComponent jComponent, final JComponent jComponent2) {
        jComponent.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    jComponent2.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public static final void linkComponents(final JCheckBox jCheckBox, final JComponent jComponent, boolean bl) {
        if (jComponent instanceof JSlider) {
            UIUtils.linkSlider(jCheckBox, (JSlider)jComponent, bl);
        } else {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jComponent.setEnabled(jCheckBox.isSelected());
                }
            };
            if (bl) {
                actionListener.actionPerformed(null);
            }
            jCheckBox.addActionListener(actionListener);
        }
    }

    public static final void linkSlider(final JCheckBox jCheckBox, final JSlider jSlider, boolean bl) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jCheckBox.isSelected();
                jSlider.setEnabled(bl);
                Dictionary dictionary = jSlider.getLabelTable();
                Enumeration enumeration = dictionary.elements();
                while (enumeration.hasMoreElements()) {
                    Object v = enumeration.nextElement();
                    if (!(v instanceof JComponent)) continue;
                    ((JComponent)v).setEnabled(bl);
                }
            }
        };
        if (bl) {
            actionListener.actionPerformed(null);
        }
        jCheckBox.addActionListener(actionListener);
    }

    public static void makeGrid(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        SpringLayout.Constraints constraints;
        SpringLayout springLayout;
        try {
            springLayout = (SpringLayout)container.getLayout();
        }
        catch (ClassCastException classCastException) {
            System.err.println("The first argument to makeGrid must use SpringLayout.");
            return;
        }
        Spring spring = Spring.constant(n5);
        Spring spring2 = Spring.constant(n6);
        Spring spring3 = Spring.constant(n3);
        Spring spring4 = Spring.constant(n4);
        int n7 = n * n2;
        Spring spring5 = springLayout.getConstraints(container.getComponent(0)).getWidth();
        Spring spring6 = springLayout.getConstraints(container.getComponent(0)).getWidth();
        int n8 = 1;
        while (n8 < n7) {
            constraints = springLayout.getConstraints(container.getComponent(n8));
            spring5 = Spring.max(spring5, constraints.getWidth());
            spring6 = Spring.max(spring6, constraints.getHeight());
            ++n8;
        }
        n8 = 0;
        while (n8 < n7) {
            constraints = springLayout.getConstraints(container.getComponent(n8));
            constraints.setWidth(spring5);
            constraints.setHeight(spring6);
            ++n8;
        }
        SpringLayout.Constraints constraints2 = null;
        constraints = null;
        int n9 = 0;
        while (n9 < n7) {
            SpringLayout.Constraints constraints3 = springLayout.getConstraints(container.getComponent(n9));
            if (n9 % n2 == 0) {
                constraints = constraints2;
                constraints3.setX(spring3);
            } else {
                constraints3.setX(Spring.sum(constraints2.getConstraint("East"), spring));
            }
            if (n9 / n2 == 0) {
                constraints3.setY(spring4);
            } else {
                constraints3.setY(Spring.sum(constraints.getConstraint("South"), spring2));
            }
            constraints2 = constraints3;
            ++n9;
        }
        SpringLayout.Constraints constraints4 = springLayout.getConstraints(container);
        constraints4.setConstraint("South", Spring.sum(Spring.constant(n6), constraints2.getConstraint("South")));
        constraints4.setConstraint("East", Spring.sum(Spring.constant(n5), constraints2.getConstraint("East")));
    }

    public static void makeCompactGrid(Container container, int n, int n2, int n3, int n4, int n5) {
        UIUtils.makeCompactGrid(container, container.getComponentCount() / n, n, n2, n3, n4, n5);
    }

    public static void makeCompactGrid(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        SpringLayout springLayout;
        try {
            springLayout = (SpringLayout)container.getLayout();
        }
        catch (ClassCastException classCastException) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring spring = Spring.constant(n3);
        int n7 = 0;
        while (n7 < n2) {
            Spring spring2 = Spring.constant(0);
            int n8 = 0;
            while (n8 < n) {
                spring2 = Spring.max(spring2, UIUtils.getConstraintsForCell(n8, n7, container, n2).getWidth());
                ++n8;
            }
            n8 = 0;
            while (n8 < n) {
                SpringLayout.Constraints constraints = UIUtils.getConstraintsForCell(n8, n7, container, n2);
                constraints.setX(spring);
                constraints.setWidth(spring2);
                ++n8;
            }
            spring = n7 + 1 < n2 ? Spring.sum(spring, Spring.sum(spring2, Spring.constant(n5))) : Spring.sum(spring, spring2);
            ++n7;
        }
        Spring spring3 = Spring.constant(n4);
        int n9 = 0;
        while (n9 < n) {
            Spring spring4 = Spring.constant(0);
            int n10 = 0;
            while (n10 < n2) {
                spring4 = Spring.max(spring4, UIUtils.getConstraintsForCell(n9, n10, container, n2).getHeight());
                ++n10;
            }
            n10 = 0;
            while (n10 < n2) {
                SpringLayout.Constraints constraints = UIUtils.getConstraintsForCell(n9, n10, container, n2);
                constraints.setY(spring3);
                constraints.setHeight(spring4);
                ++n10;
            }
            spring3 = n9 + 1 < n ? Spring.sum(spring3, Spring.sum(spring4, Spring.constant(n6))) : Spring.sum(spring3, spring4);
            ++n9;
        }
        SpringLayout.Constraints constraints = springLayout.getConstraints(container);
        constraints.setConstraint("South", spring3);
        constraints.setConstraint("East", spring);
    }

    private static SpringLayout.Constraints getConstraintsForCell(int n, int n2, Container container, int n3) {
        SpringLayout springLayout = (SpringLayout)container.getLayout();
        Component component = container.getComponent(n * n3 + n2);
        return springLayout.getConstraints(component);
    }

    public static final void registerEscapeButton(AbstractButton abstractButton, ActionListener actionListener) {
        abstractButton.addActionListener(actionListener);
        abstractButton.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static synchronized void pushHiddenCursor(Component component) {
        UIUtils.pushHiddenCursor(component, CURSOR_HIDDEN);
    }

    public static synchronized void popHiddenCursor(Component component) {
        UIUtils.popHiddenCursor(component, Cursor.getDefaultCursor());
    }

    public static synchronized void pushHiddenCursor(Component component, Cursor cursor) {
        if (hideCount++ == 0) {
            component.setCursor(cursor);
        }
    }

    public static synchronized void popHiddenCursor(Component component, Cursor cursor) {
        if (1 == hideCount--) {
            component.setCursor(cursor);
        }
    }

    public static synchronized void refreshHiddenCursor(Component component) {
        component.setCursor(hideCount > 0 ? CURSOR_HIDDEN : Cursor.getDefaultCursor());
    }

    public static final Cursor createCursor(String string, int[] nArray, int n, int n2) {
        return Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(32, 32, nArray, 0, 32)), new Point(n, n2), string);
    }

    public static final Cursor getCrossHairCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public static final Cursor getDotCursor() {
        if (CURSOR_DOT == null) {
            int[] nArray = new int[1024];
            nArray[0] = -2130706433;
            CURSOR_DOT = UIUtils.createCursor("CURSOR_DOT", nArray, 0, 0);
        }
        return CURSOR_DOT;
    }

    public static final Cursor getCrossCursor() {
        if (CURSOR_CROSS3 == null) {
            int[] nArray = new int[1024];
            nArray[0] = 1354825664;
            nArray[6] = 1354825664;
            nArray[33] = -2134835264;
            nArray[37] = -2134835264;
            nArray[66] = -1061093440;
            nArray[68] = -1061093440;
            nArray[99] = -4128832;
            nArray[132] = -1061093440;
            nArray[130] = -1061093440;
            nArray[165] = -2134835264;
            nArray[161] = -2134835264;
            nArray[192] = 1354825664;
            nArray[198] = 1354825664;
            CURSOR_CROSS3 = UIUtils.createCursor("CURSOR_CROSS", nArray, 3, 3);
        }
        return CURSOR_CROSS3;
    }
}

