/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config.controller;

import frc.emul.config.data.CfgItemCurve;
import frc.emul.util.maths.CatmullRom;
import frc.emul.util.swing.AALabel;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.vectrex.ui.config.controller.UIJInputConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class UICalibrationGrid {
    private final Insets insets = new Insets(0, 0, 0, 0);
    private final JComponent canvas;
    private JComponent panel;
    private final CatmullRom spline;
    private final float[] marks;
    private final float[] samples;
    private float cutIN = 0.0f;
    private float cutOUT = 1.0f;
    private final int cursorRadius;
    private final int radius;
    private boolean tracking;
    private boolean useCursorF;
    private int cursorXI;
    private int cursorYI;
    private float cursorXF;
    private float cursorYF;

    UICalibrationGrid(int n, int n2, String string, boolean bl) {
        this.cursorRadius = n2;
        this.tracking = true;
        this.radius = n;
        this.canvas = this.createCanvas(n, string);
        this.marks = new float[3];
        this.samples = bl ? new float[n * 3] : null;
        this.spline = bl ? new CatmullRom() : null;
        int n3 = 4;
        while (--n3 > 0) {
            this.marks[n3 - 1] = (float)n3 / 4.0f;
        }
    }

    final JComponent getComponent() {
        return this.panel;
    }

    final void setCursor(int n, int n2) {
        this.useCursorF = false;
        if (n != this.cursorXI || n2 != this.cursorYI) {
            this.cursorXI = n;
            this.cursorYI = n2;
            if (this.isEnabled() && this.tracking) {
                this.canvas.repaint();
            }
        }
    }

    final void setCursor(float f, float f2) {
        this.useCursorF = true;
        if (f != this.cursorXF || f2 != this.cursorYF) {
            this.cursorXF = f;
            this.cursorYF = f2;
            if (this.isEnabled() && this.tracking) {
                this.canvas.repaint();
            }
        }
    }

    final void setEnabled(boolean bl) {
        this.canvas.setEnabled(bl);
    }

    final boolean isEnabled() {
        return this.canvas.isEnabled();
    }

    final void setTrackingEnabled(boolean bl) {
        if (this.tracking != bl) {
            this.tracking = bl;
            this.canvas.repaint();
        }
    }

    final synchronized void updateCalibration(CfgItemCurve cfgItemCurve) {
        float[] fArray = this.samples;
        float f = fArray.length;
        this.spline.fill(cfgItemCurve.getPoints(), fArray, 1.0f);
        this.cutIN = 0.0f;
        int n = fArray.length;
        while (n-- > 0) {
            if (!(fArray[n] <= 0.003f)) continue;
            this.cutIN = (float)n / f;
            break;
        }
        this.cutOUT = 0.0f;
        n = fArray.length - 1;
        while (n-- > 0) {
            if (!(fArray[n] <= 0.9999f)) continue;
            this.cutOUT = (float)(n + 1) / (f - 1.0f);
            break;
        }
        n = fArray.length - 1;
        int n2 = this.marks.length;
        block2: while (n2-- > 0) {
            float f2 = (float)(n2 + 1) / (float)(this.marks.length + 1);
            this.marks[n2] = 0.0f;
            while (n > 0) {
                if (fArray[n] <= f2) {
                    this.marks[n2] = (float)n / f;
                    continue block2;
                }
                --n;
            }
        }
        this.canvas.repaint();
    }

    private void render(Graphics2D graphics2D, JComponent jComponent) {
        int n;
        int n2;
        boolean bl = jComponent.isEnabled();
        Insets insets = jComponent.getInsets(this.insets);
        if (bl) {
            if (this.cutOUT < 1.0f) {
                graphics2D.setColor(UIJInputConstants.COLOR_AXIS_LIGHT);
            } else {
                graphics2D.setColor(UIJInputConstants.COLOR_AXIS_BGND);
            }
            graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        } else {
            graphics2D.setColor(jComponent.getParent().getBackground());
            graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        graphics2D.translate(insets.left, insets.top);
        if (bl) {
            if (this.cutOUT < 1.0f) {
                n2 = (int)((float)this.radius * this.cutOUT);
                graphics2D.setColor(UIJInputConstants.COLOR_AXIS_BGND);
                graphics2D.fillRect(this.radius - n2, this.radius - n2, 2 * n2 + 1, 2 * n2 + 1);
            }
            graphics2D.setColor(UIJInputConstants.COLOR_AXIS_LIGHT);
            n2 = this.marks.length;
            while (n2-- > 0) {
                n = (int)((float)(this.radius + 1) * this.marks[n2]);
                graphics2D.drawRect(this.radius - n, this.radius - n, 2 * n, 2 * n);
            }
            if (this.cutIN > 0.0f) {
                n2 = (int)((float)this.radius * this.cutIN);
                graphics2D.fillRect(this.radius - n2, this.radius - n2, 2 * n2 + 1, 2 * n2 + 1);
            }
        }
        graphics2D.setColor(bl ? Color.LIGHT_GRAY : UIJInputConstants.COLOR_GRIDS_OFF);
        graphics2D.drawLine(-1, this.radius, 2 * this.radius + 1, this.radius);
        graphics2D.drawLine(this.radius, -1, this.radius, 2 * this.radius + 1);
        if (bl & this.tracking) {
            if (this.useCursorF) {
                n2 = (int)(this.cursorXF * (float)this.radius);
                n = (int)(this.cursorYF * (float)this.radius);
            } else {
                n2 = (int)((float)(this.cursorXI * this.radius) / 127.0f);
                n = (int)((float)(this.cursorYI * this.radius) / 127.0f);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(this.radius + n2 - this.cursorRadius, this.radius + n, this.radius + n2 + this.cursorRadius, this.radius + n);
            graphics2D.drawLine(this.radius + n2, this.radius + n - this.cursorRadius, this.radius + n2, this.radius + n + this.cursorRadius);
        }
        graphics2D.translate(-insets.left, -insets.top);
    }

    private final JComponent createCanvas(int n, String string) {
        final AALabel aALabel = string == null ? null : new AALabel(string);
        aALabel.setHorizontalAlignment(0);
        JComponent jComponent = new JComponent(){

            public void setEnabled(boolean bl) {
                this.setBorder(bl ? UIJInputConstants.AXIS_BORDER_ON : UIJInputConstants.AXIS_BORDER_OFF);
                aALabel.setEnabled(bl);
                super.setEnabled(bl);
            }

            public void paintComponent(Graphics graphics) {
                UICalibrationGrid.this.render((Graphics2D)graphics, this);
            }
        };
        jComponent.setOpaque(true);
        jComponent.setEnabled(true);
        UIUtils.forceSquareSize(jComponent, n * 2 + 1);
        JPanel jPanel = new JPanel(new BorderLayout(0, 1));
        jPanel.add((Component)jComponent, "South");
        jPanel.add((Component)aALabel, "Center");
        this.panel = new JPanel(new FlowLayout(1, 0, 0));
        this.panel.add(jPanel);
        return jComponent;
    }
}

