/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config.controller;

import frc.emul.config.data.CfgItemController;
import frc.emul.config.data.CfgItemSensitivity;
import frc.emul.periph.joystick.JInputJoystick;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.vectrex.ui.config.controller.UICalibrationGrid;
import frc.emul.vectrex.ui.config.controller.UIResponseCurve;
import frc.emul.vectrex.ui.config.controller.UISensitivityPane;
import frc.input.JInputController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIJInputCalibration {
    private static final long UPDATER_INTERVAL = 15L;
    private static Image IMG_BACKGROUND;
    private static Image IMG_BUTTON_OFF;
    private static Image IMG_BUTTON_ON;
    private static Image IMG_STICK;
    private boolean canceled;
    private JInputJoystick joystick;
    private List<Component> displays;
    private int[] lastSampleI;
    private float[] lastSampleF;
    private UICalibrationGrid gridRaw;
    private UICalibrationGrid gridMapped;
    private UIResponseCurve curveComp;
    private IEditablePanel sensiComp;
    private static final int[] BTN_X;
    private static final int BTN_Y = 49;
    private static final int CENTER_X = 104;
    private static final int CENTER_Y = 66;
    private static final float RADIUS_H = 46.0f;
    private static final float RADIUS_V = 46.0f;

    static {
        BTN_X = new int[]{206, 275, 343, 412};
    }

    public static synchronized boolean preloadImages() {
        if (IMG_BACKGROUND != null) {
            return true;
        }
        Class<UIJInputCalibration> clazz = UIJInputCalibration.class;
        try {
            IMG_BUTTON_OFF = ImageIO.read(clazz.getResourceAsStream("images/keypad_button_off.png"));
            IMG_BUTTON_ON = ImageIO.read(clazz.getResourceAsStream("images/keypad_button_on.png"));
            IMG_STICK = ImageIO.read(clazz.getResourceAsStream("images/keypad_stick.png"));
            IMG_BACKGROUND = ImageIO.read(clazz.getResourceAsStream("images/keypad_bgnd.png"));
            return true;
        }
        catch (Exception exception) {
            System.err.println("Failed to preload images!");
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public final synchronized boolean calibrate(Window window, JInputController jInputController, CfgItemController cfgItemController) {
        if (!UIJInputCalibration.preloadImages()) {
            return false;
        }
        final JDialog jDialog = UIUtils.createDialog(window, "ParaJVE - Controller Calibration", true);
        this.joystick = JInputJoystick.createDevice(jInputController, cfgItemController);
        this.needsUpdate(true);
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 10, 10));
        JButton jButton = new JButton(" OK ");
        final JButton jButton2 = new JButton(" Cancel ");
        jPanel.add(jPanel2);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIJInputCalibration.this.canceled = false;
                jButton2.doClick(0);
            }
        });
        jDialog.setDefaultCloseOperation(2);
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel3.add((Component)this.buildMainPane(cfgItemController), "Center");
        jPanel3.add((Component)jPanel, "South");
        jDialog.getContentPane().add(jPanel3);
        UIUtils.setContainerBorder(jDialog.getContentPane());
        jDialog.pack();
        UIUtils.center(jDialog, jDialog.getOwner(), 0, 0);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(false);
        UpdaterThread updaterThread = new UpdaterThread(this.displays);
        updaterThread.start();
        this.canceled = true;
        jDialog.setVisible(true);
        updaterThread.shutdown();
        if (!this.canceled) {
            this.curveComp.saveCurve(cfgItemController.response);
            this.sensiComp.saveData(cfgItemController.sensitivity);
        }
        return !this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean needsUpdate(boolean bl) {
        this.joystick.poll();
        int n = this.joystick.getButtonsState();
        int n2 = this.joystick.getAnalogX();
        int n3 = -this.joystick.getAnalogY();
        float f = this.joystick.getRawAnalogX();
        float f2 = -this.joystick.getRawAnalogY();
        if (this.lastSampleI == null) {
            this.lastSampleI = new int[]{n2, n3, n};
            this.lastSampleF = new float[]{f, f2};
            return true;
        }
        boolean bl2 = false;
        int[] nArray = this.lastSampleI;
        synchronized (this.lastSampleI) {
            if (this.lastSampleF[0] != f) {
                this.lastSampleF[0] = f;
                bl2 = bl;
            }
            if (this.lastSampleF[1] != f2) {
                this.lastSampleF[1] = f2;
                bl2 = bl;
            }
            if (this.lastSampleI[0] != n2) {
                this.lastSampleI[0] = n2;
                bl2 = true;
            }
            if (this.lastSampleI[1] != n3) {
                this.lastSampleI[1] = n3;
                bl2 = true;
            }
            if (this.lastSampleI[2] != n) {
                this.lastSampleI[2] = n;
                bl2 = true;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return bl2;
        }
    }

    private final void registerDisplay(Component component) {
        if (this.displays == null) {
            this.displays = new ArrayList<Component>();
        }
        this.displays.add(component);
    }

    private final JComponent buildMainPane(CfgItemController cfgItemController) {
        this.gridMapped = new UICalibrationGrid(75, 5, "Mapped Input", false);
        this.gridRaw = new UICalibrationGrid(75, 5, "Raw Input", true);
        this.curveComp = new UIResponseCurve(133, cfgItemController.response, this.joystick, this.gridRaw, this.gridMapped);
        this.sensiComp = UIJInputCalibration.createSensitivityComp(cfgItemController.sensitivity, this.joystick);
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.setBorder(new EmptyBorder(0, 0, 1, 0));
        jPanel.add((Component)this.gridMapped.getComponent(), "North");
        jPanel.add((Component)this.gridRaw.getComponent(), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.setBorder(Borders.ETCHED_10);
        jPanel2.add((Component)this.curveComp.getComponent(), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel3.setBorder(jPanel2.getBorder());
        jPanel3.add((Component)this.sensiComp.getComponent(), "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Analog Response", jPanel2);
        jTabbedPane.addTab("Sensitivity", jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout(15, 10));
        jPanel4.setBorder(Borders.BEVEL_LOW_10);
        jPanel4.add((Component)jPanel, "West");
        jPanel4.add((Component)jTabbedPane, "Center");
        JComponent jComponent = this.createJoyPanel();
        JPanel jPanel5 = new JPanel(new BorderLayout(10, 20));
        jPanel5.add((Component)jComponent, "North");
        jPanel5.add((Component)jPanel4, "Center");
        return jPanel5;
    }

    private static final IEditablePanel createSensitivityComp(CfgItemSensitivity cfgItemSensitivity, final JInputJoystick jInputJoystick) {
        final CfgItemSensitivity cfgItemSensitivity2 = new CfgItemSensitivity(cfgItemSensitivity);
        ChangeListener changeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent changeEvent) {
                jInputJoystick.setSensitivity(cfgItemSensitivity2);
            }
        };
        final JComponent jComponent = UISensitivityPane.buildControlsPane(cfgItemSensitivity2, changeListener, jInputJoystick.isRelativeX(), jInputJoystick.isRelativeY());
        return new IEditablePanel(){

            public void saveData(Object object) {
                ((CfgItemSensitivity)object).copyFrom(cfgItemSensitivity2);
            }

            public JComponent getComponent() {
                return jComponent;
            }
        };
    }

    private final JComponent createJoyPanel() {
        int n = IMG_BACKGROUND.getWidth(null);
        int n2 = IMG_BACKGROUND.getHeight(null);
        JComponent jComponent = new JComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintComponent(Graphics graphics) {
                int n;
                int n2;
                int n3;
                Graphics2D graphics2D = (Graphics2D)graphics;
                super.paintComponent(graphics2D);
                int[] nArray = UIJInputCalibration.this.lastSampleI;
                synchronized (nArray) {
                    n3 = UIJInputCalibration.this.lastSampleI[0];
                    n2 = UIJInputCalibration.this.lastSampleI[1];
                    n = UIJInputCalibration.this.lastSampleI[2];
                }
                float f = (float)n3 / 127.0f;
                float f2 = (float)n2 / 127.0f;
                int n4 = (int)((double)(46.0f * f) * Math.sqrt(1.0f - f2 * f2 / 2.0f));
                int n5 = (int)((double)(46.0f * f2) * Math.sqrt(1.0f - f * f / 2.0f));
                graphics2D.drawImage(IMG_BACKGROUND, 0, 0, null);
                int n6 = 0;
                int n7 = 1;
                while (n6 < 4) {
                    Image image = (n & n7) == 0 ? IMG_BUTTON_ON : IMG_BUTTON_OFF;
                    graphics2D.drawImage(image, BTN_X[n6], 49, null);
                    ++n6;
                    n7 <<= 1;
                }
                graphics2D.drawImage(IMG_STICK, 104 + n4, 66 + n5, null);
            }
        };
        jComponent.setOpaque(false);
        UIUtils.forceSize(jComponent, n, n2);
        this.registerDisplay(jComponent);
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        jPanel.add(jComponent);
        return jPanel;
    }

    private static interface IEditablePanel {
        public JComponent getComponent();

        public void saveData(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdaterThread
    extends Thread {
        private final List<Component> targets;
        private volatile boolean shutdown;
        private volatile boolean ready;

        private UpdaterThread(List<Component> list) {
            super("Calibration pool thread");
            this.targets = list;
        }

        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UpdaterThread.this.ready = true;
                }
            });
            while (!this.ready) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            while (!this.shutdown) {
                try {
                    Thread.sleep(15L);
                }
                catch (Exception exception) {}
                if (!UIJInputCalibration.this.needsUpdate(UIJInputCalibration.this.curveComp.isEnabled())) continue;
                int n = 0;
                while (n < this.targets.size()) {
                    this.targets.get(n).repaint();
                    ++n;
                }
                UIJInputCalibration.this.gridMapped.setCursor(UIJInputCalibration.this.lastSampleI[0], UIJInputCalibration.this.lastSampleI[1]);
                UIJInputCalibration.this.gridRaw.setCursor(UIJInputCalibration.this.lastSampleF[0], UIJInputCalibration.this.lastSampleF[1]);
            }
        }
    }
}

