/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import com.sun.opengl.util.BufferUtil;
import frc.emul.vectrex.ui.opengl.JoglColor;
import frc.emul.vectrex.ui.opengl.shader.ShaderNotSupportedException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLUtils {
    private static Map<Integer, String> GL_CONSTANTS;

    public static void useAlphaBlending(GL gL) {
        gL.glBlendFunc(770, 771);
    }

    public static void useAdditiveBlending(GL gL) {
        gL.glBlendFunc(770, 1);
    }

    public static void dumpExtension(GL gL, String string) {
        System.out.println("OpenGL extension " + string + " : " + (gL.isExtensionAvailable(string) ? "supported" : "NOT supported"));
    }

    public static void checkExtension(GL gL, String string, String string2) throws ShaderNotSupportedException {
        if (!gL.isExtensionAvailable(string)) {
            throw new ShaderNotSupportedException(string2, string);
        }
    }

    public static void dumpExtensions(GL gL) {
        String string = gL.glGetString(7939);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        System.out.println("OpenGL extensions :");
        while (stringTokenizer.hasMoreTokens()) {
            System.out.println("> " + stringTokenizer.nextToken());
        }
        System.out.println();
    }

    public static void dumpInfos(GL gL) {
        System.out.println("OpenGL version ..... [" + GLUtils.getString(gL, 7938) + "]");
        System.out.println("OpenGL vendor ...... [" + GLUtils.getString(gL, 7936) + "]");
        System.out.println("OpenGL renderer .... [" + GLUtils.getString(gL, 7937) + "]");
        System.out.println("OpenGL GLSL ........ [" + GLUtils.getString(gL, 35724) + "]");
        System.out.println("OpenGL GLSL-ARB .... [" + GLUtils.getString(gL, 35724) + "]");
        System.out.println(" ");
        System.out.println("MAX_TEXTURE_UNITS = " + GLUtils.getInt(gL, 34018));
        System.out.println("MAX_TEXTURE_IMAGE_UNITS = " + GLUtils.getInt(gL, 34930));
        System.out.println("MAX_COMBINED_TEXTURE_IMAGE_UNITS = " + GLUtils.getInt(gL, 35661));
        System.out.println("MAX_VERTEX_TEXTURE_IMAGE_UNITS = " + GLUtils.getInt(gL, 35660));
        System.out.println("MAX_TEXTURE_COORDS = " + GLUtils.getInt(gL, 34929));
        System.out.println("MAX_TEXTURE_SIZE = " + GLUtils.getInt(gL, 3379));
        System.out.println("MAX_TEXTURE_BUFFER_SIZE_EXT = " + GLUtils.getInt(gL, 35883));
        System.out.println("MAX_VIEWPORT_DIMS = " + GLUtils.getInt(gL, 3386));
        System.out.println("MAX_RENDERBUFFER_SIZE = " + GLUtils.getInt(gL, 34024));
        System.out.println(" ");
        System.out.println("MAX_ATTRIB_STACK_DEPTH = " + GLUtils.getInt(gL, 3381));
        System.out.println("MAX_CLIENT_ATTRIB_STACK_DEPTH = " + GLUtils.getInt(gL, 3387));
        System.out.println("MAX_MODELVIEW_STACK_DEPTH = " + GLUtils.getInt(gL, 3382));
        System.out.println("MAX_PROJECTION_STACK_DEPTH = " + GLUtils.getInt(gL, 3384));
        System.out.println("MAX_COLOR_ATTACHMENTS = " + GLUtils.getInt(gL, 36063));
        System.out.println("MAX_DRAW_BUFFERS = " + GLUtils.getInt(gL, 34852));
        System.out.println("AUX_BUFFERS = " + GLUtils.getInt(gL, 3072));
        System.out.println(" ");
        System.out.println("ALIASED_POINT_SIZE_RANGE = " + GLUtils.getRange(gL, 33901));
        System.out.println("SMOOTH_POINT_SIZE_RANGE = " + GLUtils.getRange(gL, 2834));
        System.out.println("POINT_SIZE_RANGE = " + GLUtils.getRange(gL, 2834));
        System.out.println("POINT_SIZE_GRANULARITY = " + GLUtils.getInt(gL, 2835));
        System.out.println("SMOOTH_POINT_SIZE_GRANULARITY = " + GLUtils.getInt(gL, 2835));
        System.out.println(" ");
        System.out.println("ALIASED_LINE_WIDTH_RANGE = " + GLUtils.getRange(gL, 33902));
        System.out.println("SMOOTH_LINE_WIDTH_RANGE = " + GLUtils.getRange(gL, 2850));
        System.out.println("LINE_WIDTH_RANGE = " + GLUtils.getRange(gL, 2850));
        System.out.println("LINE_WIDTH_GRANULARITY = " + GLUtils.getInt(gL, 2851));
        System.out.println("SMOOTH_LINE_WIDTH_GRANULARITY = " + GLUtils.getInt(gL, 2851));
        System.out.println(" ");
        System.out.println("GL_rgba_BITS = (R" + GLUtils.getInt(gL, 3410) + ", G" + GLUtils.getInt(gL, 3411) + ", B" + GLUtils.getInt(gL, 3412) + ", A" + GLUtils.getInt(gL, 3413) + ")");
        System.out.println("GL_ACCUM_rgba_BITS = (R" + GLUtils.getInt(gL, 3416) + ", G" + GLUtils.getInt(gL, 3417) + ", B" + GLUtils.getInt(gL, 3418) + ", A" + GLUtils.getInt(gL, 3419) + ")");
        System.out.println("GL_DEPTH_BITS = " + GLUtils.getInt(gL, 3414));
        System.out.println("GL_STENCIL_BITS = " + GLUtils.getInt(gL, 3415));
        System.out.println("GL_SUBPIXEL_BITS = " + GLUtils.getInt(gL, 3408));
        System.out.println("GL_STEREO = " + GLUtils.getBool(gL, 3123));
        System.out.println(" ");
        GLUtils.dumpExtensions(gL);
    }

    public static String getBool(GL gL, int n) {
        int[] nArray = new int[3];
        gL.glGetIntegerv(n, nArray, 0);
        return 1280 == gL.glGetError() ? "n/a" : (nArray[0] != 0 ? "true" : "false");
    }

    public static String getInt(GL gL, int n) {
        int[] nArray = new int[]{-1, -1, -1};
        gL.glGetIntegerv(n, nArray, 0);
        return 1280 == gL.glGetError() ? "n/a" : Integer.toString(nArray[0]);
    }

    public static String getString(GL gL, int n) {
        String string = gL.glGetString(n);
        return 1280 == gL.glGetError() ? "n/a" : string;
    }

    public static String getRange(GL gL, int n) {
        int[] nArray = new int[]{-1, -1, -1};
        gL.glGetIntegerv(n, nArray, 0);
        return 1280 == gL.glGetError() ? "n/a" : "[" + nArray[0] + ".." + nArray[1] + "]";
    }

    public static final String getNonNullConstantName(int n) {
        String string = GLUtils.getConstantName(n);
        return string != null ? string : "0x" + Integer.toHexString(n).toUpperCase();
    }

    public static final synchronized String getConstantName(int n) {
        if (GL_CONSTANTS == null) {
            GL_CONSTANTS = GLUtils.fetchConstants();
        }
        return GL_CONSTANTS.get(n);
    }

    private static final Map<Integer, String> fetchConstants() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        Field[] fieldArray = GL.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String string = field.getName();
            try {
                int n3;
                if (string.startsWith("GL_") && Modifier.isStatic(n3 = field.getModifiers()) && Modifier.isPublic(n3) && field.getType().isAssignableFrom(Integer.TYPE)) {
                    Object object = field.get(null);
                    hashMap.put((Integer)object, string.substring(3));
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return hashMap;
    }

    public static int createEmptyTexture(GL gL, int n, int n2, int n3) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)(n * n2 * n3));
        byteBuffer.limit(byteBuffer.capacity());
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        gL.glBindTexture(3553, nArray[0]);
        gL.glTexImage2D(3553, 0, n3, n, n2, 0, 6408, 5121, (Buffer)byteBuffer);
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glBindTexture(3553, 0);
        return nArray[0];
    }

    public static void deleteTexture(GL gL, int n) {
        if (n != 0) {
            gL.glDeleteTextures(1, new int[]{n}, 0);
        }
    }

    public static void renderWireframeQuad(GL gL, boolean bl, JoglColor joglColor) {
        if (bl) {
            joglColor.apply(gL, 0.66f);
            gL.glBegin(1);
            gL.glVertex2f(-1.0f, 0.0f);
            gL.glVertex2f(1.0f, 0.0f);
            gL.glVertex2f(0.0f, -1.0f);
            gL.glVertex2f(0.0f, 1.0f);
            gL.glEnd();
        }
        joglColor.apply(gL);
        gL.glBegin(2);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glVertex2f(1.0f, 1.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glEnd();
    }

    public static final void renderQuad(GL gL, boolean bl, int n) {
        float f = bl ? 1.0f : 0.0f;
        float f2 = 1.0f - f;
        gL.glBegin(7);
        while (n-- > 0) {
            gL.glTexCoord2f(0.0f, f);
            gL.glVertex2f(-1.0f, -1.0f);
            gL.glTexCoord2f(1.0f, f);
            gL.glVertex2f(1.0f, -1.0f);
            gL.glTexCoord2f(1.0f, f2);
            gL.glVertex2f(1.0f, 1.0f);
            gL.glTexCoord2f(0.0f, f2);
            gL.glVertex2f(-1.0f, 1.0f);
        }
        gL.glEnd();
    }

    public static final void renderQuad(GL gL, boolean bl, float f, float f2, float f3, float f4) {
        float f5 = bl ? 1.0f : 0.0f;
        float f6 = 1.0f - f5;
        float f7 = f + f3;
        float f8 = f2 + f4;
        gL.glBegin(7);
        gL.glTexCoord2f(0.0f, f5);
        gL.glVertex2f(f, f2);
        gL.glTexCoord2f(1.0f, f5);
        gL.glVertex2f(f7, f2);
        gL.glTexCoord2f(1.0f, f6);
        gL.glVertex2f(f7, f8);
        gL.glTexCoord2f(0.0f, f6);
        gL.glVertex2f(f, f8);
        gL.glEnd();
    }
}

