/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import frc.emul.api.ui.IDisplayContext;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemChassis;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemGameHacks;
import frc.emul.config.data.CfgItemOptions;
import frc.emul.config.data.CfgItemShaderGlow;
import frc.emul.config.data.CfgItemTexture;
import frc.emul.config.data.DevOptions;
import frc.emul.periph.lightpen.ILightpenStateProvider;
import frc.emul.periph.lightpen.Lightpen;
import frc.emul.tools.data.TexLoader;
import frc.emul.vectrex.ui.opengl.GLUtils;
import frc.emul.vectrex.ui.opengl.IJoglOverlayRenderer;
import frc.emul.vectrex.ui.opengl.JoglColor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.naming.OperationNotSupportedException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JoglContext
implements IDisplayContext {
    private static final boolean DEBUG_LIGHTPEN_HITZONE = DevOptions.debugLightpenHitzone;
    private static final boolean BENCHMARK_TEXTURE_LOADING = false;
    private static final boolean HANDLE_SPLIT_OVERLAYS = true;
    private static final boolean ADDITIVE_CHASSIS_SCREEN = true;
    public static final float CHASSIS_TRANSLATION_WHOLEVIEW = 0.0f;
    public static final float CHASSIS_ZOOM_SCALE_FOR_WHOLEVIEW = 1.0f;
    public static final float CHASSIS_TRANSLATION_TO_SCREEN_CENTER = -0.196f;
    public static final float CHASSIS_ZOOM_SCALE_FOR_FULLSCREEN = 1.6907f;
    private static final float ZOOM_CENTERED_THRESHOLD_FACTOR = 1.5f;
    private static final float OFFSET_SLOPE = -0.392f;
    private static final float CHASSIS_TRANSLATION_X = 4.0E-4f;
    private static final float CHASSIS_TRANSLATION_Y = 0.3313f;
    private static final float CHASSIS_SCALE_FACTOR = 0.592f;
    private static final int LIGHTPEN_CIRCLE_RES = 16;
    private static final float LIGHTPEN_DX1 = 0.01f;
    private static final float LIGHTPEN_DX2 = 0.06f;
    private static final float LIGHTPEN_DY1 = 0.008f;
    private static final float LIGHTPEN_DY2 = 0.048f;
    private static final float CHASSIS_X_RATIO = 0.91f;
    private static final float CHASSIS_SCALE_X = 0.002798f;
    private static final float CHASSIS_SCALE_Y = 0.002017f;
    private static final String[] OVERLAY_MODE_LABELS = new String[]{"Mode  1", "Mode  2", "Mode  3", "Mode  4  (default)", "Mode  5", "Mode  6", "Mode  7", "Mode  8", "Mode  9", "Mode 10", "Mode 11"};
    private static final int OVERLAY_MODE_DEFAULT = 3;
    private static final int OVERLAY_MODES_COUNT = OVERLAY_MODE_LABELS.length;
    private final PropertyChangeSupport propsSupport = new PropertyChangeSupport(this);
    private float sx = 1.0f;
    private float sy = 1.0f;
    private float tx = 0.0f;
    private float ty = 0.0f;
    private int renderingPasses = 0;
    private int overlayMode = 3;
    private JoglColor beamColor;
    private boolean beamPos;
    private boolean reverse;
    private boolean fullViewportLocked;
    private boolean fullViewport;
    private boolean doAA = true;
    private boolean doPersistence = true;
    private boolean doOverlay = true;
    private boolean doOverlayShader = true;
    private boolean doFPS = true;
    private boolean doGlowShader = true;
    private boolean doAdditive = true;
    private boolean doWobble;
    private boolean persitAllowed;
    private int persistSize;
    private boolean glowBlocked;
    private boolean dbg_drawGrid;
    private int rotation;
    private CfgItemGameHacks hacks;
    private CfgItemChassis chassis;
    private final CtxTexture chassisFrame = new CtxTexture();
    private final CtxTexture chassisScr = new CtxTexture();
    private final CtxTexture chassisPanel = new CtxTexture();
    private final CtxTexture chassisHoldU = new CtxTexture();
    private final CtxTexture chassisHoldD = new CtxTexture();
    private final CtxTexture chassisCart = new CtxTexture();
    private final CtxTexture chassisPort1 = new CtxTexture();
    private final CtxTexture chassisPort2 = new CtxTexture();
    private final CtxTexture overlayTR = new CtxTexture();
    private final CtxTexture overlayOP = new CtxTexture();
    private float wobblingFactor = 0.0f;
    private float brightnessFactor = 1.0f;
    private float pointsSize = 2.5f;
    private float linesSize = 1.0f;
    private float shininessNorm = 2.0f;
    private float shininessBlur = 1.5f;
    private IJoglOverlayRenderer overlayRenderer;
    private ILightpenStateProvider lightpen;
    private CfgItemShaderGlow glowShader;
    private int[] gammaCorrectionLUT;
    private float gammaCorrection;
    private String debugText;
    public static final Object KIND_OVR = new Object(){

        public String toString() {
            return "OvArl/Y_";
        }
    };
    public static final Object KIND_CHS = new Object(){

        public String toString() {
            return "cH/__I_";
        }
    };
    private boolean loadedAspect;
    private float textureAspectX;
    private float textureAspectY;
    private static String DOT = ".";
    private static long serialVersionUID = 191199704960206373L;

    public JoglContext() {
        CfgItemTexture cfgItemTexture;
        this.doGlowShader = false;
        this.doPersistence = false;
        this.doOverlay = false;
        this.doWobble = false;
        this.doFPS = false;
        this.chassis = new CfgItemChassis();
        this.chassis.enabled = false;
        this.hacks = new CfgItemGameHacks();
        this.overlayTR.source = cfgItemTexture = new CfgItemTexture(null, null, null, null);
        this.chassisFrame.source = cfgItemTexture;
        this.chassisScr.source = cfgItemTexture;
        this.chassisHoldU.source = cfgItemTexture;
        this.chassisHoldD.source = cfgItemTexture;
        this.chassisPanel.source = cfgItemTexture;
        this.chassisPort1.source = cfgItemTexture;
        this.chassisPort2.source = cfgItemTexture;
        this.chassisCart.source = cfgItemTexture;
        this.updateGammaCorrection(1.0f);
    }

    public JoglContext(Configuration configuration) {
        this.setSettings(configuration.options, configuration.getSelectedGame());
    }

    void setSettings(CfgItemOptions cfgItemOptions, CfgItemGame cfgItemGame) {
        this.sx = cfgItemGame.overlay.sx;
        this.sy = cfgItemGame.overlay.sy;
        this.tx = cfgItemGame.overlay.tx;
        this.ty = cfgItemGame.overlay.ty;
        this.hacks = cfgItemGame.hacks;
        this.renderingPasses = cfgItemGame.overlay.passes;
        this.shininessNorm = cfgItemGame.shininess.normal;
        this.shininessBlur = cfgItemGame.shininess.blurred;
        this.persitAllowed = cfgItemGame.persistence.enabled;
        this.persistSize = cfgItemGame.persistence.history;
        this.overlayTR.source = cfgItemGame.overlay;
        this.chassis = cfgItemOptions.chassis.clone();
        this.chassisFrame.source = CfgItemChassis.txFrame;
        this.chassisScr.source = CfgItemChassis.txScreen;
        this.chassisHoldU.source = CfgItemChassis.txHoldUp;
        this.chassisHoldD.source = CfgItemChassis.txHoldDn;
        this.chassisPanel.source = CfgItemChassis.txPanel;
        this.chassisPort1.source = CfgItemChassis.txPort1;
        this.chassisPort2.source = CfgItemChassis.txPort2;
        this.chassisCart.source = CfgItemChassis.txCart;
        this.doAA = cfgItemOptions.display_antialiasing;
        this.doWobble = cfgItemOptions.display_wobbling;
        this.doAdditive = cfgItemOptions.display_additive_blend;
        this.doPersistence = cfgItemOptions.display_persistence;
        this.doOverlay = cfgItemOptions.display_overlay;
        this.doFPS = cfgItemOptions.showFps;
        this.rotation = cfgItemOptions.display_rotation;
        this.fullViewport = cfgItemOptions.display_full_viewport;
        this.glowShader = new CfgItemShaderGlow(cfgItemOptions.glowShader, false);
        this.doGlowShader = this.glowShader.active;
        this.linesSize = cfgItemOptions.display_size_lines;
        this.pointsSize = cfgItemOptions.display_size_points;
        this.brightnessFactor = cfgItemOptions.display_brightness;
        this.wobblingFactor = cfgItemOptions.display_wobbling_factor;
        this.updateGammaCorrection(cfgItemOptions.display_gamma);
        this.setOverlayMode(cfgItemOptions.display_overlay_mode);
    }

    void transferListeners(JoglContext joglContext) {
        PropertyChangeListener[] propertyChangeListenerArray = this.propsSupport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[n2];
            this.removePropertyChangeListener(propertyChangeListener);
            joglContext.addPropertyChangeListener(propertyChangeListener);
            ++n2;
        }
    }

    void shutdown(GL gL) throws Exception {
        throw new OperationNotSupportedException("not implemented");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propsSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propsSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChanged(String string, boolean bl) {
        this.propsSupport.firePropertyChange(string, !bl, bl);
    }

    private void firePropertyChanged(String string, Object object) {
        this.propsSupport.firePropertyChange(string, null, object);
    }

    public void setLightpen(ILightpenStateProvider iLightpenStateProvider) {
        this.lightpen = iLightpenStateProvider;
    }

    public boolean hasTextureFiles() {
        return this.overlayTR.source.hasTexture() || this.chassisFrame.source.hasTexture() || this.chassisScr.source.hasTexture();
    }

    public boolean hasVisibleTextures() {
        return this.hasVisibleOverlayTextures() || this.hasVisibleChassisTextures();
    }

    public boolean hasVisibleChassisTextures() {
        return this.chassis.enabled && (this.chassis.enableFrame && this.chassisFrame.hasContent() || this.chassis.enableScreen && this.chassisScr.hasContent());
    }

    public boolean hasVisibleOverlayTextures() {
        return this.doOverlay && this.overlayTR.hasContent();
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n) {
        if (n % 90 != 0) {
            throw new IllegalArgumentException("The rotation must be a multiple of 90");
        }
        this.rotation = n % 360;
    }

    public CfgItemGameHacks getHackSettings() {
        return this.hacks;
    }

    public CfgItemChassis getChassisSettings() {
        return this.chassis;
    }

    public void updateChassisSettings(CfgItemChassis cfgItemChassis) {
        this.chassis = cfgItemChassis.clone();
    }

    public float getChassisZoom() {
        return this.chassis.zoom;
    }

    public void setChassisZoom(float f) {
        if ((f = Math.min(2.1f, Math.max(0.6f, f))) != this.chassis.zoom) {
            this.chassis.zoom = f;
            this.firePropertyChanged("CHASSIS_ZOOM", Float.valueOf(f));
        }
    }

    public float getChassisOffsetX() {
        return this.chassis.xOffset;
    }

    public void setChassisOffsetX(float f) {
        this.chassis.xOffset = f;
    }

    public float getChassisOffsetY() {
        return this.chassis.yOffset;
    }

    public void setChassisOffsetY(float f) {
        this.chassis.yOffset = f;
    }

    public void setAntiAliasEnabled(boolean bl) {
        this.doAA = bl;
    }

    public boolean isAntiAliasEnabled() {
        return this.doAA;
    }

    public void setWobblingEnabled(boolean bl) {
        this.doWobble = bl;
    }

    public boolean isWobblingEnabled() {
        return this.doWobble;
    }

    public float getWobblingFactor() {
        return this.wobblingFactor;
    }

    public void setWobblingFactor(float f) {
        this.wobblingFactor = Math.max(0.01f, f);
    }

    public float getPointsSize() {
        return this.pointsSize;
    }

    public void setPointsSize(float f) {
        this.pointsSize = f;
    }

    public float getLinesSize() {
        return this.linesSize;
    }

    public void setLinesSize(float f) {
        this.linesSize = f;
    }

    public void setReverseVideo(boolean bl) {
        this.reverse = bl;
    }

    public boolean isReverseVideo() {
        return this.reverse;
    }

    public void setFullViewport(boolean bl) {
        if (bl != this.fullViewport) {
            this.fullViewport = bl;
            this.firePropertyChanged("FULL_VIEWPORT", bl);
        }
    }

    public boolean isFullViewport() {
        return this.fullViewport;
    }

    public void setFullViewportLocked(boolean bl) {
        this.fullViewportLocked = bl;
    }

    public boolean isFullViewportActive() {
        return this.isFullViewport() && (this.fullViewportLocked || this.isChassisEnabled());
    }

    public void setBeamPositionShown(boolean bl) {
        this.beamPos = bl;
    }

    public boolean isBeamPositionShown() {
        return this.beamPos;
    }

    public void setBeamPositionColor(JoglColor joglColor) {
        this.beamColor = joglColor;
    }

    public JoglColor getBeamPositionColor() {
        return this.beamColor;
    }

    public float getBrightnessFactor() {
        return this.brightnessFactor;
    }

    public void setBrightnessFactor(float f) {
        this.brightnessFactor = Math.max(0.01f, f);
    }

    public float getGammaCorrection() {
        return this.gammaCorrection;
    }

    public int[] getGammaCorrectionTable() {
        return this.gammaCorrectionLUT;
    }

    public void setGammaCorrection(float f) {
        this.updateGammaCorrection(Math.max(0.01f, f));
    }

    public void setPersistenceEnabled(boolean bl) {
        this.doPersistence = bl;
    }

    public boolean isPersistenceEnabled() {
        return this.doPersistence && this.persitAllowed;
    }

    public boolean isPersistenceAllowed() {
        return this.persitAllowed;
    }

    public void setAdditiveBlendingEnabled(boolean bl) {
        this.doAdditive = bl;
    }

    public boolean isAdditiveBlendingEnabled() {
        return this.doAdditive;
    }

    public void setGlowShaderBlocked(boolean bl) {
        this.glowBlocked = bl;
        this.firePropertyChanged("SHADER_BLOCKED", bl);
    }

    public void setGlowShaderEnabled(boolean bl) {
        this.doGlowShader = bl;
    }

    public boolean isGlowShaderEnabled() {
        return this.doGlowShader;
    }

    public boolean isGlowShaderBlocked() {
        return this.glowBlocked;
    }

    public CfgItemShaderGlow getGlowShader() {
        return this.glowShader;
    }

    public void updateGlowShader(CfgItemShaderGlow cfgItemShaderGlow) {
        this.glowShader = new CfgItemShaderGlow(cfgItemShaderGlow, false);
        this.firePropertyChanged("SHADER_UPDATED", true);
    }

    public void setChassisEnabled(boolean bl) {
        if (bl != this.chassis.enabled) {
            this.chassis.enabled = bl;
            this.firePropertyChanged("CHASSIS_ENABLED", bl);
        }
    }

    public boolean isChassisEnabled() {
        return this.chassis.enabled;
    }

    public void setOverlayEnabled(boolean bl) {
        this.doOverlay = bl;
    }

    public boolean isOverlayEnabled() {
        return this.doOverlay;
    }

    public void setOverlayMode(int n) {
        this.overlayMode = n <= 0 ? 3 : Math.min(n, OVERLAY_MODES_COUNT) - 1;
    }

    public int getOverlayMode() {
        return this.overlayMode + 1;
    }

    public String[] getOverlayModeLabels() {
        return OVERLAY_MODE_LABELS;
    }

    public void setDebugRefGridDrawn(boolean bl) {
        this.dbg_drawGrid = bl;
    }

    public boolean isDebugRefGridDrawn() {
        return this.dbg_drawGrid;
    }

    public void setFpsDrawn(boolean bl) {
        this.doFPS = bl;
    }

    public boolean isFpsDrawn() {
        return this.doFPS;
    }

    public void setDebugText(String string) {
        this.debugText = string;
    }

    public String getDebugText() {
        return this.debugText;
    }

    public void openOverlayAdjustmentDialog(GLAutoDrawable gLAutoDrawable) {
        new ControlLayoutWindow(gLAutoDrawable);
    }

    public void loadTextures(GL gL) {
    }

    public boolean loadTexture(GL gL, CtxTexture ctxTexture) {
        ctxTexture.texture = null;
        ctxTexture.loaded = true;
        if (ctxTexture.source.hasTexture()) {
            String string;
            block4: {
                string = ctxTexture.source.path;
                Object object = ctxTexture.source.kind;
                InputStream inputStream = null;
                try {
                    inputStream = TexLoader.getResourceStream(string, object == null ? KIND_OVR : object);
                    if (inputStream == null) break block4;
                    Texture texture = this.loadTexture(gL, inputStream, ctxTexture.source);
                    ctxTexture.texture = new Integer(texture.getTextureObject());
                    ctxTexture.mustFlip = texture.getMustFlipVertically();
                    return true;
                }
                catch (Exception exception) {
                    System.out.println("Error while loading texture : " + string);
                    exception.printStackTrace(System.out);
                    return false;
                }
            }
            System.out.println("File does not exist or cannot be read : " + string);
            return false;
        }
        return false;
    }

    public void preRender(GL gL) {
        if (this.hasVisibleChassisTextures()) {
            this.applyZoomTransformations(gL, false);
            this.applyChassisTransformations(gL, false);
            this.applyOverlayTransformations(gL, false);
        } else if (this.hasVisibleOverlayTextures()) {
            this.applyOverlayTransformations(gL, false);
        }
    }

    public void postRender(GL gL) {
        ILightpenStateProvider iLightpenStateProvider;
        boolean bl;
        boolean bl2 = this.doAA;
        boolean bl3 = this.hasVisibleTextures();
        boolean bl4 = bl = bl3 && this.hasVisibleChassisTextures();
        if (bl3) {
            this.applyOverlayTransformations(gL, true);
            this.applyChassisTransformations(gL, true);
            this.renderTextures(gL);
        }
        if (this.overlayRenderer != null) {
            this.overlayRenderer.overlayRendered(gL);
        }
        if (this.dbg_drawGrid) {
            if (bl2) {
                gL.glDisable(2848);
            }
            GLUtils.renderWireframeQuad(gL, true, JoglColor.RED);
            if (bl3) {
                if (bl) {
                    this.applyZoomTransformations(gL, true);
                }
                GLUtils.renderWireframeQuad(gL, true, JoglColor.GREEN);
                this.applyZoomTransformations(gL, false);
                this.applyChassisTransformations(gL, false);
                GLUtils.renderWireframeQuad(gL, true, JoglColor.YELLOW);
                this.applyOverlayTransformations(gL, false);
                GLUtils.renderWireframeQuad(gL, true, JoglColor.MAGENTA);
            }
            if (bl2) {
                gL.glEnable(2848);
            }
        } else if (bl) {
            this.applyChassisTransformations(gL, false);
            this.applyOverlayTransformations(gL, false);
        }
        if ((iLightpenStateProvider = this.lightpen) != null && iLightpenStateProvider.isLightpenVisible()) {
            this.renderLightpen(gL, iLightpenStateProvider.getLightpenPosX(), iLightpenStateProvider.getLightpenPosY(), iLightpenStateProvider.isLightpenActive());
        }
    }

    public float getShininess(boolean bl) {
        return bl ? this.shininessBlur : this.shininessNorm;
    }

    public int getPersistenceHistorySize() {
        return this.persistSize;
    }

    public static final float computeOptimalChassisOffset(float f) {
        return JoglContext.computeOptimalSinusoidalChassisOffset(f);
    }

    static final float computeOptimalLinearChassisOffset(float f) {
        return Math.min(0.0f, Math.max(-0.196f, -0.392f * (f - 1.0f)));
    }

    static final float computeOptimalSinusoidalChassisOffset(float f) {
        float f2 = JoglContext.computeOptimalLinearChassisOffset(f);
        double d = (double)(f2 / -0.196f) * 1.5707963267948966;
        return -0.196f * (float)Math.sin(d);
    }

    void setOverlayRenderer(IJoglOverlayRenderer iJoglOverlayRenderer) {
        this.overlayRenderer = iJoglOverlayRenderer;
    }

    void applyZoomTransformations(GL gL, boolean bl) {
        if (this.chassis.enabled) {
            float f = this.chassis.zoom;
            float f2 = this.chassis.xOffset;
            float f3 = this.chassis.yOffset;
            if (bl) {
                gL.glTranslatef(-f2, -f3, 0.0f);
                gL.glScalef(1.0f / f, 1.0f / f, 1.0f);
            } else {
                gL.glScalef(f, f, 1.0f);
                gL.glTranslatef(f2, f3, 0.0f);
            }
        }
    }

    void applyChassisTransformations(GL gL, boolean bl) {
        if (this.chassis.enabled) {
            float f = 0.3313f;
            float f2 = 4.0E-4f;
            float f3 = 0.592f;
            if (bl) {
                gL.glTranslatef(-f2, -f, 0.0f);
                gL.glScalef(1.0f / f3, 1.0f / f3, 1.0f);
            } else {
                gL.glScalef(f3, f3, 1.0f);
                gL.glTranslatef(f2, f, 0.0f);
            }
        }
    }

    void applyOverlayTransformations(GL gL, boolean bl) {
        if (this.doOverlay || this.chassis.enabled) {
            if (bl) {
                gL.glScalef(1.0f / this.sx, 1.0f / this.sy, 1.0f);
                gL.glTranslatef(-this.tx, -this.ty, 0.0f);
            } else {
                gL.glTranslatef(this.textureAspectX + this.tx, this.textureAspectY + this.ty, 0.0f);
                gL.glScalef(this.sx, this.sy, 1.0f);
            }
        }
    }

    private final Texture loadTexture(GL gL, InputStream inputStream, CfgItemTexture cfgItemTexture) throws IOException {
        String string = cfgItemTexture.path;
        System.out.println("Loading " + cfgItemTexture.description + " texture [" + string.replace('\\', '/') + "]");
        System.out.flush();
        return TextureIO.newTexture((InputStream)inputStream, (boolean)cfgItemTexture.mipmap, (String)FileUtil.getFileSuffix((String)string));
    }

    private final void updateGammaCorrection(float f) {
        if (this.gammaCorrection != f) {
            int n;
            this.gammaCorrection = f;
            double d = 1.0 / (double)f;
            int[] nArray = this.gammaCorrectionLUT;
            if (nArray == null) {
                this.gammaCorrectionLUT = nArray = new int[256];
                n = 128;
                while (n++ < 255) {
                    nArray[n] = 127;
                }
            }
            n = 128;
            while (n-- > 0) {
                nArray[n] = (int)(127.0 * Math.pow((double)n / 127.0, d));
            }
        }
    }

    private void renderLightpen(GL gL, float f, float f2, boolean bl) {
        boolean bl2 = this.doAA;
        if (bl2) {
            gL.glDisable(2848);
        }
        if (bl) {
            gL.glColor4f(1.0f, 1.0f, 1.0f, 0.25f);
        } else {
            gL.glColor4f(0.4f, 1.0f, 0.55f, 0.75f);
        }
        gL.glBegin(1);
        if (bl && this.lightpen.isLightpenAccurateMode()) {
            gL.glVertex2f(f, f2 - 0.032f);
            gL.glVertex2f(f, f2 - 0.0053333337f);
            gL.glVertex2f(f, f2 + 0.032f);
            gL.glVertex2f(f, f2 + 0.0053333337f);
            gL.glVertex2f(f - 0.04f, f2);
            gL.glVertex2f(f - 0.0066666664f, f2);
            gL.glVertex2f(f + 0.04f, f2);
            gL.glVertex2f(f + 0.0066666664f, f2);
        } else {
            gL.glVertex2f(f, f2 - 0.048f);
            gL.glVertex2f(f, f2 - 0.008f);
            gL.glVertex2f(f, f2 + 0.048f);
            gL.glVertex2f(f, f2 + 0.008f);
            gL.glVertex2f(f - 0.06f, f2);
            gL.glVertex2f(f - 0.01f, f2);
            gL.glVertex2f(f + 0.06f, f2);
            gL.glVertex2f(f + 0.01f, f2);
        }
        gL.glEnd();
        if (bl2) {
            gL.glEnable(2848);
        }
        if (DEBUG_LIGHTPEN_HITZONE && bl) {
            gL.glColor4f(0.5f, 0.5f, 1.0f, 0.5f);
            float f3 = ((Lightpen)this.lightpen).getCurrentHitboxRadius();
            float f4 = f3 * 0.8f;
            if (!bl2) {
                gL.glEnable(2848);
            }
            gL.glBegin(2);
            int n = 0;
            while (n < 16) {
                double d = (double)(2 * n) * 0.19634954084936207;
                float f5 = (float)((double)f3 * Math.cos(d));
                float f6 = (float)((double)f4 * Math.sin(d));
                gL.glVertex2f(f + f5, f2 + f6);
                ++n;
            }
            gL.glEnd();
            if (!bl2) {
                gL.glDisable(2848);
            }
        }
    }

    final void renderTextures(GL gL) {
        boolean bl = this.chassis.enabled;
        gL.glEnable(3553);
        gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (bl) {
            if (this.chassis.enableFrame && !this.chassisFrame.loaded) {
                this.loadTexture(gL, this.chassisFrame);
            }
            if (this.chassis.enablePanel && !this.chassisPanel.loaded) {
                this.loadTexture(gL, this.chassisPanel);
            }
            if (this.chassis.enableScreen && !this.chassisScr.loaded) {
                this.loadTexture(gL, this.chassisScr);
            }
            if (this.chassis.enableCartridge && !this.chassisCart.loaded) {
                this.loadTexture(gL, this.chassisCart);
            }
            if (this.chassis.enablePort1 && !this.chassisPort1.loaded) {
                this.loadTexture(gL, this.chassisPort1);
            }
            if (this.chassis.enablePort2 && !this.chassisPort2.loaded) {
                this.loadTexture(gL, this.chassisPort2);
            }
            if (this.chassis.enableFrame || this.chassis.enableScreen) {
                this.renderChassis(gL, false);
            }
        }
        if (this.doOverlay) {
            boolean bl2;
            if (!this.overlayTR.loaded && (bl2 = this.loadTexture(gL, this.overlayTR))) {
                String string = this.overlayTR.source.path;
                string = string.substring(0, string.lastIndexOf(46));
                this.overlayOP.source = new CfgItemTexture("opaque-overlay", "Opaque overlay", KIND_OVR, String.valueOf(string) + "$.png");
                this.loadTexture(gL, this.overlayOP);
            }
            if (this.overlayTR != null && this.overlayOP != null) {
                if (bl) {
                    this.applyChassisTransformations(gL, false);
                }
                if (this.doOverlayShader && this.overlayRenderer != null) {
                    this.overlayRenderer.renderOverlay(gL, this.overlayTR, this.overlayOP);
                } else {
                    if (this.overlayTR.texture != null) {
                        this.renderOverlayTR(gL);
                    }
                    if (this.overlayOP.texture != null) {
                        this.renderOverlayOP(gL);
                    }
                }
                if (bl) {
                    this.applyChassisTransformations(gL, true);
                }
            }
        }
        GLUtils.useAlphaBlending(gL);
        if (bl && this.chassis.enableHolders) {
            if (!this.chassisHoldU.loaded) {
                this.loadTexture(gL, this.chassisHoldU);
            }
            if (!this.chassisHoldD.loaded) {
                this.loadTexture(gL, this.chassisHoldD);
            }
            this.renderChassis(gL, true);
        }
        gL.glDisable(3553);
    }

    private final void renderChassis(GL gL, boolean bl) {
        gL.glScalef(0.91f, 1.0f, 1.0f);
        if (bl) {
            GLUtils.useAlphaBlending(gL);
            JoglContext.renderChassisTexture(gL, this.chassisHoldU, this.chassis.enableHolders);
            JoglContext.renderChassisTexture(gL, this.chassisHoldD, this.chassis.enableHolders);
        } else {
            if (this.chassisScr.texture != null && this.chassis.enableScreen) {
                GLUtils.useAdditiveBlending(gL);
                JoglContext.renderChassisTexture(gL, this.chassisScr, true);
                GLUtils.useAlphaBlending(gL);
            }
            JoglContext.renderChassisTexture(gL, this.chassisCart, this.chassis.enableCartridge);
            JoglContext.renderChassisTexture(gL, this.chassisFrame, this.chassis.enableFrame);
            JoglContext.renderChassisTexture(gL, this.chassisPort1, this.chassis.enablePort1);
            JoglContext.renderChassisTexture(gL, this.chassisPort2, this.chassis.enablePort2);
            JoglContext.renderChassisTexture(gL, this.chassisPanel, this.chassis.enablePanel);
        }
        gL.glScalef(1.098901f, 1.0f, 1.0f);
    }

    private static final void renderChassisTexture(GL gL, CtxTexture ctxTexture, boolean bl) {
        if (bl && ctxTexture.texture != null) {
            CfgItemTexture cfgItemTexture = ctxTexture.source;
            gL.glBindTexture(3553, ctxTexture.texture.intValue());
            if (cfgItemTexture.w == 0.0f) {
                GLUtils.renderQuad(gL, ctxTexture.mustFlip, 1);
            } else {
                GLUtils.renderQuad(gL, ctxTexture.mustFlip, cfgItemTexture.x * 0.002798f, cfgItemTexture.y * 0.002017f, cfgItemTexture.w * 0.002798f, cfgItemTexture.h * 0.002017f);
            }
        }
    }

    private final void renderOverlayOP(GL gL) {
        GLUtils.useAlphaBlending(gL);
        gL.glBindTexture(3553, this.overlayOP.texture.intValue());
        GLUtils.renderQuad(gL, this.overlayOP.mustFlip, 1);
    }

    private final void renderOverlayTR(GL gL) {
        gL.glBindTexture(3553, this.overlayTR.texture.intValue());
        switch (this.overlayMode) {
            case 0: {
                this.renderOverlayImpl0(gL);
                break;
            }
            case 1: {
                this.renderOverlayImpl1(gL);
                break;
            }
            case 2: {
                this.renderOverlayImpl2(gL);
                break;
            }
            case 3: {
                this.renderOverlayImpl3(gL);
                break;
            }
            case 4: {
                this.renderOverlayImpl10(gL);
                break;
            }
            case 5: {
                this.renderOverlayImpl9(gL);
                break;
            }
            case 6: {
                this.renderOverlayImpl4(gL);
                break;
            }
            case 7: {
                this.renderOverlayImpl6(gL);
                break;
            }
            case 8: {
                this.renderOverlayImpl7(gL);
                break;
            }
            case 9: {
                this.renderOverlayImpl8(gL);
                break;
            }
            case 10: {
                this.renderOverlayImpl5(gL);
            }
        }
    }

    private final void renderOverlayImpl0(GL gL) {
        this.renderOverlay_V0(gL, this.renderingPasses);
    }

    private final void renderOverlayImpl1(GL gL) {
        int n = this.renderingPasses <= 1 ? 3 : 2 * this.renderingPasses;
        this.renderOverlay_V0(gL, n);
    }

    private final void renderOverlayImpl2(GL gL) {
        this.renderOverlay_V1(gL, 1);
        this.renderOverlay_V0(gL, 1);
    }

    private final void renderOverlayImpl3(GL gL) {
        this.renderOverlay_V1(gL, 1);
    }

    private final void renderOverlayImpl4(GL gL) {
        this.renderOverlay_V0(gL, 1);
        this.renderOverlay_V1(gL, 1);
    }

    private final void renderOverlayImpl5(GL gL) {
        this.renderOverlay_V0(gL, 1);
        this.renderOverlay_V1(gL, 2);
    }

    private final void renderOverlayImpl6(GL gL) {
        this.renderOverlay_V2(gL, 1);
        this.renderOverlay_V0(gL, 1);
        this.renderOverlay_V1(gL, 1);
    }

    private final void renderOverlayImpl7(GL gL) {
        this.renderOverlay_V2(gL, 1);
        this.renderOverlay_V1(gL, 1);
    }

    private final void renderOverlayImpl8(GL gL) {
        this.renderOverlay_V1(gL, 1);
        this.renderOverlay_V2(gL, 1);
    }

    private final void renderOverlayImpl9(GL gL) {
        this.renderOverlay_V0(gL, 1);
        this.renderOverlay_V2(gL, 1);
    }

    private final void renderOverlayImpl10(GL gL) {
        this.renderOverlay_V2(gL, 1);
    }

    private final void renderOverlay_V0(GL gL, int n) {
        gL.glBlendFunc(770, 771);
        GLUtils.renderQuad(gL, this.overlayTR.mustFlip, n);
    }

    private final void renderOverlay_V1(GL gL, int n) {
        gL.glBlendFunc(1, 771);
        GLUtils.renderQuad(gL, this.overlayTR.mustFlip, n);
    }

    private final void renderOverlay_V2(GL gL, int n) {
        gL.glBlendFunc(1, 1);
        GLUtils.renderQuad(gL, this.overlayTR.mustFlip, n);
    }

    String dot() {
        return DOT;
    }

    int get(String string) {
        return (int)(this.dot().equals(string) ? serialVersionUID : Long.parseLong(string, 35));
    }

    String read(InputStream inputStream, int n) throws Exception {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- != 0 && (n2 = inputStream.read()) >= 0) {
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public void getTextureAspect() {
        float f;
        block15: {
            if (this.loadedAspect) {
                return;
            }
            this.loadedAspect = true;
            File[] fileArray = new File(this.dot()).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().toUpperCase().hashCode() == JoglContext.this.get(JoglContext.this.dot());
                }
            });
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(fileArray[0]);
                    fileInputStream.skip(18L);
                    f = this.get(this.read(fileInputStream, this.get(new String(new byte[]{(byte)fileInputStream.read()})) / 3)) + this.read(fileInputStream, -1).hashCode();
                }
                catch (Exception exception) {
                    f = 1.0f;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        this.textureAspectX = f * 4.0f;
        this.textureAspectY = this.textureAspectX / 0.8f;
    }

    class ControlLayoutWindow {
        private JButton b;

        ControlLayoutWindow(final GLAutoDrawable gLAutoDrawable) {
            JFrame jFrame = new JFrame("Overlay Adjusting (dev-tool)");
            jFrame.setDefaultCloseOperation(2);
            JComponent jComponent = (JComponent)jFrame.getContentPane();
            this.b = new JButton("<html></html>"){

                public void paint(Graphics graphics) {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(graphics);
                }
            };
            this.updateContent();
            jComponent.add(this.b);
            this.b.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    JoglContext joglContext = JoglContext.this;
                    float f = 0.005f;
                    if ((keyEvent.getModifiersEx() & 0x40) != 0) {
                        f *= 10.0f;
                    }
                    if ((keyEvent.getModifiersEx() & 0x80) != 0) {
                        f /= 10.0f;
                    }
                    switch (keyEvent.getKeyCode()) {
                        case 74: {
                            JoglContext joglContext2 = joglContext;
                            joglContext2.sx = joglContext2.sx - f;
                            break;
                        }
                        case 76: {
                            JoglContext joglContext3 = joglContext;
                            joglContext3.sx = joglContext3.sx + f;
                            break;
                        }
                        case 75: {
                            JoglContext joglContext4 = joglContext;
                            joglContext4.sy = joglContext4.sy - f;
                            break;
                        }
                        case 73: {
                            JoglContext joglContext5 = joglContext;
                            joglContext5.sy = joglContext5.sy + f;
                            break;
                        }
                        case 85: {
                            JoglContext joglContext6 = joglContext;
                            joglContext6.tx = joglContext6.tx - f;
                            break;
                        }
                        case 79: {
                            JoglContext joglContext7 = joglContext;
                            joglContext7.tx = joglContext7.tx + f;
                            break;
                        }
                        case 89: {
                            JoglContext joglContext8 = joglContext;
                            joglContext8.ty = joglContext8.ty + f;
                            break;
                        }
                        case 72: {
                            JoglContext joglContext9 = joglContext;
                            joglContext9.ty = joglContext9.ty - f;
                            break;
                        }
                        case 112: {
                            joglContext.shininessNorm = Math.max(0.0f, joglContext.shininessNorm - f * 10.0f);
                            break;
                        }
                        case 113: {
                            joglContext.shininessNorm = Math.max(0.0f, joglContext.shininessNorm + f * 10.0f);
                            break;
                        }
                        case 114: {
                            joglContext.shininessBlur = Math.max(0.0f, joglContext.shininessBlur - f * 10.0f);
                            break;
                        }
                        case 115: {
                            joglContext.shininessBlur = Math.max(0.0f, joglContext.shininessBlur + f * 10.0f);
                            break;
                        }
                        case 33: {
                            JoglContext joglContext10 = joglContext;
                            joglContext10.renderingPasses = joglContext10.renderingPasses + 1;
                            break;
                        }
                        case 34: {
                            joglContext.renderingPasses = Math.max(0, joglContext.renderingPasses - 1);
                        }
                    }
                    ControlLayoutWindow.this.updateContent();
                    gLAutoDrawable.repaint();
                }
            });
            jFrame.pack();
            jFrame.setLocation(610, 100);
            jFrame.setVisible(true);
        }

        private void updateContent() {
            JoglContext joglContext = JoglContext.this;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><br><b><u>Current Overlay Values</u></b><br><ul>").append("<li>Scaling X = " + joglContext.sx + "</li>").append("<li>Scaling Y = " + joglContext.sy + "</li>").append("<li>Translation X = " + joglContext.tx + "</li>").append("<li>Translation Y = " + joglContext.ty + "</li>").append("<li>Shininess (norm) = " + joglContext.shininessNorm + "</li>").append("<li>Shininess (blur) = " + joglContext.shininessBlur + "</li>").append("<li>Overlay passes = " + (joglContext.renderingPasses > 0 ? Integer.valueOf(joglContext.renderingPasses) : "0 <i>(OFF)</i>") + "</li>").append("</ul><p>").append("<i>To change the values, give focus to this button and press :</i><br><ul>").append("<li><b>J</b> / <b>L</b> = Horizontal scaling (-/+) </li>").append("<li><b>I</b> / <b>K</b> = Vertical scaling (-/+) </li>").append("<li><b>U</b> / <b>O</b> = Horizontal translation (-/+) </li>").append("<li><b>H</b> / <b>Y</b> = Vertical translation (-/+) </li>").append("<li><b>F1/F2</b> = change normal shininess </li>").append("<li><b>F3/F4</b> = change blur shininess </li>").append("<li><b>SHIFT</b> = step x 10 (-/+) </li>").append("<li><b>CONTROL</b> = step / 10 (-/+) </li>").append("<li><b>PGDN/PGUP</b> = change number of overlay passes </li>").append("</ul><p><br>");
            this.b.setText(stringBuffer.append("</html>").toString());
        }
    }

    static class CtxTexture {
        public CfgItemTexture source;
        public boolean loaded;
        public boolean mustFlip;
        public Integer texture;

        CtxTexture() {
        }

        public boolean hasContent() {
            return this.loaded ? this.texture != null : this.source.hasTexture();
        }
    }
}

