/*
 * Decompiled with CFR 0.152.
 */
package frc.jogl.tools;

import com.sun.opengl.util.GLUT;
import frc.emul.config.data.DevOptions;
import java.text.DecimalFormat;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.glu.GLU;

public class FPSUtils {
    private static final boolean USE_HIRES_TIMER = false;
    private static final long MEMORY_REFRESH_DELAY = 200L;
    public static long mem_time;
    public static long mem_used;
    private static String mem_used_txt;
    private static DecimalFormat mem_used_fmt;
    public static String timingInfos;
    private static int fps_frame;
    private static long fps_time;
    private static long fps_timebase;
    private static long fps_initTime;
    private static int fps_int;
    private static String fps_str;
    private static GLUT glut;
    private static final String[] FPS_ARRAY;

    static {
        mem_used_txt = "";
        timingInfos = "";
        fps_str = "";
        glut = new GLUT();
        FPS_ARRAY = new String[201];
        int n = 0;
        while (n < FPS_ARRAY.length) {
            FPSUtils.FPS_ARRAY[n] = Integer.toString(n);
            ++n;
        }
    }

    public static void drawFPS(GL gL, GLU gLU, GLDrawable gLDrawable) {
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        int n = gLDrawable.getHeight();
        int n2 = 4;
        FPSUtils.setGluOrtho2D(gLU, gLDrawable);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        FPSUtils.computeMillisFPS();
        if (DevOptions.showTimingInfo) {
            FPSUtils.print(gL, 5, n2, timingInfos, true);
            n2 += 13;
        }
        FPSUtils.print(gL, 5, n2, fps_str, true);
        if (DevOptions.showUsedMemoryFPS) {
            FPSUtils.computeMemory();
            FPSUtils.print(gL, 5, n - 12, mem_used_txt, false);
        }
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
    }

    public static void drawText(GL gL, GLU gLU, GLDrawable gLDrawable, int n, int n2, String string, boolean bl) {
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        FPSUtils.setGluOrtho2D(gLU, gLDrawable);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        FPSUtils.print(gL, n, n2 >= 0 ? n2 : gLDrawable.getHeight() + n2, string, bl);
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
    }

    private static void print(GL gL, int n, int n2, String string, boolean bl) {
        int n3;
        int n4 = string.length();
        if (bl) {
            gL.glColor4f(0.0f, 0.0f, 0.0f, 0.75f);
            gL.glRasterPos2i(n + 1, n2);
            n3 = 0;
            while (n3 < n4) {
                glut.glutBitmapCharacter(7, string.charAt(n3));
                ++n3;
            }
            gL.glRasterPos2i(n - 1, n2);
            n3 = 0;
            while (n3 < n4) {
                glut.glutBitmapCharacter(7, string.charAt(n3));
                ++n3;
            }
            gL.glRasterPos2i(n, n2 - 1);
            n3 = 0;
            while (n3 < n4) {
                glut.glutBitmapCharacter(7, string.charAt(n3));
                ++n3;
            }
            gL.glRasterPos2i(n, n2 + 1);
            n3 = 0;
            while (n3 < n4) {
                glut.glutBitmapCharacter(7, string.charAt(n3));
                ++n3;
            }
        } else {
            gL.glColor4f(0.0f, 0.0f, 0.0f, 0.65f);
            gL.glBegin(7);
            gL.glVertex2i(0, n2 - 4);
            gL.glVertex2i(0, n2 + 12);
            gL.glVertex2i(Integer.MAX_VALUE, n2 + 12);
            gL.glVertex2i(Integer.MAX_VALUE, n2 - 4);
            gL.glEnd();
            gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL.glRasterPos2i(n, n2);
        n3 = 0;
        while (n3 < n4) {
            glut.glutBitmapCharacter(7, string.charAt(n3));
            ++n3;
        }
    }

    private static void setGluOrtho2D(GLU gLU, GLDrawable gLDrawable) {
        int n;
        int n2 = gLDrawable.getWidth();
        float f = (float)n2 / (float)((n = gLDrawable.getHeight()) == 0 ? 1 : n);
        if (f >= 0.8f) {
            gLU.gluOrtho2D(0.0, (double)((float)n * 0.8f - 1.0f), 0.0, (double)(n - 1));
        } else {
            gLU.gluOrtho2D(0.0, (double)(n2 - 1), 0.0, (double)((float)n2 / 0.8f - 1.0f));
        }
    }

    private static String toString(int n) {
        try {
            return FPS_ARRAY[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return Integer.toString(n);
        }
    }

    private static void computeMillisFPS() {
        ++fps_frame;
        fps_time = System.currentTimeMillis() - fps_initTime;
        if (fps_time - fps_timebase > 1000L) {
            fps_int = (int)((double)fps_frame * 1000.0 / (double)(fps_time - fps_timebase));
            fps_timebase = fps_time;
            fps_frame = 0;
            fps_str = FPSUtils.toString(fps_int);
        }
    }

    private static void computeNanosFPS() {
        ++fps_frame;
        fps_time = System.nanoTime() - fps_initTime;
        if (fps_time - fps_timebase > 1000000000L) {
            fps_int = (int)((double)fps_frame * 1.0E9 / (double)(fps_time - fps_timebase));
            fps_timebase = fps_time;
            fps_frame = 0;
            fps_str = FPSUtils.toString(fps_int);
        }
    }

    private static void computeMemory() {
        long l;
        if (mem_used_fmt == null) {
            mem_used_fmt = new DecimalFormat();
            mem_used_fmt.setGroupingSize(3);
            mem_used_fmt.setGroupingUsed(true);
            mem_used_fmt.setMaximumFractionDigits(0);
            mem_used_fmt.setDecimalSeparatorAlwaysShown(false);
        }
        if ((l = System.currentTimeMillis()) - mem_time >= 200L) {
            Runtime runtime = Runtime.getRuntime();
            mem_used = (runtime.totalMemory() - runtime.freeMemory()) / 1000L;
            mem_used_txt = mem_used_fmt.format(mem_used);
            mem_time = l;
        }
    }
}

