/*
 * Decompiled with CFR 0.152.
 */
package frc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BytesArrayOutputStream
extends ByteArrayOutputStream {
    public BytesArrayOutputStream() {
    }

    public BytesArrayOutputStream(int n) {
        super(n);
    }

    public BytesArrayOutputStream(byte[] byArray) {
        this(byArray, 0);
    }

    public BytesArrayOutputStream(byte[] byArray, int n) {
        super(0);
        this.buf = byArray;
        this.count = n;
    }

    public int getCurrentOffset() {
        return this.size();
    }

    public byte[] getCurrentContent() {
        return this.buf;
    }

    public synchronized void insert(int n, int n2) {
        this.allocate(n);
        this.count += n;
        System.arraycopy(this.buf, n2, this.buf, n2 + n, this.size() - n2);
        Arrays.fill(this.buf, n2, n2 + n, (byte)0);
    }

    public synchronized void insert(byte[] byArray, int n, int n2, int n3) {
        this.allocate(n3);
        this.count += n3;
        System.arraycopy(this.buf, n2, this.buf, n2 + n3, this.size() - n2);
        System.arraycopy(byArray, n, this.buf, n2, n3);
    }

    public synchronized void flush(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.size());
        this.reset();
    }

    private void allocate(int n) {
        int n2;
        int n3 = this.size() + n;
        if (n3 > (n2 = this.buf.length)) {
            byte[] byArray = new byte[Math.max(n2 << 1, n3)];
            System.arraycopy(this.buf, 0, byArray, 0, n);
            this.buf = byArray;
        }
    }
}

