/*
 * Decompiled with CFR 0.152.
 */
package frc.util;

public class IntStack {
    private int[] stack;
    private int nextIdx;

    public IntStack() {
        this(16);
    }

    public IntStack(int n) {
        this.stack = new int[n];
    }

    public void push(int n) {
        if (this.nextIdx == this.stack.length) {
            int[] nArray = new int[this.stack.length << 1];
            System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
            this.stack = nArray;
        }
        this.stack[this.nextIdx++] = n;
    }

    public int pop() {
        try {
            return this.stack[--this.nextIdx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.nextIdx = 0;
            throw arrayIndexOutOfBoundsException;
        }
    }

    public void poke(int n) {
        this.stack[this.nextIdx - 1] = n;
    }

    public int peek() {
        return this.stack[this.nextIdx - 1];
    }

    public void discard(int n) {
        this.nextIdx = Math.max(0, this.nextIdx - n);
    }

    public boolean isEmpty() {
        return this.nextIdx == 0;
    }

    public int getSize() {
        return this.nextIdx;
    }

    public void clear() {
        this.nextIdx = 0;
    }
}

