;;==========================================================================;;
;;  Envelopes                                                               ;;
;;==========================================================================;;
ENV     PROC

@@01:   ; envelope #1
        DECLE   $FFEE, $DCBA, $8642, $1000
        DECLE   $0000, $0000, $0000, $0000
        DECLE   $0000, $0000, $0000, $0000

        ENDP

;;==========================================================================;;
;;  Null pattern                                                            ;;
;;==========================================================================;;
NULL_P  EQU     0

;;==========================================================================;;
;;  M_INTRO                                                                 ;;
;;  Intro                                                                   ;;
;;==========================================================================;;
M_INTRO PROC

;;--------------------------------------------------------------------------;;
;;  Header                                                                  ;;
;;--------------------------------------------------------------------------;;
        ; speed, properties, pointers
        DECLE   7, M_3CH OR M_TICK, @@patterns
        ; order of patterns
        DECLE   00, 00, 01
        DECLE   $8000

;;--------------------------------------------------------------------------;;
;;  Detail of patterns                                                      ;;
;;--------------------------------------------------------------------------;;
@@patterns:
        DECLE   16, @@p000, @@p001, @@p002    ; 00
        DECLE   8,  @@p003, @@p004, @@p005    ; 01

;;--------------------------------------------------------------------------;;
;;  Patterns data                                                           ;;
;;--------------------------------------------------------------------------;;
        ; pattern #00 / channel A
@@p000: NOTES("A#3 0C1", "A#3 0C1", "G#4 0C0", "G#4 0C1")
        NOTES("F-4 0C2", "G-3 0C0", "G#4 0C0", "G#3 0C0")
        NOTES("G#4 0C0", "A-3 0C0", "A-4 0C0", "")

        ; pattern #00 / channel B
@@p001: NOTES("NUL 003", "A#2 0C2", "A#2 0C5", "A#2 0C2")

        ; pattern #00 / channel C
@@p002: NOTES("NUL 00F", "", "", "")

        ; pattern #01 / channel A
@@p003: NOTES("A#3 0C0", "OFF 006", "", "")

        ; pattern #01 / channel B
@@p004: NOTES("A#2 0C7", "", "", "")

        ; pattern #01 / channel C
@@p005: NOTES("A#4 0C7", "", "", "")

        ENDP

;;==========================================================================;;
;;  M_GAME                                                                  ;;
;;  Background music during game                                            ;;
;;==========================================================================;;
M_GAME  PROC

;;--------------------------------------------------------------------------;;
;;  Header                                                                  ;;
;;--------------------------------------------------------------------------;;
        ; speed, properties, pointers
        DECLE   7, M_TICK, @@patterns
        ; order of patterns
        DECLE   00, 01, 00, 01, 02, 03, 00, 01
        DECLE   04, 02, 00, 05
        DECLE   -12 AND $FFFF

;;--------------------------------------------------------------------------;;
;;  Detail of patterns                                                      ;;
;;--------------------------------------------------------------------------;;
@@patterns:
        DECLE   16, @@p000, NULL_P, NULL_P    ; 00
        DECLE   16, @@p001, NULL_P, NULL_P    ; 01
        DECLE   16, @@p002, NULL_P, NULL_P    ; 02
        DECLE   16, @@p003, NULL_P, NULL_P    ; 03
        DECLE   16, @@p004, NULL_P, NULL_P    ; 04
        DECLE   16, @@p005, NULL_P, NULL_P    ; 05

;;--------------------------------------------------------------------------;;
;;  Patterns data                                                           ;;
;;--------------------------------------------------------------------------;;
        ; pattern #00 / channel A
@@p000: NOTES("E-2 0A1", "E-2 0A1", "E-3 0A1", "E-3 0A0")
        NOTES("D-3 0A1", "D-3 0A0", "B-2 0A1", "D-3 0A1")
        NOTES("E-3 0A1", "", "", "")

        ; pattern #01 / channel A
@@p001: NOTES("E-2 0A1", "E-2 0A1", "E-3 0A1", "E-3 0A0")
        NOTES("D-3 0A1", "D-3 0A0", "B-2 0A1", "A-2 0A0")
        NOTES("A#2 0A0", "B-2 0A1", "", "")

        ; pattern #02 / channel A
@@p002: NOTES("A-2 0A1", "A-2 0A1", "A-3 0A1", "A-3 0A0")
        NOTES("G-3 0A1", "G-3 0A0", "E-3 0A1", "G-3 0A1")
        NOTES("A-3 0A1", "", "", "")

        ; pattern #03 / channel A
@@p003: NOTES("A-2 0A1", "A-2 0A1", "A-3 0A1", "A-3 0A0")
        NOTES("G-3 0A1", "G-3 0A0", "E-3 0A1", "D-3 0A0")
        NOTES("D#3 0A0", "E-3 0A1", "", "")

        ; pattern #04 / channel A
@@p004: NOTES("B-2 0A1", "B-2 0A1", "B-3 0A1", "B-3 0A0")
        NOTES("A-3 0A1", "A-3 0A0", "F#3 0A1", "A-3 0A1")
        NOTES("B-3 0A1", "", "", "")

        ; pattern #05 / channel A
@@p005: NOTES("E-2 0A0", "E-2 0A1", "E-2 0A0", "G#2 0A0")
        NOTES("G#2 0A1", "G#2 0A0", "A-2 0A0", "A-2 0A1")
        NOTES("A-2 0A0", "A#2 0A0", "A#2 0A1", "B-2 0A0")

        ENDP

;;==========================================================================;;
;;  M_LEVEL                                                                 ;;
;;  Played at intermediate checkpoints                                      ;;
;;==========================================================================;;
M_LEVEL PROC

;;--------------------------------------------------------------------------;;
;;  Header                                                                  ;;
;;--------------------------------------------------------------------------;;
        ; speed, properties, pointers
        DECLE   8, M_DUP, @@patterns
        ; order of patterns
        DECLE   00
        DECLE   $8000

;;--------------------------------------------------------------------------;;
;;  Detail of patterns                                                      ;;
;;--------------------------------------------------------------------------;;
@@patterns:
        DECLE   32, @@p000, NULL_P, NULL_P    ; 00

        ; pattern #00 / channel A
@@p000: NOTES("A#3 0C0", "F-4 0C0", "A#4 0C0", "D#4 0C0")
        NOTES("G-4 0C0", "A#4 0C0", "F-4 0C0", "A-4 0C0")
        NOTES("C-5 0C0", "A#4 0C0", "A-4 0C0", "F-4 0C0")
        NOTES("A#3 0C0", "F-4 0C0", "A#4 0C0", "D#4 0C0")
        NOTES("G-4 0C0", "A#4 0C0", "F-4 0C0", "A-4 0C0")
        NOTES("C-5 0C0", "A#3 0CA", "", "")

        ENDP

;;==========================================================================;;
;;  M_COURS                                                                 ;;
;;  Played at checkpoint Z                                                  ;;
;;==========================================================================;;
M_COURS PROC

;;--------------------------------------------------------------------------;;
;;  Header                                                                  ;;
;;--------------------------------------------------------------------------;;
        ; speed, properties, pointers
        DECLE   9, M_DUP, @@patterns
        ; order of patterns
        DECLE   00, 01, 00, 02
        DECLE   $8000

;;--------------------------------------------------------------------------;;
;;  Detail of patterns                                                      ;;
;;--------------------------------------------------------------------------;;
@@patterns:
        DECLE   16, @@p000, NULL_P, NULL_P    ; 00
        DECLE   8,  @@p001, NULL_P, NULL_P    ; 01
        DECLE   16, @@p002, NULL_P, NULL_P    ; 02

;;--------------------------------------------------------------------------;;
;;  Patterns data                                                           ;;
;;--------------------------------------------------------------------------;;
        ; pattern #00 / channel A
@@p000: NOTES("A#3 0C0", "F-4 0C0", "A#4 0C0", "D-5 0C0")
        NOTES("A#4 0C0", "F-4 0C0", "D#5 0C0", "A#4 0C0")
        NOTES("F-4 0C0", "F-5 0C0", "A#4 0C0", "F-4 0C0")
        NOTES("A#3 0C0", "F-4 0C0", "A#4 0C0", "D-5 0C0")

        ; pattern #01 / channel A
@@p001: NOTES("A#4 0C0", "F-4 0C0", "A#4 0C0", "A-4 0C0")
        NOTES("G-4 0C0", "F-4 0C2", "", "")

        ; pattern #02 / channel A
@@p002: NOTES("A#4 0C0", "F-4 0C0", "F-3 0C0", "G-3 0C0")
        NOTES("A-3 0C0", "A#3 0CA", "", "")

        ENDP

;;==========================================================================;;
;;  M_OVER                                                                  ;;
;;  Game Over                                                               ;;
;;==========================================================================;;
M_OVER  PROC

;;--------------------------------------------------------------------------;;
;;  Header                                                                  ;;
;;--------------------------------------------------------------------------;;
        ; speed, properties, pointers
        DECLE   9, M_DUP, @@patterns
        ; order of patterns
        DECLE   00
        DECLE   $8000

;;--------------------------------------------------------------------------;;
;;  Detail of patterns                                                      ;;
;;--------------------------------------------------------------------------;;
@@patterns:
        DECLE   16, @@p000, NULL_P, NULL_P    ; 00

;;--------------------------------------------------------------------------;;
;;  Patterns data                                                           ;;
;;--------------------------------------------------------------------------;;
        ; pattern #00 / channel A
@@p000: NOTES("A#3 0C0", "D-4 0C0", "F-4 0C0", "G#4 0C1")
        NOTES("G#4 0C0", "G-4 0C0", "F-4 0C0", "G#3 0C0")
        NOTES("G#4 0C0", "A-3 0C0", "A-4 0C0", "A#3 0C3")
        
        ENDP
