
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#include <math.h>

_inline void agb_bios_soft_reset()
{	/*CPUƓRAM̏*/
	console_print("swi 0 (SoftReset)\n");
	agb_initialize_register();
	arm.reg[15] = (!agb_inram[0x7FFA])?0x08000000:0x02000000;
	agb_initialize_memory();
}

_inline void agb_bios_register_ram_reset()
{	/*tOƓRAM̏*/
	console_print("swi 01h (RegisterRamReset)\n");
	memset(agb_inram, 0, 0x7E00);	/*3007E00h-3007FFFh͏Ȃ*/
	ARM_CPSR	=	0x0000001F;	/*R16==CPSR Xe[^XWX^*/
}

_inline void agb_bios_halt()
{
	console_print("swi 02h (Halt)\n");
}

_inline void agb_bios_stop()
{
	console_print("swi 03h (Stop)\n");
}

_inline void agb_bios_intr_wait()
{
	console_print("swi 04h (IntrWait)\n");
}

_inline void agb_bios_vblank_intr_wait()
{
	console_print("swi 05h (VBlankIntrWait)\n");
}

_inline void agb_bios_div()
{
	console_print("swi 06h (Div)\n");
	arm.reg[1] = arm.reg[0] % arm.reg[1];
	arm.reg[3] = abs(arm.reg[0] / arm.reg[1]);
	arm.reg[0] = arm.reg[0] / arm.reg[1];
}

_inline void agb_bios_div_arm()
{
	console_print("swi 07h (DivArm)\n");
	arm.reg[1] = arm.reg[1] % arm.reg[0];
	arm.reg[3] = abs(arm.reg[1] / arm.reg[0]);
	arm.reg[0] = arm.reg[1] / arm.reg[0];
}

_inline void agb_bios_sqrt()
{
	console_print("swi 08h (Sqrt)\n");
	arm.reg[0] = (u32)sqrt(arm.reg[0]);
}

_inline void agb_bios_arc_tan()
{
	console_print("swi 09h (ArcTan)\n");
	arm.reg[0] = (u32)tan(arm.reg[0]);
}

_inline void agb_bios_arc_tan2()
{
	console_print("swi 0Ah (ArcTan2)\n");
	arm.reg[0] = (u32)tan(arm.reg[0]);
}
