
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

inline void agb_dma_transfer()
{
	u32	dma_sad, dma_dad;
	u16	dma_size, dma_cnt_h;

	dma_cnt_h	= io_dma->dma0cnt_h;
	if(dma_cnt_h & BIT15){	/*1 : DMA Enable*/
		dma_sad	 = io_dma->dma0sad & 0x07FFFFFF;	/*], DMA0ROM̈włȂ*/
		dma_dad  = io_dma->dma0dad & 0x07FFFFFF;	/*]*/
		dma_size = io_dma->dma0cnt_l;				/*]JEg*/
		if(dma_cnt_h & BIT10){	/*1 : 32bit - DMA Transfer Type*/
			agb_write_mem32(dma_dad, agb_read_mem32(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:/*0=Increment*/
				dma_sad += 4;
				break;
			case 1:/*1=Decrement*/
				dma_sad -= 4;
				break;
			case 2:/*2=Fixed*/
				break;
			case 3:/*3=Increment/Reload*/
				dma_sad += 4;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 4;
				break;
			case 1:
				dma_dad -= 4;
				break;
			case 2:
				break;
			case 3:/*3=Prohibited*/
				return;/* ? */
			}
		}else{						/*0 : 16bit*/
			agb_write_mem16(dma_dad, agb_read_mem16(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:
				dma_sad += 2;
				break;
			case 1:
				dma_sad -= 2;
				break;
			case 3:
				dma_sad += 2;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 2;
				break;
			case 1:
				dma_dad -= 2;
				break;
			}
		}
		dma_size--;	/*CNT_L0̏ꍇ͍ő啝ɂȂ*/
		if(!dma_size)io_dma->dma0cnt_h &= ~BIT15;	/*]*/
		io_dma->dma0sad   = dma_sad;
		io_dma->dma0dad	  = dma_dad;
		io_dma->dma0cnt_l = dma_size;
	}

	dma_cnt_h	= io_dma->dma1cnt_h;
	if(dma_cnt_h & BIT15){
		dma_sad	 = io_dma->dma1sad & 0x0FFFFFFF;
		dma_dad  = io_dma->dma1dad & 0x07FFFFFF;
		dma_size = io_dma->dma1cnt_l;
		if(dma_cnt_h & BIT10){	/*1 : 32bit - DMA Transfer Type*/
			agb_write_mem32(dma_dad, agb_read_mem32(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:/*0=Increment*/
				dma_sad += 4;
				break;
			case 1:/*1=Decrement*/
				dma_sad -= 4;
				break;
			case 2:/*2=Fixed*/
				break;
			case 3:/*3=Increment/Reload*/
				dma_sad += 4;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 4;
				break;
			case 1:
				dma_dad -= 4;
				break;
			case 2:
				break;
			case 3:
				break;
			}
		}else{						/*0 : 16bit*/
			agb_write_mem16(dma_dad, agb_read_mem16(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:
				dma_sad += 2;
				break;
			case 1:
				dma_sad -= 2;
				break;
			case 3:
				dma_sad += 2;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 2;
				break;
			case 1:
				dma_dad -= 2;
				break;
			}
		}
		dma_size--;
		if(!dma_size)io_dma->dma1cnt_h &= ~BIT15;
		io_dma->dma1sad   = dma_sad;
		io_dma->dma1dad	  = dma_dad;
		io_dma->dma1cnt_l = dma_size;
	}

	dma_cnt_h	= io_dma->dma2cnt_h;
	if(dma_cnt_h & BIT15){
		dma_sad	 = io_dma->dma2sad & 0x0FFFFFFF;
		dma_dad  = io_dma->dma2dad & 0x07FFFFFF;
		dma_size = io_dma->dma2cnt_l;
		if(dma_cnt_h & BIT10){	/*1 : 32bit - DMA Transfer Type*/
			agb_write_mem32(dma_dad, agb_read_mem32(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:/*0=Increment*/
				dma_sad += 4;
				break;
			case 1:/*1=Decrement*/
				dma_sad -= 4;
				break;
			case 2:/*2=Fixed*/
				break;
			case 3:/*3=Increment/Reload*/
				dma_sad += 4;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 4;
				break;
			case 1:
				dma_dad -= 4;
				break;
			case 2:
				break;
			case 3:
				break;
			}
		}else{						/*0 : 16bit*/
			agb_write_mem16(dma_dad, agb_read_mem16(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:
				dma_sad += 2;
				break;
			case 1:
				dma_sad -= 2;
				break;
			case 3:
				dma_sad += 2;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 2;
				break;
			case 1:
				dma_dad -= 2;
				break;
			}
		}
		dma_size--;
		if(!dma_size)io_dma->dma2cnt_h &= ~BIT15;
		io_dma->dma2sad   = dma_sad;
		io_dma->dma2dad	  = dma_dad;
		io_dma->dma2cnt_l = dma_size;
	}

	dma_cnt_h	= io_dma->dma3cnt_h;
	if(dma_cnt_h & BIT15){
		dma_sad	 = io_dma->dma3sad & 0x0FFFFFFF;//dma_sad	 += 8;
		dma_dad  = io_dma->dma3dad & 0x07FFFFFF;
		dma_size = io_dma->dma3cnt_l;
		if(dma_cnt_h & BIT10){	/*1 : 32bit - DMA Transfer Type*/
			agb_write_mem32(dma_dad, agb_read_mem32(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:/*0=Increment*/
				dma_sad += 4;
				break;
			case 1:/*1=Decrement*/
				dma_sad -= 4;
				break;
			case 2:/*2=Fixed*/
				break;
			case 3:/*3=Increment/Reload*/
				dma_sad += 4;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 4;
				break;
			case 1:
				dma_dad -= 4;
				break;
			case 2:
				break;
			case 3:
				break;
			}
		}else{						/*0 : 16bit*/
			agb_write_mem16(dma_dad, agb_read_mem16(dma_sad));
			switch((u8)((dma_cnt_h >> 5) & 3)){
			case 0:
				dma_sad += 2;
				break;
			case 1:
				dma_sad -= 2;
				break;
			case 3:
				dma_sad += 2;
				break;
			}
			switch((u8)((dma_cnt_h >> 7) & 3)){
			case 0:
				dma_dad += 2;
				break;
			case 1:
				dma_dad -= 2;
				break;
			}
		}
		dma_size--;
		if(!dma_size)io_dma->dma3cnt_h &= ~BIT15;
		io_dma->dma3sad   = dma_sad;
		io_dma->dma3dad	  = dma_dad;
		io_dma->dma3cnt_l = dma_size;
	}
}

