
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>


#ifndef	_FILE_C_
#define	_FILE_C_

int check_extension(char* filename)
{	/*t@CƊgqtĂΐ^*/
	unsigned int len_str;

	for(len_str = strlen(filename); len_str; len_str--){
		if(filename[len_str] == '.'){
			return 1;
		}
	}

	return 0;
}

int check_extension_name(char* filename, char* extension)
{	/*t@CƊgqv^*/
	unsigned int flen, xlen;

	flen = strlen(filename);	/*t@C̕*/
	xlen = strlen(extension);	/*gq̕*/

	if(extension[xlen] == '*')return 0;/*SẴt@C*/

	while(xlen != 0){
		if(isupper(filename[flen]))filename[flen] += 0x20;
		if(isupper(extension[xlen]))extension[xlen] += 0x20;
		if(filename[flen] != extension[xlen])return 0;
		flen--;
		xlen--;
	}

	return 1;
}

unsigned int get_file_size(char *filename)
{
	unsigned int f_start, f_end, file_size;
	FILE *fp;

	fp = fopen(filename, "rb");
	if(!fp)return 0;

	fseek(fp, 0, SEEK_END);
	f_end = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	f_start = ftell(fp);
	file_size = f_end - f_start;

	fclose(fp);

	return file_size;
}

void get_cmdline_filename(char *cmdline, char *filename)
{	/*R}hCt@C𔲂o*/
	unsigned int	i_cmd;
	int	f_dot;	/*BOOL*/

	f_dot	=	0;

	for(i_cmd = 0; cmdline[i_cmd]; i_cmd++){
		filename[i_cmd] = cmdline[i_cmd];
		if(cmdline[i_cmd] == '\"'){
			if(f_dot)break;
			else f_dot = 1;
		}
		if(cmdline[i_cmd] == ' ' && !f_dot)break;
	}

	filename[++i_cmd] = '\0';
}

int check_cmdline_flag(char *cmdline, char *flag)
{	/*R}hCXCb`̊mF*/
	int i, j;

	for(j = i = 0; cmdline[i]; i++){
		if(cmdline[i] == flag[j]){
			j++;
			if(!flag[j])return 1;
		}else{
			j = 0;
		}
	}

	return 0;
}

#endif	/*_FILE_C_*/

