
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


/*WX^ʂ̃ItZbg*/
unsigned int iotype_offset_table[8] = {
0x000,
0x060,
0x0B0,
0x100,
0x120,
0x130,
0x134,
0x200,
};


/*WXʃR{{bNXp*/
char *ioname_table[8] = {
"LCD I/O Registers",
"Sound Registers",
"DMA Transfer Channels",
"Timer Registers",
"Serial Communication (1)",
"Keypad Input",
"Serial Communication (2)",
"Interrupt, Waitstate, and Power-Down Control",
};


/*WX^ʃXg{bNXp*/
char *lcd_ioname_table[43] = {
"LCD Control",
"Undocumented - Green Swap",
"General LCD Status",
"Vertical Counter",
"BG0 Control",
"BG1 Control",
"BG2 Control",
"BG3 Control",
"BG0 X-Offset",
"BG0 Y-Offset",
"BG1 X-Offset",
"BG1 Y-Offset",
"BG2 X-Offset",
"BG2 Y-Offset",
"BG3 X-Offset",
"BG3 Y-Offset",
"BG2 Rotation/Scaling Parameter A (dx)",
"BG2 Rotation/Scaling Parameter B (dmx)",
"BG2 Rotation/Scaling Parameter C (dy)",
"BG2 Rotation/Scaling Parameter D (dmy)",
"BG2 Reference Point X-Coordinate",
"-",
"BG2 Reference Point Y-Coordinate",
"-",
"BG3 Rotation/Scaling Parameter A (dx)",
"BG3 Rotation/Scaling Parameter B (dmx)",
"BG3 Rotation/Scaling Parameter C (dy)",
"BG3 Rotation/Scaling Parameter D (dmy)",
"BG3 Reference Point X-Coordinate",
"-",
"BG3 Reference Point Y-Coordinate",
"-",
"Window 0 Horizontal Dimensions",
"Window 1 Horizontal Dimensions",
"Window 0 Vertical Dimensions",
"Window 1 Vertical Dimensions",
"Control Inside of Window(s)",
"Control Outside of Windows & Inside of OBJ Window",
"Mosaic Size",
"<Not used>",
"Color Special Effects Selection",
"Alpha Blending Coefficients",
"Brightness (Fade-In/Out) Coefficient",
};

char *_lcd_ioname_table[43] = {
"DISPCNT",
"<Not used>",
"DISPSTAT",
"VCOUNT",
"BG0CNT",
"BG1CNT",
"BG2CNT",
"BG3CNT",
"BG0HOFS",
"BG0VOFS",
"BG1HOFS",
"BG1VOFS",
"BG2HOFS",
"BG2VOFS",
"BG3HOFS",
"BG3VOFS",
"BG2PA",
"BG2PB",
"BG2PC",
"BG2PD",
"BG2PX",
"-",
"BG2PY",
"-",
"BG3PA",
"BG3PB",
"BG3PC",
"BG3PD",
"BG3PX",
"-",
"BG3PY",
"-",
"WIN0H",
"WIN1H",
"WIN0V",
"WIN1V",
"WININ",
"WINOUT",
"MOSAIC",
"<Not used>",
"BLDCNT",
"BLDALPHA",
"BLDY",
};

char *sound_ioname_table[36] = {
"Channel 1 Sweep register",
"Channel 1 Duty/Length/Envelope",
"Channel 1 Frequency/Control",
"<Not used>",
"Channel 2 Duty/Length/Envelope",
"<Not used>",
"Channel 2 Frequency/Control",
"<Not used>",
"Channel 3 Stop/Wave RAM select",
"Channel 3 Length/Volume",
"Channel 3 Frequency/Control",
"<Not used>",
"Channel 4 Length/Envelope",
"<Not used>",
"Channel 4 Frequency/Control",
"<Not used>",
"Control Stereo/Volume/Enable",
"Control Mixing/DMA Control",
"Control Sound on/off",
"<Not used>",
"Sound PWM Control",
"<Not used>",
"<Not used>",
"<Not used>",
"Channel 3 Wave Pattern RAM",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Channel A FIFO, Data 0-3",
"-",
"Channel B FIFO, Data 0-3",
"-",
};

char *_sound_ioname_table[36] = {
"SOUND1CNT_L",
"SOUND1CNT_H",
"SOUND1CNT_X",
"<Not used>",
"SOUND2CNT_L",
"<Not used>",
"SOUND2CNT_H",
"<Not used>",
"SOUND3CNT_L",
"SOUND3CNT_H",
"SOUND3CNT_X",
"<Not used>",
"SOUND4CNT_L",
"<Not used>",
"SOUND4CNT_H",
"<Not used>",
"SOUNDCNT_L",
"SOUNDCNT_H",
"SOUNDCNT_X",
"<Not used>",
"SOUNDBIAS",
"<Not used>",
"<Not used>",
"<Not used>",
"WAVE_RAM",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"FIFO_A",
"-",
"FIFO_B",
"-",
};

char *dma_ioname_table[24] = {
"DMA 0 Source Address",
"-",
"DMA 0 Destination Address",
"-",
"DMA 0 Word Count",
"DMA 0 Control",
"DMA 1 Source Address",
"-",
"DMA 1 Destination Address",
"-",
"DMA 1 Word Count",
"DMA 1 Control",
"DMA 2 Source Address",
"-",
"DMA 2 Destination Address",
"-",
"DMA 2 Word Count",
"DMA 2 Control",
"DMA 3 Source Address",
"-",
"DMA 3 Destination Address",
"-",
"DMA 3 Word Count",
"DMA 3 Control",
};

char *_dma_ioname_table[24] = {
"DMA0SAD",
"-",
"DMA0DAD",
"-",
"DMA0CNT_L",
"DMA0CNT_H",
"DMA1SAD",
"-",
"DMA1DAD",
"-",
"DMA1CNT_L",
"DMA1CNT_H ",
"DMA2SAD",
"-",
"DMA2DAD",
"-",
"DMA2CNT_L",
"DMA2CNT_H",
"DMA3SAD",
"-",
"DMA3DAD",
"-",
"DMA3CNT_L",
"DMA3CNT_H",
};

char *timer_ioname_table[8] = {
"Timer 0 Counter/Reload",
"Timer 0 Control",
"Timer 1 Counter/Reload",
"Timer 1 Control",
"Timer 2 Counter/Reload",
"Timer 2 Control",
"Timer 3 Counter/Reload",
"Timer 3 Control",
};

char *_timer_ioname_table[8] = {
"TM0CNT_L",
"TM0CNT_H",
"TM1CNT_L",
"TM1CNT_H",
"TM2CNT_L",
"TM2CNT_H",
"TM3CNT_L",
"TM3CNT_H",
};

char *sio1_ioname_table[6] = {
"SIO Data 0 (Parent)",
"SIO Data 1 (1st Child)",
"SIO Data 2 (2nd Child)",
"SIO Data 3 (3rd Child)",
"SIO Control Register",
"SIO Data",
};

char *_sio1_ioname_table[6] = {
"SIODATA32",
"SIOMULTI1",
"SIOMULTI2",
"SIOMULTI3",
"SIOCNT",
"SIOMLT_SEND",
};


char *key_ioname_table[2] = {
"Key Status",
"Key Interrupt Control",
};

char *_key_ioname_table[2] = {
"KEYINPUT",
"KEYCNT",
};

char *sio2_ioname_table[19] = {
"SIO Mode Select/General Purpose Data",
"Ancient - Infrared Register",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"SIO JOY Bus Control",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"SIO JOY Bus Receive Data",
"-",
"SIO JOY Bus Transmit Data",
"-",
"SIO JOY Bus Receive Status",
};

char *_sio2_ioname_table[19] = {
"RCNT",
"IR",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"JOYCNT",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"<Not used>",
"JOY_RECV",
"-",
"JOY_TRANS",
"-",
"JOYSTAT",
};

char *irq_ioname_table[5] = {
"Interrupt Enable Register",
"Interrupt Request Flags / IRQ Acknowledge",
"Game Pak Waitstate Control",
"<Not used>",
"Interrupt Master Enable Register",
};

char *_irq_ioname_table[5] = {
"IE",
"IF",
"WAITCNT",
"<Not used>",
"IME",
};


/*WX^rbg̏ڍ׃`FbN{bNX*/
char *notused_flag_table[16] = {
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};


char *low_flag_table[16] = {
"32 bit Data low",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *high_flag_table[16] = {
"32 bit Data high",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};


char *lcd_dispcnt_flag_table[16] = {
"BG Mode",
"-",
"-",
"Reserved for BIOS",
"Display Frame Select",
"H-Blank Interval Free",
"OBJ Character VRAM Mapping",
"Forced Blank",
"Screen Display BG0",
"Screen Display BG1",
"Screen Display BG2",
"Screen Display BG3",
"Screen Display OBJ",
"Window 0 Display Flag",
"Window 1 Display Flag",
"OBJ Window Display Flag",
};

char *lcd_dispstat_flag_table[16] = {
"V-Blank flag",
"H-Blank flag",
"V-Counter flag",
"V-Blank IRQ Enable",
"H-Blank IRQ Enable",
"V-Counter IRQ Enable",
"",
"",
"V-Count Setting",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_vcount_flag_table[16] = {
"Current scanline",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *lcd_bgcnt_flag_table[16] = {
"BG Priority",
"-",
"Character Base Block",
"-",
"<Not used> (must be zero)",
"-",
"Mosaic",
"Colors/Palettes",
"Screen Base Block",
"-",
"-",
"-",
"-",
"Display Area Overflow",
"Screen Size (0-3)",
"-",
};

char *lcd_bgscr_flag_table[16] = {
"Offset (0-511)",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
};

char *lcd_bgparam_flag_table[16] = {
"Fractional portion",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Integer portion",
"-",
"-",
"-",
"-",
"-",
"Sign",
};

char *lcd_bgpointl_flag_table[16] = {
"Fractional portion",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Integer portion",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_bgpointh_flag_table[16] = {
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Sign",
"",
"",
"",
"",
};

char *lcd_winh_flag_table[16] = {
"X2, Rightmost coordinate of window, plus 1",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"X1, Leftmost coordinate of window",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_winv_flag_table[16] = {
"Y2, Bottom-most coordinate of window, plus 1",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Y1, Top-most coordinate of window",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_winin_flag_table[16] = {
"Window 0 BG0-BG3 Enable Bits",
"-",
"-",
"-",
"Window 0 OBJ Enable Bit",
"Window 0 Color Special Effect",
"",
"",
"Window 1 BG0-BG3 Enable Bits",
"-",
"-",
"-",
"Window 1 OBJ Enable Bit",
"Window 1 Color Special Effect",
"",
"",
};

char *lcd_winout_flag_table[16] = {
"Outside BG0-BG3 Enable Bits",
"-",
"-",
"-",
"Outside OBJ Enable Bit",
"Outside Color Special Effect",
"",
"",
"OBJ Window BG0-BG3 Enable Bits",
"-",
"-",
"-",
"OBJ Window OBJ Enable Bit",
"OBJ Window Color Special Effect",
"",
"",
};

char *lcd_mosaic_flag_table[16] = {
"BG Mosaic H-Size  (minus 1)",
"-",
"-",
"-",
"BG Mosaic V-Size  (minus 1)",
"-",
"-",
"-",
"OBJ Mosaic H-Size (minus 1)",
"-",
"-",
"-",
"OBJ Mosaic V-Size (minus 1)",
"-",
"-",
"-",
};

char *lcd_bldcnt_flag_table[16] = {
"BG0 1st Target Pixel",
"BG1 1st Target Pixel",
"BG2 1st Target Pixel",
"BG3 1st Target Pixel",
"OBJ 1st Target Pixel",
"BD  1st Target Pixel",
"Color Special Effect",
"-",
"BG0 2nd Target Pixel",
"BG1 2nd Target Pixel",
"BG2 2nd Target Pixel",
"BG3 2nd Target Pixel",
"OBJ 2nd Target Pixel",
"BD  2nd Target Pixel",
"-",
"-",
};

char *lcd_bldalpha_flag_table[16] = {
"EVA Coefficient (1st Target)",
"-",
"-",
"-",
"",
"",
"",
"",
"EVB Coefficient (2nd Target)",
"-",
"-",
"-",
"",
"",
"",
"",
};

char *lcd_bldy_flag_table[16] = {
"EVY Coefficient (Brightness)",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char **lcd_flagname_table[43] = {
lcd_dispcnt_flag_table,
notused_flag_table,
lcd_dispstat_flag_table,
lcd_vcount_flag_table,

lcd_bgcnt_flag_table,
lcd_bgcnt_flag_table,
lcd_bgcnt_flag_table,
lcd_bgcnt_flag_table,

lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,
lcd_bgscr_flag_table,

lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,

lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,
lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,

lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,
lcd_bgparam_flag_table,

lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,
lcd_bgpointl_flag_table,
lcd_bgpointh_flag_table,

lcd_winh_flag_table,
lcd_winh_flag_table,

lcd_winv_flag_table,
lcd_winv_flag_table,

lcd_winin_flag_table,
lcd_winout_flag_table,

lcd_mosaic_flag_table,
notused_flag_table,
lcd_bldcnt_flag_table,
lcd_bldalpha_flag_table,
lcd_bldy_flag_table,
};


char *sound_sg10l_flag_table[16] = {
"Number of sweep shift",
"-",
"-",
"Sweep Frequency Direction",
"Sweep Time; units of 7.8ms",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sound_sg10h_flag_table[16] = {
"Sound length",
"-",
"-",
"-",
"-",
"-",
"Wave Pattern Duty",
"-",
"Envelope Step-Time",
"-",
"-",
"Envelope Direction",
"Initial Volume of envelope",
"",
"",
"",
};

char *sound_sg11_flag_table[16] = {
"Frequency",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"Length Flag",
"Initial",
};

char *sound_sg30l_flag_table[16] = {
"",
"",
"",
"",
"",
"Wave RAM Bank Number",
"Wave RAM Dimension",
"Sound Channel 3 Off",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sound_sg30h_flag_table[16] = {
"Sound length",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"Sound Volume",
"-",
"Force Volume",
};

char *sound_sgcnt0l_flag_table[16] = {
"Sound 1-4 Master volume RIGHT",
"-",
"-",
"",
"Sound 1-4 Master Volume LEFT",
"-",
"-",
"",
"Sound 1-4 Enable Flags RIGHT",
"-",
"-",
"-",
"Sound 1-4 Enable Flags LEFT",
"-",
"-",
"-",
};

char *sound_sgcnt0h_flag_table[16] = {
"Sound # 1-4 Volume",
"-",
"DMA Sound A Volume",
"DMA Sound B Volume",
"",
"",
"",
"",
"DMA Sound A Enable RIGHT",
"DMA Sound A Enable LEFT",
"DMA Sound A Timer Select",
"DMA Sound A Reset FIFO",
"DMA Sound B Enable RIGHT",
"DMA Sound B Enable LEFT",
"DMA Sound B Timer Select",
"DMA Sound B Reset FIFO",
};

char *sound_sgcnt1_flag_table[16] = {
"Sound 1 ON flag",
"Sound 2 ON flag",
"Sound 3 ON flag",
"Sound 4 ON flag",
"",
"",
"",
"All sound on/off",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sound_sgbias_flag_table[16] = {
"Bias Level",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"Amplitude Resolution/Sampling Cycle",
"-",
};

char *sound_sgwr_flag_table[16] = {
"Channel 3 Wave Pattern",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *sound_sgfifo_flag_table[16] = {
"Sound FIFO, Data",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char **sound_flagname_table[39] = {
sound_sg10l_flag_table,/*60h*/
sound_sg10h_flag_table,
sound_sg11_flag_table,

notused_flag_table,
sound_sg10h_flag_table,
notused_flag_table,
sound_sg11_flag_table,
notused_flag_table,

sound_sg30l_flag_table,/*70h*/
sound_sg30h_flag_table,
sound_sg11_flag_table,

notused_flag_table,
sound_sg10h_flag_table,
notused_flag_table,
sound_sg11_flag_table,
notused_flag_table,

sound_sgcnt0l_flag_table,/*80h*/
sound_sgcnt0h_flag_table,
sound_sgcnt1_flag_table,
notused_flag_table,

sound_sgbias_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,

sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,
sound_sgwr_flag_table,

sound_sgfifo_flag_table,
sound_sgfifo_flag_table,
sound_sgfifo_flag_table,
sound_sgfifo_flag_table,
};


char *dma_adl_flag_table[16] = {
"Address, lower 16bit data ",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *dma_adh_flag_table[16] = {
"Address, upper 16bit data",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *dma_count_flag_table[16] = {
"Word Count",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
};

char *dma_count3_flag_table[16] = {
"Word Count",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *dma_cnt_flag_table[16] = {
"",
"",
"",
"",
"",
"Dest Addr Control",
"-",
"Source Adr Control",
"-",
"DMA Repeat",
"DMA Transfer Type",
"Game Pak DRQ  - DMA3 only -",
"DMA Start Timing",
"-",
"IRQ upon end of Word Count",
"DMA Enable",
};

char **dma_flagname_table[24] = {
dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count_flag_table,
dma_cnt_flag_table,

dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count_flag_table,
dma_cnt_flag_table,

dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count_flag_table,
dma_cnt_flag_table,

dma_adl_flag_table,
dma_adh_flag_table,
dma_adl_flag_table,
dma_adh_flag_table,
dma_count3_flag_table,
dma_cnt_flag_table,
};


char *tm_counter_flag_table[16] = {
"Count",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *tm_cnt_flag_table[16] = {
"Prescaler Selection",
"-",
"Count-up Timing",
"",
"",
"",
"Timer IRQ Enable",
"Timer Start/Stop",
"",
"",
"",
"",
"",
"",
"",
"",
};

char **tm_flagname_table[8] = {
tm_counter_flag_table,
tm_cnt_flag_table,
tm_counter_flag_table,
tm_cnt_flag_table,
tm_counter_flag_table,
tm_cnt_flag_table,
tm_counter_flag_table,
tm_cnt_flag_table,
};


char *sio1_scd_flag_table[16] = {
"16bit data",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *sio1_sccntl_flag_table[16] = {
"Shift Clock",
"Internal Shift Clock",
"SI State (opponents SO)",
"SO during inactivity",
"",
"",
"",
"Start Bit",
"",
"",
"",
"",
"Transfer Length",
"Must be 0 for Normal Mode",
"IRQ Enable",
"",
};

char **sio1_flagname_table[9] = {
sio1_scd_flag_table,
sio1_scd_flag_table,

sio1_scd_flag_table,
sio1_scd_flag_table,
sio1_scd_flag_table,
sio1_scd_flag_table,

sio1_sccntl_flag_table,

sio1_scd_flag_table,
sio1_scd_flag_table,
};


char *key_p1_flag_table[16] = {
"Button A",
"Button B",
"Select",
"Start",
"Right",
"Left",
"Up",
"Down",
"Button R",
"Button L",
"",
"",
"",
"",
"",
"",
};

char *key_p1cnt_flag_table[16] = {
"Button A",
"Button B",
"Select",
"Start",
"Right",
"Left",
"Up",
"Down",
"Button R",
"Button L",
"",
"",
"",
"",
"IRQ Enable Flag",
"IRQ Condition",
};

char **key_flagname_table[2] = {
key_p1_flag_table,
key_p1cnt_flag_table,
};


char *sio2_rcnt_flag_table[16] = {
"SC Data Bit",
"SD Data Bit",
"SI Data Bit",
"SO Data Bit",
"SC Direction",
"SD Direction",
"SI Direction",
"SO Direction",
"Interrupt Request",
"",
"",
"",
"",
"",
"Must be 0 for General-Purpose Mode",
"Must be 1 for General-Purpose or JOYBUS Mode",
};

char *sio2_ir_flag_table[16] = {
"Transmission Data",
"READ Enable",
"Reception Data",
"AMP Operation",
"IRQ Enable Flag",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"Must be 1 for JOY BUS Mode",
};

char *sio2_hsctrl_flag_table[16] = {
"Device Reset Flag",
"Receive Complete Flag",
"Send Complete Flag",
"",
"",
"",
"IRQ when receiving a Device Reset Command",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *sio2_stat_flag_table[16] = {
"",
"Receive Status Flag",
"",
"Send Status Flag",
"General Purpose Flag",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"Must be 1 for JOY BUS Mode",
};

char **sio2_flagname_table[19] = {
sio2_rcnt_flag_table,
sio2_ir_flag_table,

notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,

sio2_hsctrl_flag_table,

notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,
notused_flag_table,

low_flag_table,
high_flag_table,
low_flag_table,
high_flag_table,
sio2_stat_flag_table
};


char *irq_ie_flag_table[16] = {
"LCD V-Blank",
"LCD H-Blank",
"LCD V-Counter Match",
"Timer 0 Overflow",
"Timer 1 Overflow",
"Timer 2 Overflow",
"Timer 3 Overflow",
"Serial Communication",
"DMA 0",
"DMA 1",
"DMA 2",
"DMA 3",
"Keypad",
"Game Pak (external IRQ source)",
"",
"",
};

char *irq_wscnt_flag_table[16] = {
"SRAM Wait Control",
"-",
"Wait State 0 First Access",
"-",
"Wait State 0 Second Access",
"Wait State 1 First Access",
"-",
"Wait State 1 Second Access",
"Wait State 2 First Access",
"-",
"Wait State 2 Second Access",
"PHI Terminal Output",
"-",
"",
"Game Pak Prefetch Buffer",
"Game Pak Type Flag",
};

char *irq_ime_flag_table[16] = {
"Disable all interrupts",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char **irq_flagname_table[6] = {
irq_ie_flag_table,
irq_ie_flag_table,
irq_wscnt_flag_table,
notused_flag_table,
irq_ime_flag_table,
notused_flag_table,
};
