

/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


#ifdef	_AGBWIN32_
void CMainFrame::agb_mainloop()
#else
void agb_mainloop()
#endif	/*_AGBWIN32_*/
//void AGB_MAINLOOP()
{
	static s32	htime;
	static u32	wait_time;
	static u16	temp_vcount, temp_dispstat;

	fTMain = TRUE;

	do{

		temp_vcount		= io_lcd->vcount;
		temp_dispstat	= io_lcd->dispstat;

		if(ARM_CPSR & ARM_T){
			exec_thumb_state();
		}else{
			exec_arm_state();
		}

		//agb_timer(arm.cycle);
		agb_dma_transfer();

#ifdef	_AGBWIN32_
		if(fBreak){	/*u[N|Cg*/
			if(BreakPoint1 == ARM_PC || BreakPoint2 == ARM_PC || 
				BreakPoint3 == ARM_PC || BreakPoint4 == ARM_PC){
				arm.running = FALSE;
				SetWindowText(_TITLE_" - Break!!!!!!!!!!!!!");
				char str[128];
				sprintf(str, "Stop at break point \"%Xh\".\n", ARM_PC);
				console_print(str);
			}
		}
#endif	/*_AGBWIN32_*/

		htime -= arm.cycle;
		if(htime <= 272){	/*A*/
			if(!(temp_dispstat & BIT1)){
				temp_dispstat |= BIT1;
				if(temp_dispstat & BIT4)agb_interrupt(IRQ_HBLANK);
			}
			if(htime <= 0){	/* (16.78MHz/59.73)/228line */
				htime += 1232;
				if(temp_vcount < 160){
					if(frame_rate >= frame_skip){
						agb_draw_line(temp_vcount);
					}
				}
				if(temp_vcount >= 228){	/* 16.78MHz/59.73  */
					temp_vcount = 0;
					frame_rate++;
					if(frame_rate > frame_skip){
						agb_draw_lcd();
						frame_rate = 0;
					}
					frame_count++;
#ifdef	_AGBWIN32_API_
				MSG  msg;
				if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)){
					if(!GetMessage(&msg, NULL, 0, 0))
						arm.running = FALSE;
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
#endif	/*_AGBWIN32_API_*/
#ifdef	_AGBWIN32_
					if(fFps)ShowFps();
					if(fAutoUpdate)UpdateDebugger();
#endif	/*_AGBWIN32_*/
					if(fVsync)while(wait_time > timeGetTime())Sleep(1);
					wait_time = timeGetTime() + 17;
				}else{
					temp_vcount++;
					if((temp_dispstat >> 8) == temp_vcount){	/*LYC*/
						if(!(temp_dispstat & BIT2)){
							temp_dispstat |= BIT2;
							if(temp_dispstat & BIT5)agb_interrupt(IRQ_VCOUNT);
						}
					}else{
						if(temp_dispstat & BIT2)temp_dispstat &= ~BIT2;		
					}
				}
				if(temp_vcount >= 160){	/*A (228-160=68lines)*/
					if(!(temp_dispstat & BIT0)){
						temp_dispstat |= BIT0;	/*AJn*/
						if(temp_dispstat & BIT3)agb_interrupt(IRQ_VBLANK);
					}
				}else{
					if(temp_dispstat & BIT0)temp_dispstat &= ~BIT0;		
				}
			}
		}else{
			if(temp_dispstat & BIT1)temp_dispstat &= ~BIT1;
		}

		io_lcd->vcount		= temp_vcount;
		io_lcd->dispstat	= temp_dispstat;

	}while(arm.running);

	fTMain = FALSE;
#ifdef	_AGBWIN32_
	if(fAutoUpdate)UpdateDebugger();
	agb_draw_lcd();
#endif	/*_AGBWIN32_*/
}

void agb_initialize_register()
{
	u32 i;

	console_print("agb_initialize_register\n");

	for(i = 0; i < 17; i++)arm.reg_ptr[i] = &arm.reg[i];

	ARM_R0	=	0x00000000;
	ARM_R1	=	0x00000000;
	ARM_R2	=	0x00000000;
	ARM_R3	=	0x00000000;
	ARM_R4	=	0x00000000;
	ARM_R5	=	0x00000000;
	ARM_R6	=	0x00000000;
	ARM_R7	=	0x00000000;
	ARM_R8	=	0x00000000;
	ARM_R9	=	0x00000000;
	ARM_R10	=	0x00000000;
	ARM_R11	=	0x00000000;
	ARM_R12	=	0x00000000;
	ARM_R13	=	0x03007F00;	/*R13==SR X^bN|C^*/
	ARM_R14	=	0x00000000;	/*R14==LR NWX^(߂)*/
	ARM_R15	=	fEnableBios?0x00000000:0x08000000;	/*R15==PC vO|C^*/
	ARM_R16	=	0x0000001F;	/*R16==CPSR Xe[^XWX^*/
}


void arm7tdmi_set_cpu_state(u32 mode)
{
	switch(mode){
	case ARM_MODE_USR:
		arm.reg_ptr[8] = &arm.reg[8];
		arm.reg_ptr[9] = &arm.reg[9];
		arm.reg_ptr[10] = &arm.reg[10];
		arm.reg_ptr[11] = &arm.reg[11];
		arm.reg_ptr[12] = &arm.reg[12];
		arm.reg_ptr[13] = &arm.reg[13];
		arm.reg_ptr[14] = &arm.reg[14];
		arm.reg_ptr[16] = &arm.reg[16];
		break;
	case ARM_MODE_FIQ:
		arm.reg_ptr[8] = &arm.reg_fiq[0];
		arm.reg_ptr[9] = &arm.reg_fiq[1];
		arm.reg_ptr[10] = &arm.reg_fiq[2];
		arm.reg_ptr[11] = &arm.reg_fiq[3];
		arm.reg_ptr[12] = &arm.reg_fiq[4];
		arm.reg_ptr[13] = &arm.reg_fiq[5];
		arm.reg_ptr[14] = &arm.reg_fiq[6];
		arm.reg_ptr[16] = &arm.reg_fiq[7];
		break;
	case ARM_MODE_SVC:
		arm.reg_ptr[13] = &arm.reg_svc[0];
		arm.reg_ptr[14] = &arm.reg_svc[1];
		arm.reg_ptr[16] = &arm.reg_svc[2];
		break;
	case ARM_MODE_ABT:
		arm.reg_ptr[13] = &arm.reg_abt[0];
		arm.reg_ptr[14] = &arm.reg_abt[1];
		arm.reg_ptr[16] = &arm.reg_abt[2];
		break;
	case ARM_MODE_IRQ:
		arm.reg_ptr[13] = &arm.reg_irq[0];
		arm.reg_ptr[14] = &arm.reg_irq[1];
		arm.reg_ptr[16] = &arm.reg_irq[2];
		break;
	case ARM_MODE_UND:
		arm.reg_ptr[13] = &arm.reg_und[0];
		arm.reg_ptr[14] = &arm.reg_und[1];
		arm.reg_ptr[16] = &arm.reg_und[2];
		break;
	
	}
}
