
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


#ifdef	__cplusplus
//extern "C" {
#endif	/*__cplusplus*/

u8	agb_read_mem8(u32 adr);
u16	agb_read_mem16(u32 adr);
u32	agb_read_mem32(u32 adr);

#ifdef	__cplusplus
//}
#endif	/*__cplusplus*/


void agb_initialize_memory()
{
	console_print("agb_initialize_memory\n");

	memset(agb_vram, 0, AGB_SIZE_VRAM);
	memset(agb_inram, 0, AGB_SIZE_INRAM);

	io_lcd = (AGBIOLCD*)&agb_ioram[0x000];
	io_dma = (AGBIODMA*)&agb_ioram[0x0B0];
	io_tm  = (AGBIOTM*)&agb_ioram[0x100];
	io_key = (AGBIOKEY*)&agb_ioram[0x130];
	io_irq = (AGBIOIRQ*)&agb_ioram[0x200];

	io_key->keyinput		=	0xFFFF;
}

u8 agb_read_mem8(u32 adr)
{
	if(/*0x00000000 <= adr && */adr < 0x00004000)return agb_sysrom[adr];
	if(0x02000000 <= adr && adr < 0x02040000)return agb_exram[adr - 0x02000000];
	if(0x03000000 <= adr && adr < 0x03008000)return agb_inram[adr - 0x03000000];
	if(0x04000000 <= adr && adr < 0x04000400)return agb_ioram[adr - 0x04000000];
	if(0x05000000 <= adr && adr < 0x05000400)return agb_palram[adr - 0x05000000];
	if(0x06000000 <= adr && adr < 0x06018000)return agb_vram[adr - 0x06000000];
	if(0x07000000 <= adr && adr < 0x07000400)return agb_oam[adr - 0x07000000];
	if(0x08000000 <= adr && adr < (0x08000000 + file_size))return agb_rom[adr - 0x08000000];

	return 0;
}

u16 agb_read_mem16(u32 adr)
{
	u16	*word_ptr;

	if(/*0x00000000 <= adr && */adr < 0x00004000)
	{
		word_ptr = (u16*)&agb_sysrom[adr];
		return *word_ptr;
	}
	if(0x02000000 <= adr && adr < 0x02040000)
	{
		adr -= 0x02000000;
		word_ptr = (u16*)&agb_exram[adr];
		return *word_ptr;
	}
	if(0x03000000 <= adr && adr < 0x03008000)
	{
		adr -= 0x03000000;
		word_ptr = (u16*)&agb_inram[adr];
		return *word_ptr;
	}
	if(0x04000000 <= adr && adr < 0x04000400)
	{
		adr -= 0x04000000;
		word_ptr = (u16*)&agb_ioram[adr];
		return *word_ptr;
	}
	if(0x05000000 <= adr && adr < 0x05000400)
	{
		adr -= 0x05000000;
		word_ptr = (u16*)&agb_palram[adr];
		return *word_ptr;
	}
	if(0x06000000 <= adr && adr < 0x06018000)
	{
		adr -= 0x06000000;
		word_ptr = (u16*)&agb_vram[adr];
		return *word_ptr;
	}
	if(0x07000000 <= adr && adr < 0x07000400)
	{
		adr -= 0x07000000;
		word_ptr = (u16*)&agb_oam[adr];
		return *word_ptr;
	}
	if(0x08000000 <= adr && adr < (0x08000000 + file_size)){
		adr -= 0x08000000;
		word_ptr = (u16*)&agb_rom[adr];
		return *word_ptr;
	}

	return 0;
}

u32 agb_read_mem32(u32 adr)
{
	u32	*dword_ptr;

	if(/*0x00000000 <= adr && */adr < 0x00004000){
		dword_ptr = (u32*)&agb_sysrom[adr];
		return *dword_ptr;
	}
	if(0x02000000 <= adr && adr < 0x02040000){
		adr -= 0x02000000;
		dword_ptr = (u32*)&agb_exram[adr];
		return *dword_ptr;
	}
	if(0x03000000 <= adr && adr < 0x03008000){
		adr -= 0x03000000;
		dword_ptr = (u32*)&agb_inram[adr];
		return *dword_ptr;
	}
	if(0x04000000 <= adr && adr < 0x04000400){
		adr -= 0x04000000;
		dword_ptr = (u32*)&agb_ioram[adr];
		return *dword_ptr;
	}
	if(0x05000000 <= adr && adr < 0x05000400){
		adr -= 0x05000000;
		dword_ptr = (u32*)&agb_palram[adr];
		return *dword_ptr;
	}
	if(0x06000000 <= adr && adr < 0x06018000){
		adr -= 0x06000000;
		dword_ptr = (u32*)&agb_vram[adr];
		return *dword_ptr;
	}
	if(0x07000000 <= adr && adr < 0x07000400){
		adr -= 0x07000000;
		dword_ptr = (u32*)&agb_oam[adr];
		return *dword_ptr;
	}
	if(0x08000000 <= adr && adr < (0x08000000 + file_size)){
		adr -= 0x08000000;
		dword_ptr = (u32*)&agb_rom[adr];
		return *dword_ptr;
	}

	return 0;
}

inline int agb_write_mem8(u32 adr, u8 val)
{
	if(0x02000000 <= adr && adr < 0x02040000){
		agb_exram[adr - 0x02000000]	= val;
		return 0;
	}
	if(0x03000000 <= adr && adr < 0x03008000){
		agb_inram[adr - 0x03000000]	= val;
		return 0;
	}
	if(0x04000000 <= adr && adr < 0x04000400){
		agb_ioram[adr - 0x04000000]	= val;
		/*DMA0,1,2,3̓]JntO*/
#ifdef	_AGBWIN32_
		char str[256];
		if(adr==(REG_DM0CNT_H + 1)){
			if(val & BIT7){
				sprintf(str, "DMA0 [%08Xh]=>[%08Xh], count=%Xh(*%dbit)\n", 
						io_dma->dma0sad & 0x0FFFFFFF, 
						io_dma->dma0dad & 0x07FFFFFF, 
						io_dma->dma0cnt_l, 
						(io_dma->dma0cnt_h & BIT10)?32:16);
				console_print(str);
			}
		}
		if(adr==(REG_DM1CNT_H + 1)){
			if(val & BIT7){
				sprintf(str, "DMA1 [%08Xh]=>[%08Xh], count=%Xh(*%dbit)\n", 
						io_dma->dma1sad & 0x0FFFFFFF, 
						io_dma->dma1dad & 0x07FFFFFF, 
						io_dma->dma1cnt_l, 
						(io_dma->dma1cnt_h & BIT10)?32:16);
				console_print(str);
			}
		}
		if(adr==(REG_DM2CNT_H + 1)){
			if(val & BIT7){
				sprintf(str, "DMA2 [%08Xh]=>[%08Xh], count=%Xh(*%dbit)\n", 
						io_dma->dma2sad & 0x0FFFFFFF, 
						io_dma->dma2dad & 0x07FFFFFF, 
						io_dma->dma2cnt_l, 
						(io_dma->dma2cnt_h & BIT10)?32:16);
				console_print(str);
			}
		}
		if(adr==(REG_DM3CNT_H + 1)){
			if(val & BIT7){
				sprintf(str, "DMA3 [%08Xh]=>[%08Xh], count=%Xh(*%dbit)\n", 
						io_dma->dma3sad & 0x0FFFFFFF, 
						io_dma->dma3dad & 0x07FFFFFF, 
						io_dma->dma3cnt_l, 
						(io_dma->dma3cnt_h & BIT10)?32:16);
				console_print(str);
			}
		}
#endif	/*_AGBWIN32_*/
		return 0;
	}
	if(0x05000000 <= adr && adr < 0x05000400){
		agb_palram[adr - 0x05000000]	= val;
		return 0;
	}
	if(0x06000000 <= adr && adr < 0x06018000){
		agb_vram[adr - 0x06000000]		= val;
		return 0;
	}
	if(0x07000000 <= adr && adr < 0x07000400){
		agb_oam[adr - 0x07000000]		= val;
		return 0;
	}

	return 1;
}

void agb_write_mem16(u32 adr, u16 val)
{
 	agb_write_mem8(adr++, (u8)val);
	agb_write_mem8(adr, (u8)(val >> 8));
}

_inline void agb_write_mem32(u32 adr, u32 val)
{
#ifdef	_AGBWIN32_
	u32	i;
	char str[256];

	/*Mappy`dprint*/
	if(adr==0xC0DED00D){
		if(!(agb_read_mem32(arm.reg[15] + 4) & ~0xF0000000)){	/*nop*/
			memset(str, 0, 256);
			for(i = 0; agb_read_mem8(val); i++)str[i] = agb_read_mem8(val++);
			console_print(str);
		}
	}
#endif	/*_AGBWIN32_*/

	agb_write_mem8(adr++, (u8)val);
	agb_write_mem8(adr++, (u8)(val >> 8));
	agb_write_mem8(adr++, (u8)(val >> 16));
	agb_write_mem8(adr, (u8)(val >> 24));
}
