
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


#include <stdio.h>

#include "../zlib/unzip.h"


int agb_close_rom(unsigned char *pMem)
{
	if(agb_rom!=NULL){
		console_print("agb_close_rom\n");
		free(agb_rom);
		return 0;
	}

	return 1;
}

int agb_open_bios(char *filename)
{
	FILE *fp;

	fp = fopen(filename, "rb");
	if(!fp)return 0;

	console_print("Loading Bios file.\n");
	console_print(filename);
	console_print("\n");
	fread(agb_sysrom, 1, 1024 * 16, fp);
	fclose(fp);

	return 1;
}

int agb_open_rom(char *filename, unsigned char *pMem, unsigned int *size)
{
	unsigned int f_start, f_end;
	FILE *fp;

	console_print("Loading cartridge.");
	console_print(filename);
	console_print("\n");

	fp = fopen(filename, "rb");
	if(fp==NULL)return 1;

	fseek(fp, 0, SEEK_END);
	f_end = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	f_start = ftell(fp);
	*size = f_end - f_start;

	agb_close_rom(pMem);

	agb_rom = (unsigned char*)malloc(*size + 1);
	if(agb_rom==NULL)return 2;
	
	fread(agb_rom, 1, *size, fp);

	fclose(fp);

	return 0;
}


#ifdef	_AGBWIN32_

int agb_open_ziprom(char* filename, unsigned char *pMem, unsigned int *size)
{	/*ZIPt@CROM̓ǂݍ݂ƃ̊m*/	
	unsigned int	sizeRead;
	int		err;
	char	strConFilename[512];
	char*	pConFileName, *p;
	unzFile	hUnzipFile;
	unz_file_info	fileInfo;

	console_print("Loading cartridge.(zip compressed)");
	console_print(filename);
	console_print("\n");

	hUnzipFile = NULL;

	hUnzipFile = unzOpen(filename, 0);
	if(hUnzipFile == NULL)return FALSE;

	do{
		err = unzGetCurrentFileInfo(hUnzipFile, &fileInfo, strConFilename, 
									sizeof(strConFilename), NULL, 0, NULL, 0);
		if(err!=UNZ_OK){
			unzClose(hUnzipFile);
			return 1;	/*ZIPt@C*/
		}

		p = pConFileName = strConFilename;	/*t@Co*/
		while(*p!='\0'){
			if (*p=='\\' ||*p=='/')pConFileName=p+1;
			p++;
		}

		if(is_agb_filename(strConFilename)){	/*GBt@Cgq̔*/
			console_print("Uncompressing cartridge.");
			console_print(strConFilename);
			console_print("\n");
			if(unzOpenCurrentFile(hUnzipFile)!=UNZ_OK){
				unzClose(hUnzipFile);
				return 2;	/*w肳ꂽt@CĂ*/
			}
			agb_close_rom(pMem);
			agb_rom = (u8*)malloc(fileInfo.uncompressed_size + 1);
			if(agb_rom==NULL)return 2;
			sizeRead = unzReadCurrentFile(hUnzipFile, (void*)agb_rom, fileInfo.uncompressed_size);
			if(sizeRead!=fileInfo.uncompressed_size)return 4;
			*size = fileInfo.uncompressed_size;
		}

		unzCloseCurrentFile(hUnzipFile);

		if(is_agb_filename(strConFilename))break;/*ROMt@Cǂ񂾂I*/

	}while(unzGoToNextFile(hUnzipFile) != UNZ_END_OF_LIST_OF_FILE);

	unzClose(hUnzipFile);

	return 0;
}

#endif	/*_AGBWIN32_*/

