
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#include "../include/bits.h"

extern u32 agb_obj_size_table[4][4][2];

void agb_draw_sprite(u16 *dest_ptr, u32 bitmap_mode)
{
	u32 map_x, map_y, obj_x, obj_y, index_offset;
	u32	obj_size_x, obj_size_y, obj_pos_x, obj_pos_y;
	u32	obj_number, obj_offset, obj_index;
	u32	temp_index, buf_offset;
	u16 *palette, *word_oam;
	u16	oam0, oam1, color16;

//	for(obj_index=0; obj_index < (bitmap_mode?1:128); obj_index++){
	for(obj_index=0; obj_index < 128; obj_index++){
		palette = (u16*)agb_palram;
		palette += 256;
		word_oam = (u16*)agb_oam;
		oam0 = word_oam[obj_index * 4];
		oam1 = word_oam[obj_index * 4 + 1];
		obj_pos_x = oam1 & 0x1FF;
		obj_pos_y = oam0 & 0xFF;
		obj_number = word_oam[obj_index * 4 + 2] & 0x3FF;
		obj_size_x = agb_obj_size_table[oam0>>14][oam1>>14][0];
		obj_size_y = agb_obj_size_table[oam0>>14][oam1>>14][1];
//		index_offset = (bitmap_mode?0x14000:0x10000) + (obj_number * 32);
		index_offset = 0x10000 + (obj_number * 32);
		obj_size_x >>= 3;/*^CCfbNXɕύX*/
		obj_size_y >>= 3;
		obj_offset = 0;
		for(map_y = 0; map_y < obj_size_y; map_y++){
			for(map_x = 0; map_x < obj_size_x; map_x++, obj_offset++){
				for(obj_y = 0; obj_y < 8; obj_y++){
					for(obj_x = 0; obj_x < 8; obj_x++){
						temp_index = agb_vram[obj_offset * 64 + obj_x + obj_y * 8 + index_offset];
						buf_offset = obj_pos_x + obj_pos_y * 240 + map_x * 8 + map_y * 8 * 240 + obj_x + obj_y * 240;
						if(temp_index && (buf_offset < (240 * 160))){
							color16 = palette[temp_index];
							dest_ptr[buf_offset] = SWAP_RB(color16);
						}
					}
				}
			}
		}
	}
}

void agb_draw_mode0_bg(u16 *dest_ptr, u32 bg)
{	/*mode 0 ^C*/
	u32	map_x, map_y, tile_x, tile_y;
	u32	base_char, base_map;
	u16	temp16;
	u16	*bgcnt;
	u16 *ppal16;
	u8	*char_ram;
	u32	map_offset;

	bgcnt = &io_lcd->bg0cnt;
	bgcnt += bg;

	ppal16	= (u16*)agb_palram;
	base_char = ((*bgcnt >> 2) & 3) << 14;	/*16KBP*/
	base_map = ((*bgcnt >> 8) & 0x1F) << 11;	/*2KBP*/
	for(map_y = 0; map_y < 20; map_y++){
		for(map_x = 0; map_x < 30; map_x++){
			map_offset = agb_vram[base_map + (map_x + map_y * ((*bgcnt & BIT14)?64:32)) * 2];
			char_ram = &agb_vram[map_offset * 64 + base_char];
			for(tile_y = 0; tile_y < 8; tile_y++){
				for(tile_x = 0; tile_x < 8; tile_x++){
					if(*char_ram){
						temp16 = ppal16[*char_ram++];
						dest_ptr[tile_x + map_x*8 + (tile_y + map_y*8) * AGB_LCD_X] = SWAP_RB(temp16);
					}
				}
			}
		}
	}
}

void agb_draw_mode3_bg(u16 *dest_ptr)
{	/*mode 3 rbg}bv*/
	u32 i;
	u16	temp16;
	u16 *word_ptr;

	word_ptr = (u16*)agb_vram;
	for(i = 0; i < AGB_LCD_SIZE; i++){
		temp16 = *word_ptr++;
		*dest_ptr++ = SWAP_RB(temp16);
	}
}

void agb_draw_mode4_bg(u16 *dest_ptr)
{	/*mode 4 pbg*/
	u32 i;
	u16	temp16;
	u16 *ppal16;
	u8	*vram;

	ppal16 = (u16*)agb_palram;
	vram = agb_vram;
	if(io_lcd->dispcnt & BIT4)vram += AGB_LCD_SIZE;	/*obNobt@̑I*/
	for(i = 0; i < AGB_LCD_SIZE; i++){
		temp16 = ppal16[*vram++];
		*dest_ptr++ = SWAP_RB(temp16);
	}
}

void agb_draw_mode5_bg(u16 *dest_ptr)
{	/*mode 5 rbg}bv*/
	s32 x, y;
	u16	temp16;
	u16 *pvram16;

	pvram16 = (u16*)agb_vram;
	if(io_lcd->dispcnt & BIT4)pvram16 += AGB_LCD_MODE5_X * AGB_LCD_MODE5_Y;	/*obNobt@̑I*/
	for(y = 0; y < AGB_LCD_MODE5_Y; y++){
		for(x = 0; x < AGB_LCD_MODE5_X; x++){
			temp16 = *pvram16++;
			*dest_ptr++ = SWAP_RB(temp16);
		}
		dest_ptr += AGB_LCD_X - AGB_LCD_MODE5_X;
	}
}
