
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#include <stdio.h>
#include "../include/defines.h"
#include "../include/externs.h"


void agb_draw_line_sprite(u32 scanline, u32 bitmap_mode)
{
	u32 map_x, map_y, obj_x, obj_y, index_offset;
	u32	obj_size_x, obj_size_y, obj_pos_x, obj_pos_y;
	u32	obj_number, obj_offset;
	u32	temp_index, buf_offset;
	u32	temp32;
	s32	obj_index;
	u16 *palette, *word_oam;
	u16	oam0, oam1;

	for(obj_index = 0; obj_index < 128; obj_index++){
//	for(obj_index = 127; obj_index >= 0; obj_index--){
		obj_y		= scanline & 7;
		map_y		= scanline >> 3;
		palette		= (u16*)agb_palram;
		palette		+= 256;
		word_oam	= (u16*)agb_oam;
		oam0		= word_oam[obj_index << 2];
		oam1		= word_oam[(obj_index << 2) + 1];
		obj_pos_x	= oam1 & 0x1FF;
		obj_pos_y	= oam0 & 0xFF;
		obj_number	= word_oam[(obj_index << 2) + 2] & 0x3FF;
		obj_size_x	= agb_obj_size_table[oam0 >> 14][oam1 >> 14][0];
		obj_size_y	= agb_obj_size_table[oam0 >> 14][oam1 >> 14][1];
		index_offset = 0x10000 + (obj_number << 5);
		obj_size_x >>= 3;	/*^CCfbNXɕύX*/
		obj_size_y >>= 3;
		obj_offset = map_y << 2;
		for(map_x = 0; map_x < obj_size_x; map_x++){
			for(obj_x = 0; obj_x < 8; obj_x++){
				temp_index	= agb_vram[(obj_offset << 6) + obj_x + (obj_y << 3) + index_offset];
				buf_offset	= obj_pos_x + obj_pos_y * AGB_LCD_X + (map_x << 3) + (map_y << 3) * AGB_LCD_X + obj_x + obj_y * AGB_LCD_X;
				if(temp_index && (buf_offset < AGB_LCD_SIZE)){
					temp32 = palette[temp_index];
					FrameBuffer[buf_offset] = SWAP_RB(temp32);
				}
			}
			obj_offset++;
		}
	}
}

void agb_draw_line_mode0_bg(u32 scanline, u32 bg)
{	/*mode 0 ^C*/
	u32	map_x, map_y, tile_x, tile_y;
	u32	base_char, base_map;
	u32	temp32;
	u16	*bgcnt;
	u16 *ppal16;
	u8	*char_ram;
	u32	map_offset;

	tile_y		= scanline & 7;
	map_y		= scanline >> 3;
	bgcnt		= &io_lcd->bg0cnt;
	bgcnt		+= bg;
	ppal16		= (u16*)agb_palram;
	base_char	= ((*bgcnt>>2) & 3) << 14;	/*16KBP*/
	base_map	= ((*bgcnt>>8) & 0x1F) << 11;	/*2KBP*/

	for(map_x = 0; map_x < 30; map_x++){
		map_offset	= agb_vram[base_map + ((map_x + (map_y << ((*bgcnt & BIT14)?6:5))) << 1)];
		char_ram	= &agb_vram[(map_offset << 6) + base_char];
		char_ram	+= tile_y << 3;
		for(tile_x = 0; tile_x < 8; tile_x++){
			if(*char_ram){
				temp32 = ppal16[*char_ram++];
				FrameBuffer[tile_x + (map_x << 3) + (tile_y + (map_y << 3)) * AGB_LCD_X] = SWAP_RB(temp32);
			}
		}
	}
}

void agb_draw_line_mode3_bg(u32 scanline)
{	/*mode 3 rbg}bv*/
	u32 i, temp32;
	u16 *src_ptr, *dest_ptr;

	src_ptr = (u16*)agb_vram;
	src_ptr = &src_ptr[scanline * AGB_LCD_X];
	dest_ptr= &FrameBuffer[scanline * AGB_LCD_X];
	for(i = 0; i < AGB_LCD_X; i++){
		temp32 = *src_ptr++;
		*dest_ptr++ = SWAP_RB(temp32);
	}
}

void agb_draw_line_mode4_bg(u32 scanline)
{	/*mode 4 pbg*/
	u32 i, temp32;
	u16 *pal_ptr, *dest_ptr;
	u8	*src_ptr;

	pal_ptr = (u16*)agb_palram;
	src_ptr	= &agb_vram[scanline * AGB_LCD_X];
	dest_ptr= &FrameBuffer[scanline * AGB_LCD_X];
	if(io_lcd->dispcnt & BIT4)src_ptr += AGB_LCD_SIZE;	/*obNobt@̑I*/
	for(i = 0; i < AGB_LCD_X; i++){
		temp32 = pal_ptr[*src_ptr++];
		*dest_ptr++ = SWAP_RB(temp32);
	}
}

void agb_draw_line_mode5_bg(u32 scanline)
{	/*mode 5 rbg}bv*/
	u32 i, temp32;
	u16 *src_ptr, *dest_ptr;

	src_ptr = (u16*)agb_vram;
	src_ptr = (u16*)&src_ptr[scanline * AGB_LCD_MODE5_X];
	dest_ptr= &FrameBuffer[scanline * AGB_LCD_X];
	if(io_lcd->dispcnt & BIT4)src_ptr += AGB_LCD_MODE5_X * AGB_LCD_MODE5_Y;	/*obNobt@̑I*/
	for(i = 0; i < AGB_LCD_MODE5_X; i++){
		temp32 = *src_ptr++;
		*dest_ptr++ = SWAP_RB(temp32);
	}
}

void agb_draw_line(u32 scanline)
{
	s32	i, dispcnt;

	dispcnt = io_lcd->dispcnt;

	switch((u8)(dispcnt & 7)){
	case 0:
	case 1:
	case 2:
		/*DxɂBG̕`揇*/
		//memset(&FrameBuffer[scanline * AGB_LCD_X], 0, AGB_LCD_X * 2);
		if(!scanline)memset(FrameBuffer, 0, AGB_LCD_SIZE * 2);
		for(i = 3; i >= 0; i--){
			if((io_lcd->bg0cnt & 0x03) == i){
				if(dispcnt & BIT8)agb_draw_line_mode0_bg(scanline, 0);
			}
			if((io_lcd->bg1cnt & 0x03) == i){
				if(dispcnt & BIT9)agb_draw_line_mode0_bg(scanline, 1);
			}
			if((io_lcd->bg2cnt & 0x03) == i){
				if(dispcnt & BIT10)agb_draw_line_mode0_bg(scanline, 2);
			}
			if((io_lcd->bg3cnt & 0x03) == i){
				if(dispcnt & BIT11)agb_draw_line_mode0_bg(scanline, 3);
			}
		}
		if(dispcnt & BIT12)agb_draw_line_sprite(scanline, 0);
		break;
	case 4:
	case 6:
		agb_draw_line_mode4_bg(scanline);
		if(dispcnt & BIT12)agb_draw_line_sprite(scanline, 1);
		break;
	case 5:
		if(scanline < 128)agb_draw_line_mode5_bg(scanline);
		if(dispcnt & BIT12)agb_draw_line_sprite(scanline, 1);
		break;
	case 3:
	default:
		agb_draw_line_mode3_bg(scanline);
		if(dispcnt & BIT12)agb_draw_line_sprite(scanline, 1);
		break;
	}
}

