
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#ifndef	_ARM7TDMI_H_
#define	_ARM7TDMI_H_

#include "types.h"

typedef struct{
	u32 reg[17];
	u32 *reg_ptr[17];
	u32 reg_fiq[8];
	u32 reg_svc[3];
	u32 reg_abt[3];
	u32 reg_irq[3];
	u32 reg_und[3];
	u32 cycle;
	u32	opcode;
	u32	opcode16;
	u32	running;
}ARM7TDMI;

#define	ARM_R0			arm.reg[0]
#define	ARM_R1			arm.reg[1]
#define	ARM_R2			arm.reg[2]
#define	ARM_R3			arm.reg[3]
#define	ARM_R4			arm.reg[4]
#define	ARM_R5			arm.reg[5]
#define	ARM_R6			arm.reg[6]
#define	ARM_R7			arm.reg[7]
#define	ARM_R8			arm.reg[8]
#define	ARM_R9			arm.reg[9]
#define	ARM_R10			arm.reg[10]
#define	ARM_R11			arm.reg[11]
#define	ARM_R12			arm.reg[12]
#define	ARM_R13			arm.reg[13]
#define	ARM_R14			arm.reg[14]
#define	ARM_R15			arm.reg[15]
#define	ARM_R16			arm.reg[16]
#define	ARM_SR		arm.reg[13]
#define	ARM_SP		arm.reg[13]
#define	ARM_LR		arm.reg[14]
#define	ARM_PC		arm.reg[15]
#define	ARM_CPSR	arm.reg[16]

#define	ARM_SPSR_FIQ		arm.reg_fiq[8]
#define	ARM_SPSR_IRQ		arm.reg_irq[2]
#define	ARM_SPSR_SVC		arm.reg_svc[2]
#define	ARM_SPSR_ABT		arm.reg_abt[2]
#define	ARM_SPSR_UND		arm.reg_und[2]

#define	ARM_N		0x80000000	/* Negative/Less Than*/
#define	ARM_Z		0x40000000	/* Zero/Equal*/
#define	ARM_C		0x20000000	/* Carry/Borrow/Extend*/
#define	ARM_V		0x10000000	/* Overflow*/
#define	ARM_I		0x00000080	/* IRQ Disable*/
#define	ARM_F		0x00000040	/* FIQ Disable*/
#define	ARM_T		0x00000020	/* THUMB State*/
#define	ARM_M4		0x00000010	/* Mode 4-0*/
#define	ARM_M3		0x00000008
#define	ARM_M2		0x00000004
#define	ARM_M1		0x00000002
#define	ARM_M0		0x00000001

#define	ARM_SF(_flag)	arm.reg[16] |= (_flag)
#define	ARM_RF(_flag)	arm.reg[16] &= ~(_flag)

#define	ARM_FN		(arm.reg[16] & 0x80000000)
#define	ARM_FZ		(arm.reg[16] & 0x40000000)
#define	ARM_FC		(arm.reg[16] & 0x20000000)
#define	ARM_FV		(arm.reg[16] & 0x10000000)

#define	ARM_LSB_FC	((arm.reg[16] >> 29) & 1)

#define	ARM_MODE_USR	0x10				/*CPU[htO*/
#define	ARM_MODE_FIQ	0x11
#define	ARM_MODE_IRQ	0x12
#define	ARM_MODE_SVC	0x13
#define	ARM_MODE_ABT	0x17
#define	ARM_MODE_UND	0x1B
#define	ARM_MODE_SYS	0x1F

#define	ARM_OPCODE			agb_read_mem32(arm.reg[15])
#define	ARM_OPCODE_D		agb_read_mem32(debug_pc)
#define	ARM_FOREG			((opcode >> 16) & 0xF)
#define	ARM_SOREG			(opcode & 0xF)
#define	ARM_DEREG			((opcode >> 12) & 0xF)
#define	ARM_COND			((opcode >> 28) & 0x0F)

#define	THUMB_OPCODE		agb_read_mem16(arm.reg[15])
#define	THUMB_OPCODE_D		agb_read_mem16(debug_pc)
#define	THUMB_DREG			(opcode & 0x7)
#define	THUMB_SREG			((opcode >> 3) & 0x7)
#define	THUMB_OREG			((opcode >> 6) & 0x7)

#define	REG_0_4				((opcode) & 0xF)
#define	REG_12_4			((opcode >> 12) & 0xF)
#define	REG_16_4			((opcode >> 16) & 0xF)

#define	ARM_FLAG_IMM		(opcode & BIT25)	/*IMMediate OPERAND flag*/
#define	ARM_FLAG_COND		(opcode & BIT20)	/*SET CONDition code flag*/

#endif	/*_ARM7TDMI_H_*/
