
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#ifndef	_AGB_DEFINES_
#define	_AGB_DEFINES_


#include "types.h"
#include "gba.h"

#ifdef _DEBUG
#define	_TITLE_		"Debug"
#else
#define	_TITLE_		"GameboyAdvanceVM"
#endif

typedef	struct{
	u16	dispcnt;
	u16 notused0;
	u16	dispstat;
	u16	vcount;
	
	u16	bg0cnt;
	u16	bg1cnt;
	u16	bg2cnt;
	u16	bg3cnt;

	u16	bg0hofs;
	u16	bg0vofs;
	u16	bg1hofs;
	u16	bg1vofs;
	u16	bg2hofs;
	u16	bg2vofs;
	u16	bg3hofs;
	u16	bg3vofs;

	u16	bg2pa;
	u16	bg2pb;
	u16	bg2pc;
	u16	bg2pd;

	u32	bg2x;
	u32	bg2y;

	u16	bg3pa;
	u16	bg3pb;
	u16	bg3pc;
	u16	bg3pd;

	u32	bg3x;
	u32	bg3y;

	u16	win0h;
	u16	win1h;
	u16	win0v;
	u16	win1v;
	u16	winin;
	u16	winout;
	u16	mosaic;

	u16	notused1;

	u16	bldcnt;
	u16	bldalpha;
	u16	bldy;
}AGBIOLCD;

typedef struct{
	u32	dma0sad;
	u32	dma0dad;
	u16	dma0cnt_l;
	u16	dma0cnt_h;
	u32	dma1sad;
	u32	dma1dad;
	u16	dma1cnt_l;
	u16	dma1cnt_h;
	u32	dma2sad;
	u32	dma2dad;
	u16	dma2cnt_l;
	u16	dma2cnt_h;
	u32	dma3sad;
	u32	dma3dad;
	u16	dma3cnt_l;
	u16	dma3cnt_h;
}AGBIODMA;

typedef struct{
	u16	tm0cnt_l;
	u16	tm0cnt_h;
	u16	tm1cnt_l;
	u16	tm1cnt_h;
	u16	tm2cnt_l;
	u16	tm2cnt_h;
	u16	tm3nt_l;
	u16	tm3cnt_h;
}AGBIOTM;

typedef struct{
	u16	keyinput;
	u16	keycnt;
}AGBIOKEY;

typedef struct{
	u16	ie;
	u16	If;
	u16	waitcnt;
	u16	notused0;
	u16	ime;
	u16	notused1;
}AGBIOIRQ;

#define	AGB_LCD_X			240
#define	AGB_LCD_Y			160
#define	AGB_LCD_MODE5_X		160
#define	AGB_LCD_MODE5_Y		128
#define	AGB_LCD_SIZE		38400
#define	AGB_SIZE_SYSROM		(0x4000 + 4)
#define	AGB_SIZE_EXRAM		(0x40000 + 4)
#define	AGB_SIZE_INRAM		(0x8000 + 4)
#define	AGB_SIZE_IORAM		(0x400 + 4)
#define	AGB_SIZE_PALRAM		(0x400 + 4)
#define	AGB_SIZE_VRAM		(0x18000 + 4)
#define	AGB_SIZE_OAM		(0x400 + 4)

#define	STR_LINE_SIZE		128
#define	STR_OFFSET_SIZE		32

/*BGRRGBɕϊ*/
#define	SWAP_RB(col)	((col & 0x7F00) >> 10) | (col & 0x03E0) | ((col & 0x001F) << 10)

#ifdef	_AGBWIN32_

#define	console_print(_str_)	\
{\
	if(fTraceDlg)m_pTraceDlg->Trace(_str_);\
}

#define	WM_DRAW_LCD		(WM_USER + 10)
#define	WM_DEBUG_NEXT	(WM_USER + 11)
#else

#define	console_print(_str_)

#endif	/*_AGBWIN32_*/

#endif	/*_AGB_DEFINES_*/
