// MemoryDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "MemoryDlg.h"

#define	_AGBWIN32_
#include "../include/hextoint.h"
#include "../include/externs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMemoryDlg _CAO


CMemoryDlg::CMemoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemoryDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CMemoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemoryDlg)
	DDX_Control(pDX, IDC_SCROLLBAR_MEMORY, m_scrMem);
	DDX_Control(pDX, IDC_LIST_MEMORY, m_lstMem);
	DDX_Control(pDX, IDC_COMBO_MEMORY, m_cmbMem);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMemoryDlg, CDialog)
	//{{AFX_MSG_MAP(CMemoryDlg)
	ON_WM_CLOSE()
	ON_CBN_SELCHANGE(IDC_COMBO_MEMORY, OnSelchangeComboMemory)
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_BUTTON_GO, OnButtonGo)
	ON_BN_CLICKED(IDC_RADIO_8BIT, OnRadio8bit)
	ON_BN_CLICKED(IDC_RADIO_16BIT, OnRadio16bit)
	ON_BN_CLICKED(IDC_RADIO_32BIT, OnRadio32bit)
	ON_LBN_SETFOCUS(IDC_LIST_MEMORY, OnSetfocusListMemory)
	ON_LBN_KILLFOCUS(IDC_LIST_MEMORY, OnKillfocusListMemory)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMemoryDlg bZ[W nh

void CMemoryDlg::OnOK()
{
	OnClose();
}

void CMemoryDlg::OnCancel()
{
	OnClose();
}

BOOL CMemoryDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_pFont	= NULL;

	/*tHgݒ*/
	m_pFont = new CFont;
	m_pFont->CreatePointFont(10, _T("Courier"));
	m_lstMem.SetFont(m_pFont);

	/*R{{bNX̃tH[JX*/
	m_fList		= FALSE;
	m_address	= 0x04000000;
	m_cmbMem.SetCurSel(3);
	m_scrMem.SetScrollRange(0, 0x800, TRUE);
	m_scrMem.SetScrollPos(m_address >> 17, TRUE);

	OnRadio8bit();

	/*tHg؂ւ̂߂̃_CAOACe̔zuݒ*/
	RECT	DlgSize;
	SetRect(&DlgSize, 0, 0, 500, 108);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW&~WS_THICKFRAME, FALSE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left,
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_LIST_MEMORY), 0, 2, 25,
					480, 80, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_SCROLLBAR_MEMORY), 0, 480, 25, 
					18, 80, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_COMBO_MEMORY), 0, 2, 2, 
					200, 20, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_RADIO_8BIT), 0, 220, 3,
					50, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_RADIO_16BIT), 0, 270, 3,
					50, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_RADIO_32BIT), 0, 320, 3,
					50, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_EDIT_ADDRESS), 0, 365, 3,
					40, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_BUTTON_GO), 0, 460, 3,
					35, 18, SWP_NOACTIVATE|SWP_NOZORDER);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMemoryDlg::ShowMemory()
{
	int x, y, adr;
	char str[128], tmp[16];

	m_lstMem.ResetContent();
	m_lstMem.AddString(m_label);

	for(adr = m_address, y = 0; y < 5; y++){	/*s*/
		sprintf(str, "%08X", adr);
		switch(m_size){
		case 32:
			for(x = 0; x < 4; x++){
				sprintf(tmp, "    %08X", agb_read_mem32(adr));
				adr += 4;
				strcat(str, tmp);
			}
			break;
		case 16:
			for(x = 0; x < 8; x++){
				sprintf(tmp, "  %04X", agb_read_mem16(adr));
				adr += 2;
				strcat(str, tmp);
			}
			break;
		default:
			for(x = 0; x < 16; x++){
				sprintf(tmp, " %02X", agb_read_mem8(adr));
				adr++;
				strcat(str, tmp);
			}
		}
		m_lstMem.AddString(str);
	}
}

void CMemoryDlg::OnClose() 
{
	fMemoryDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

void CMemoryDlg::OnSelchangeComboMemory() 
{	/*R{{bNXAhXw*/
	switch((BYTE)m_cmbMem.GetCurSel()){
	case 0 :m_address = 0x00000000;break;
	case 1 :m_address = 0x02000000;break;
	case 2 :m_address = 0x03000000;break;
	case 3 :m_address = 0x04000000;break;
	case 4 :m_address = 0x05000000;break;
	case 5 :m_address = 0x06000000;break;
	case 6 :m_address = 0x07000000;break;
	case 7 :m_address = 0x08000000;break;
	default:break;
	}

	m_scrMem.SetScrollPos(m_address >> 17, TRUE);
	ShowMemory();
}

BOOL CMemoryDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_KEYDOWN && m_fList){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return FALSE;
		case VK_DOWN:
			if((m_address + 0x10) >= 0x0FFFFFB0)m_address = 0x0FFFFFB0;
			else m_address += 0x10;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case VK_UP:
			if(m_address <= 0x00000000)m_address = 0x00000000;
			else m_address -= 0x10;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case VK_PRIOR:
			if(m_address <= 0x00000000)m_address = 0x00000000;
			else m_address -= 0x50;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case VK_NEXT:
			if((m_address + 0x50) >= 0x0FFFFFB0)m_address = 0x0FFFFFB0;
			else m_address += 0x50;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case VK_HOME:
			m_address = 0x00000000;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case VK_END:
			m_address = 0x0FFFFFB0;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CMemoryDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{	/*XN[o[ɂ铮*/
	UINT ScrPos = m_scrMem.GetScrollPos();

	switch(nSBCode) {
		case SB_LINEUP:	/*XN[o[̃{^*/
			if((m_address - 0x10)<=0x00000000)m_address = 0x00000000;
			else m_address -= 0x10;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case SB_LINEDOWN:
			if((m_address + 0x10) >= 0x0FFFFFB0)m_address = 0x0FFFFFB0;
			else m_address += 0x10;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case SB_PAGEUP:	/*XN[o[̗]*/
			if((m_address - 0x50) <= 0x00000000)m_address = 0x00000000;
			else m_address -= 0x50;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case SB_PAGEDOWN:
			if((m_address + 0x50) >= 0x0FFFFFB0)m_address = 0x0FFFFFB0;
			else m_address += 0x50;
			m_scrMem.SetScrollPos(m_address >> 17, TRUE);
			ShowMemory();
			break;
		case SB_THUMBPOSITION:	/*XN[o[̂܂*/
		case SB_THUMBTRACK:
			m_address = nPos << 17;
			if(nPos == 0x800)m_address = 0x0FFFFFB0;
			m_scrMem.SetScrollPos(nPos, TRUE);
			ShowMemory();
			break;
	}

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CMemoryDlg::OnButtonGo() 
{	/*w肳ꂽAhXɃWv*/
	char str[32];

	GetDlgItemText(IDC_MEMORY_ADDRESS, str, 10);
	m_address = HexToInt(str);
	ShowMemory();
}

void CMemoryDlg::OnRadio8bit() 
{	/*WrbgPʂŕ\*/
	m_size = 8;
	strcpy(m_label, "         +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F");
	CheckRadioButton(IDC_RADIO_32BIT, IDC_RADIO_8BIT, IDC_RADIO_8BIT);
	ShowMemory();
}

void CMemoryDlg::OnRadio16bit() 
{	/*PUrbgPʂŕ\*/
	m_size = 16;
	strcpy(m_label, "          +0    +2    +4    +6    +8    +A    +C    +E   ");
	CheckRadioButton(IDC_RADIO_32BIT, IDC_RADIO_8BIT, IDC_RADIO_16BIT);
	ShowMemory();
}

void CMemoryDlg::OnRadio32bit() 
{	/*RQrbgPʂŕ\*/
	m_size = 32;
	strcpy(m_label, "            +0          +4          +8          +C");
	CheckRadioButton(IDC_RADIO_32BIT, IDC_RADIO_8BIT, IDC_RADIO_32BIT);
	ShowMemory();
}

void CMemoryDlg::OnSetfocusListMemory() 
{
	m_fList = TRUE;
}

void CMemoryDlg::OnKillfocusListMemory() 
{
	m_fList = FALSE;
}

void CMemoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	delete 	m_pFont;
}
