
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/



void arm7tdmi_disasm_thumb_adc()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X adc r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_add()
{	/*Z2*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 3) & 0x7;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	if(opcode & BIT10){	/*1 = I = offset*/
		sprintf(str_shift, "#0x%X", offset);
	}else{					/*0 = I = register*/
		sprintf(str_shift, "r%d", offset);
	}

	sprintf(mnemonic, "%08X %04X add r%d, r%d, %s", debug_pc, opcode, rd, rs, str_shift);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_add_imm()
{	/*ADD Rd,#Offset8 Z3*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;	/*offset8*/
	rd		= (opcode & 0x7) >> 8;

	sprintf(mnemonic, "%08X %04X add r%d, #0x%X", debug_pc, opcode, rd, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_add_adr()
{	/*12*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;	/*offset8*/
	rd		= (opcode >> 8) & 0x7;
	
	sprintf(mnemonic, "%08X %04X add r%d, %s, #0x%X", 
		debug_pc, opcode, rd, ((opcode & BIT10)?"sp":"debug_pc"), offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_add_sp()
{	/*X^bN|C^ɃItZbgZ - 13*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0x7F;	/*offset7*/
	rd		= (opcode >> 8) & 0x7;
	
	sprintf(mnemonic, "%08X %04X add r%d, #%s0x%X", 
		debug_pc, opcode, rd, ((opcode & BIT7)?"-":""), offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_add_hi()
{	/*HiWX^ - 5*/
	u16	opcode;
	u32	rd, rs, hd, hs, h1, h2;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;
	hd		= rd;
	hs		= rs;

	if(opcode & BIT7){
		if(opcode & BIT6){	/*ADD Hd,Hs*/
			h1 = hd;
			h2 = hs;
		}else{					/*ADD Hd,Rs*/
			h1 = hd;
			h2 = rs;
		}
	}else{
		if(opcode & BIT6){	/*ADD Rd,Hs*/
			h1 = rd;
			h2 = hs;
		}else{
			h1 = 0;/*`H*/
			h2 = 0;
		}
	}

	sprintf(mnemonic, "%08X %04X add r%d, r%d", debug_pc, opcode, h1, h2);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_and()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X and r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_asr()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X asr r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_asr_imm()
{	/*1*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X asr r%d, r%d, #0x0%X", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_b()
{	/* - 18*/
	u16	opcode, offset;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0x7FF;

	sprintf(mnemonic, "%08X %04X b #0x%X", debug_pc, opcode, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_bxx()
{	/* - 16*/
	u16	opcode, offset;
	u32	cond;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;
	cond	= (opcode & 0xF) >> 8;

	sprintf(mnemonic, "%08X %04X b%s #0x%X", debug_pc, opcode, cond_table[cond], offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_bl()
{	/*ƃN - 19*/
	u16	opcode, offset;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0x7FF;

	sprintf(mnemonic, "%08X %04X bl #0x%X", debug_pc, opcode, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_bic()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X asr r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_bx()
{	/**/
	u16	opcode;

	opcode	= THUMB_OPCODE_D;

	sprintf(mnemonic, "%08X %04X bx", debug_pc, opcode);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_bx_hi()
{	/*Xe[gύX - 5*/
	u16	opcode;
	u32	rs, hs, h2;

	opcode	= THUMB_OPCODE_D;
	rs		= THUMB_SREG;
	hs		= rs;

	if(opcode & BIT7){	/*H1*/
		if(opcode & BIT6){	/*BX Hs*/
			h2 = hs;
		}else{					/*BX Rs*/
			h2 = rs;
		}
	}else{
		h2 = 0;/*`H*/
	}

	sprintf(mnemonic, "%08X %04X bx r%d, r%d", debug_pc, opcode, h2);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_cmn()
{	/*CMN Rd,Rs r4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X cmn r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_cmp()
{	/*CMP Rd,Rs r - 4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X asr r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_cmp_imm()
{	/*CMP Rd,#Offset8 r - 3*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;	/*offset8*/
	rd		= (opcode >> 8) & 0x7;

	sprintf(mnemonic, "%08X %04X cmp r%d, #0x%X", debug_pc, opcode, rd, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_cmp_hi()
{	/*HiWX^ - 5*/
	u16	opcode;
	u32	rd, rs, hd, hs, h1, h2;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;
	hd		= rd;
	hs		= rs;

	if(opcode & BIT7){	/*H1*/
		if(opcode & BIT6){	/*CMP Hd,Hs*/
			h1 = hd;
			h2 = hs;
		}else{					/*CMP Hd,Rs*/
			h1 = hd;
			h2 = rs;
		}
	}else{
		if(opcode & BIT6){	/*CMP Rd,Hs*/
			h1 = rd;
			h2 = hs;
		}else{
			h1 = 0;/*`H*/
			h2 = 0;
		}
	}

	sprintf(mnemonic, "%08X %04X cmp r%d, r%d", debug_pc, opcode, h1, h2);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_eor()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X eor r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldmia()
{	/*WX^̃[h^XgA - 15*/
	u32	bit, lst;
	u16	opcode, rlist;
	u32	rb;	
	char str_lst[64], str_reg[16];

	opcode	= THUMB_OPCODE_D;
	rlist	= opcode & 0xFF;	/*Rlist8*/
	rb		= (opcode >> 8) & 0x07;

	strcpy(str_lst, "");
	for(bit = BIT8, lst = 0; bit != BIT1; bit >>= 1){
		sprintf(str_reg, "r%d,", lst);
		strcat(str_lst, str_reg);
	}

	sprintf(mnemonic, "%08X %04X ldmia r%d!, {%s}", debug_pc, opcode, rb, str_lst);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldr()
{	/*WX^ItZbgɂ郍[h - 7*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X ldr r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldr_imm()
{	/*C~fBGCgItZbgɂ郍[h^XgA - 9*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X ldr r%d, [r%d, #0x%X]", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldrb()
{	/*WX^ItZbgɂ郍[h - 7*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X ldr r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldrb_imm()
{	/*C~fBGCgItZbgɂ郍[h^XgA - 9*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X ldrb r%d, [r%d, #0x%X]", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldrh()
{	/*oCg^n[t[h̃[h^XgAƕg - 8*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X ldrh r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldrh_imm()
{	/**/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X ldrh r%d, [r%d, #0x%X]", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldr_pc()
{	/*PC΃[h - 6*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;
	rd		= (opcode & 0x7) >> 8;

	sprintf(mnemonic, "%08X %04X ldr r%d, [debug_pc,#0x%X]", debug_pc, opcode, rd, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldr_sp()
{	/**/
	u16	opcode, offset;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;

	sprintf(mnemonic, "%08X %04X ldr [sp, #0x%X]", debug_pc, opcode, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldsb()
{	/*oCg^n[t[h̃[h^XgAƕg - 8*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X ldsb r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ldsh()
{	/*oCg^n[t[h̃[h^XgAƕg - 8*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X ldsh r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_lsl()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X lsl r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_lsl_imm()
{	/*1*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;	/*offset5*/
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X lsl r%d, r%d, #0x0%X", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_lsr()
{	/*Rd := Rd >> Rs*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X lsr r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_lsr_imm()
{	/*1*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X lsr r%d, r%d, #0x0%X", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_mov()
{	/*MOV Rd,#Offset8 ړ3*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;	/*offset8*/
	rd		= (opcode >> 8) & 0x7;

	sprintf(mnemonic, "%08X %04X mov r%d, #0x%X", debug_pc, opcode, rd, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_mov_hi()
{	/*HiWX^ - 5*/
	u16	opcode;
	u32	rd, rs, hd, hs, h1, h2;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;
	hd		= rd;
	hs		= rs;

	if(opcode & BIT7){	/*H1*/
		if(opcode & BIT6){	/*MOV Hd,Hs*/
			h1 = hd;
			h2 = hs;
		}else{
			h1 = hd;			/*MOV Hd,Rs*/
			h2 = rs;
		}
	}else{
		if(opcode & BIT6){	/*MOV Rd,Hs*/
			h1 = rd;
			h2 = hs;
		}else{
			h1 = 0;/*`H*/
			h2 = 0;
		}
	}

	sprintf(mnemonic, "%08X %04X movhi r%d, r%d", debug_pc, opcode, h1, h2);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_mul()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X mul r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_mvn()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X mvn r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_neg()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X neg r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_orr()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X orr r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_pop()
{	/*WX^PUSH/POP - 14*/
	u32	bit, lst;
	u16	opcode, rlist;
	char str_lst[64], str_reg[16];

	opcode	= THUMB_OPCODE_D;
	rlist	= opcode & 0xFF;	/*Rlist8*/

	strcpy(str_lst, "");
	for(bit = BIT8, lst = 8; bit != BIT1; bit >>= 1){
		sprintf(str_reg, "r%d,", lst);
		strcat(str_lst, str_reg);
	}
	if(opcode & BIT8)strcat(str_lst, "pc");

	sprintf(mnemonic, "%08X %04X pop {%s}", debug_pc, opcode, str_lst);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_push()
{	/*WX^PUSH/POP - 14*/
	u32	bit, lst;
	u16	opcode, rlist;
	char str_lst[64], str_reg[16];

	opcode	= THUMB_OPCODE_D;
	rlist	= opcode & 0xFF;	/*Rlist8*/

	strcpy(str_lst, "");
	for(bit = BIT1, lst = 0; bit != BIT8; bit <<= 1){
		sprintf(str_reg, "r%d,", lst);
		strcat(str_lst, str_reg);
	}
	if(opcode & BIT8)strcat(str_lst, "lr");

	sprintf(mnemonic, "%08X %04X push {%s}", debug_pc, opcode, str_lst);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_ror()
{	/*1*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X ror r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_sbc()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X sbc r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_stmia()
{	/*WX^̃[h^XgA - 15*/
	u32	bit, lst;
	u16	opcode, rlist;
	u32	rb;	
	char str_lst[64], str_reg[16];

	opcode	= THUMB_OPCODE_D;
	rlist	= opcode & 0xFF;	/*Rlist8*/
	rb		= (opcode >> 8) & 0x07;

	strcpy(str_lst, "");
	for(bit = BIT1, lst = 0; bit != BIT8; bit <<= 1){
		sprintf(str_reg, "r%d,", lst);
		strcat(str_lst, str_reg);
	}

	sprintf(mnemonic, "%08X %04X stmia r%d!, {%s}", debug_pc, opcode, rb, str_lst);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_str()
{	/*WX^ItZbgɂXgA - 7*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X str r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_str_imm()
{	/*C~fBGCgItZbgɂ郍[h^XgA - 9*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X str r%d, [r%d, #0x%X]", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_strb()
{	/*WX^ItZbgɂXgA - 7*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X strb r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_strb_imm()
{	/*C~fBGCgItZbgɂ郍[h^XgA - 9*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X strb r%d, [r%d, #0x%X]", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_strh()
{	/*oCg^n[t[h̃[h^XgAƕg - 8*/
	u16	opcode;
	u32	rd, rb, ro;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rb		= THUMB_SREG;
	ro		= THUMB_OREG;

	sprintf(mnemonic, "%08X %04X strh r%d, [r%d, r%d]", debug_pc, opcode, rd, rb, ro);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_strh_imm()
{	/**/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 6) & 0x1F;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	sprintf(mnemonic, "%08X %04X strh r%d, [r%d, #0x%X]", debug_pc, opcode, rd, rs, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_str_sp()
{	/*SP΃[h^XgA - 11*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;
	rd		= (opcode >> 8) & 0x7;

	sprintf(mnemonic, "%08X %04X str r%d, [sp, #0x%X]", debug_pc, opcode, rd, opcode);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_swi()
{	/*\tgEFA荞 - 17*/
	u16	opcode, offset;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;

	sprintf(mnemonic, "%08X %04X swi #0x%X", debug_pc, opcode, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_sub()
{	/*Z2*/
	u16	opcode, offset;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	offset	= (opcode >> 3) & 0x7;
	rd		= THUMB_DREG;
	rs		= THUMB_SREG;

	if(opcode & BIT10){	/*1 = I = offset*/
		sprintf(str_shift, "#0x%X", offset);
	}else{					/*0 = I = register*/
		sprintf(str_shift, "r%d", offset);
	}

	sprintf(mnemonic, "%08X %04X sub r%d, r%d, %s", debug_pc, opcode, rd, rs, str_shift);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_sub_imm()
{	/*SUB Rd,#Offset8 Z3*/
	u16	opcode, offset;
	u32	rd;

	opcode	= THUMB_OPCODE_D;
	offset	= opcode & 0xFF;	/*offset8*/
	rd		= (opcode >> 8) & 0x7;

	sprintf(mnemonic, "%08X %04X sub r%d, #0x%X", debug_pc, opcode, rd, offset);
	disasm_print(mnemonic);
}

void arm7tdmi_disasm_thumb_tst()
{	/*4*/
	u16	opcode;
	u32	rd, rs;

	opcode	= THUMB_OPCODE_D;
	rd		= THUMB_DREG;
	rs		= THUMB_DREG;

	sprintf(mnemonic, "%08X %04X tst r%d, r%d", debug_pc, opcode, rd, rs);
	disasm_print(mnemonic);
}

